package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.SancontrolplazosDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Sancontrolplazos;

/**
 * SancontrolplazosServiceImpl  
 * 
 *  
 */

@Service(value = "sancontrolplazosService")
public class SancontrolplazosServiceImpl implements SancontrolplazosService {

	@Autowired()
	private SancontrolplazosDao sancontrolplazosDao;

	/**
	 * Inserts a single row in the Sancontrolplazos table.
	 * 
	 * @param sancontrolplazos
	 *            Sancontrolplazos
	 * @return Sancontrolplazos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sancontrolplazos add(Sancontrolplazos sancontrolplazos) {
		return this.sancontrolplazosDao.add(sancontrolplazos);
	}

	/**
	 * Updates a single row in the Sancontrolplazos table.
	 * 
	 * @param sancontrolplazos
	 *            Sancontrolplazos
	 * @return Sancontrolplazos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sancontrolplazos update(Sancontrolplazos sancontrolplazos) {
		return this.sancontrolplazosDao.update(sancontrolplazos);
	}

	/**
	 * Finds a single row in the Sancontrolplazos table.
	 * 
	 * @param sancontrolplazos
	 *            Sancontrolplazos
	 * @return Sancontrolplazos
	 */
	public Sancontrolplazos find(Sancontrolplazos sancontrolplazos) {
		return (Sancontrolplazos) this.sancontrolplazosDao
				.find(sancontrolplazos);
	}

	/**
	 * Finds a List of rows in the Sancontrolplazos table.
	 * 
	 * @param sancontrolplazos
	 *            Sancontrolplazos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Sancontrolplazos> findAll(Sancontrolplazos sancontrolplazos,
			Pagination pagination) {
		return (List<Sancontrolplazos>) this.sancontrolplazosDao.findAll(
				sancontrolplazos, pagination);
	}

	/**
	 * Counts rows in the Sancontrolplazos table.
	 * 
	 * @param sancontrolplazos
	 *            Sancontrolplazos
	 * @return Long
	 */
	public Long findAllCount(Sancontrolplazos sancontrolplazos) {
		return this.sancontrolplazosDao.findAllCount(sancontrolplazos);
	}

	/**
	 * Finds rows in the Sancontrolplazos table using like.
	 * 
	 * @param sancontrolplazos
	 *            Sancontrolplazos
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Sancontrolplazos> findAllLike(
			Sancontrolplazos sancontrolplazos, Pagination pagination,
			Boolean startsWith) {
		return (List<Sancontrolplazos>) this.sancontrolplazosDao.findAllLike(
				sancontrolplazos, pagination, startsWith);
	}

	/**
	 * Counts rows in the Sancontrolplazos table using like.
	 * 
	 * @param sancontrolplazos
	 *            Sancontrolplazos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Sancontrolplazos sancontrolplazos,
			Boolean startsWith) {
		return this.sancontrolplazosDao.findAllLikeCount(sancontrolplazos,
				startsWith);
	}

	/**
	 * Deletes a single row in the Sancontrolplazos table.
	 * 
	 * @param sancontrolplazos
	 *            Sancontrolplazos
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Sancontrolplazos sancontrolplazos) {
		this.sancontrolplazosDao.remove(sancontrolplazos);
	}

	/**
	 * Deletes multiple rows in the Sancontrolplazos table.
	 * 
	 * @param sancontrolplazosList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Sancontrolplazos> sancontrolplazosList) {
		for (Sancontrolplazos sancontrolplazosAux : sancontrolplazosList) {
			this.sancontrolplazosDao.remove(sancontrolplazosAux);
		}
	}

}
