package com.ejie.y41b.service;


import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Sancontrolplazos;

/**
 * SancontrolplazosService  
 *  
 */

public interface SancontrolplazosService {

	/**
	 * Inserts a single row in the Sancontrolplazos table.
	 *
	 * @param sancontrolplazos Sancontrolplazos
	 * @return Sancontrolplazos
	 */
    Sancontrolplazos add(Sancontrolplazos sancontrolplazos);

	/**
	 * Updates a single row in the Sancontrolplazos table.
	 *
	 * @param sancontrolplazos Sancontrolplazos
	 * @return Sancontrolplazos
	 */
	Sancontrolplazos update(Sancontrolplazos sancontrolplazos);

	/**
	 * Finds a single row in the Sancontrolplazos table.
	 *
	 * @param sancontrolplazos Sancontrolplazos
	 * @return Sancontrolplazos
	 */
	Sancontrolplazos find(Sancontrolplazos sancontrolplazos);

	/**
	 * Finds a List of rows in the Sancontrolplazos table.
	 *
	 * @param sancontrolplazos Sancontrolplazos
	 * @param pagination Pagination
	 * @return List
	 */
	List<Sancontrolplazos> findAll(Sancontrolplazos sancontrolplazos, Pagination pagination);

	/**
	 * Counts rows in the Sancontrolplazos table.
	 *
	 * @param sancontrolplazos Sancontrolplazos
	 * @return Long
	 */
	Long findAllCount(Sancontrolplazos sancontrolplazos);
	
	/**
	 * Finds rows in the Sancontrolplazos table using like.
	 *
	 * @param sancontrolplazos Sancontrolplazos
	 * @param pagination Pagination
     * @param startsWith Boolean	 
	 * @return List
	 */
	List<Sancontrolplazos> findAllLike(Sancontrolplazos sancontrolplazos, Pagination pagination, Boolean startsWith) ;

	/**
	 * Counts rows in the Sancontrolplazos table using like.
	 *
	 * @param sancontrolplazos Sancontrolplazos
     * @param startsWith Boolean	 
	 * @return Long
	 */
	Long findAllLikeCount(Sancontrolplazos sancontrolplazos, Boolean startsWith) ;
  
	/**
	 * Deletes a single row in the Sancontrolplazos table.
	 *
	 * @param sancontrolplazos Sancontrolplazos
	 * @return 
	 */
	void remove(Sancontrolplazos sancontrolplazos);
	
	/**
	 * Deletes multiple rows in the Sancontrolplazos table.
	 *
	 * @param sancontrolplazosList List
	 * @return 
	 */	
	void removeMultiple(List<Sancontrolplazos> sancontrolplazosList);
    
}


