package com.ejie.y41b.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ParametrosDao;
import com.ejie.y41b.dao.SanbandejaDao;
import com.ejie.y41b.dao.SandoctempDao;
import com.ejie.y41b.dao.SanintervDao;
import com.ejie.y41b.dao.SantramexpDao;
import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.Sanbandeja;
import com.ejie.y41b.model.Sandoctemp;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.Santramexp;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * SanbandejaServiceImpl  
 * 
 *  
 */

@Service(value = "sanbandejaService")
public class SanbandejaServiceImpl implements SanbandejaService {

	@Autowired()
	private SanbandejaDao sanbandejaDao;

	@Autowired()
	private SandoctempDao sandoctempDao;

	@Autowired()
	private ParametrosDao parametrosDao;
	@Autowired()
	private SantramexpDao santramexpDao;
	@Autowired()
	private SanintervDao sanintervDao;

	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Inserts a single row in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @return Sanbandeja
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sanbandeja add(Sanbandeja sanbandeja) {
		return this.sanbandejaDao.add(sanbandeja);
	}

	/**
	 * Updates a single row in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @return Sanbandeja
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sanbandeja update(Sanbandeja sanbandeja) {
		return this.sanbandejaDao.update(sanbandeja);
	}

	/**
	 * Finds a single row in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @return Sanbandeja
	 */
	public Sanbandeja find(Sanbandeja sanbandeja) {
		return (Sanbandeja) this.sanbandejaDao.find(sanbandeja);
	}

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Sanbandeja> findAll(Sanbandeja sanbandeja, Pagination pagination) {
		return (List<Sanbandeja>) this.sanbandejaDao.findAll(sanbandeja, pagination);
	}

	/**
	 * Counts rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @return Long
	 */
	public Long findAllCount(Sanbandeja sanbandeja) {
		return this.sanbandejaDao.findAllCount(sanbandeja);
	}

	/**
	 * Finds rows in the Sanbandeja table using like.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Sanbandeja> findAllLike(Sanbandeja sanbandeja, Pagination pagination, Boolean startsWith) {
		return (List<Sanbandeja>) this.sanbandejaDao.findAllLike(sanbandeja, pagination, startsWith);
	}

	/**
	 * Counts rows in the Sanbandeja table using like.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Sanbandeja sanbandeja, Boolean startsWith) {
		return this.sanbandejaDao.findAllLikeCount(sanbandeja, startsWith);
	}

	/**
	 * Deletes a single row in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Sanbandeja sanbandeja) {
		this.sanbandejaDao.remove(sanbandeja);
	}

	/**
	 * Deletes multiple rows in the Sanbandeja table.
	 * 
	 * @param sanbandejaList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Sanbandeja> sanbandejaList) {
		for (Sanbandeja sanbandejaAux : sanbandejaList) {
			this.sanbandejaDao.remove(sanbandejaAux);
		}
	}

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */
	public List<Sanbandeja> dameBandeja(Sanbandeja sanbandeja, Pagination pagination, CensoMonitor censoMonitor,
			String perfil) {
		if (pagination != null) {
			if ("expedien.excodigo".equals(pagination.getSort())) {
				pagination.setSort("EXCODIGO");
			} else if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("expedien.codCompleto")) {
				pagination.setSort("EXPEDIENEXCOOR ASC, EXPEDIENEXNRAN ASC, CORRELATIVOPAD ");
			} else if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& "expedien.codCompleto".equals(pagination.getSort())) {
				pagination.setSort("EXPEDIENEXCOOR DESC, EXPEDIENEXNRAN DESC, CORRELATIVOPAD ");
			} else if ("fase.fnombre".equals(pagination.getSort())) {
				pagination.setSort("FASEFNOMBRE");
			} else if ("fase.fnombree".equals(pagination.getSort())) {
				pagination.setSort("FASEFNOMBREE");
			} else if ("santramexp.trnomtramCompletoes".equals(pagination.getSort())) {
				pagination.setSort("TRNOMBRE");
			} else if ("santramexp.trnomtramCompletoeu".equals(pagination.getSort())) {
				pagination.setSort("TRNOMBREE");
			} else if ("saninterv.uanombre".equals(pagination.getSort())) {
				pagination.setSort("SanintervUANOMBRE");
			} else if ("banomdoc".equals(pagination.getSort())) {
				pagination.setSort("BANOMDOC");
			} else if ("santramexp.trfecfin".equals(pagination.getSort())) {
				pagination.setSort("TRFECFIN");
			} else if ("baestado".equals(pagination.getSort())) {
				pagination.setSort("BAESTADO");
			} else if ("monitor.monombre".equals(pagination.getSort())) {
				pagination.setSort("MONITORMONOMBRE");
			} else if ("tramitesPendientes".equals(pagination.getSort())) {
				pagination.setSort("TRAMITESPENDIENTES");
			} else if ("avisos".equals(pagination.getSort())) {
				pagination.setSort("AVISOS");
			} else if ("bafeclimite".equals(pagination.getSort())) {
				pagination.setSort("BAFECLIMITE");
			} else if ("bafeclimiteliquidacion".equals(pagination.getSort())) {
				pagination.setSort("BAFECLIMITELIQUIDACION");
			}
		}
		List<Sanbandeja> listaBandeja = (List<Sanbandeja>) this.sanbandejaDao.dameBandeja(sanbandeja, pagination,
				censoMonitor, perfil);
		Santramexp santramexpAux = new Santramexp();

		Parametros parametros = new Parametros();

		parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
		parametros = this.parametrosDao.find(parametros);
		int minutos = 0;

		if (parametros != null && parametros.getValor() != null && Y41bUtils.isNumeric(parametros.getValor())) {
			minutos = Integer.parseInt(parametros.getValor());
		}

		for (Sanbandeja registroBandeja : listaBandeja) {
			// Batrid es el id del tramite en cuestin o del tramite relacionado
			// con el aviso
			if (registroBandeja.getBatrid() != null) {

				String idTramite = registroBandeja.getBatrid();
				TramiteComun tramiteComun = new TramiteComun();

				tramiteComun.setIdTramite(idTramite.toString());

				List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);
				santramexpAux = registroBandeja.getSantramexp();
				// si tiene un solo documento uno meterlo en el objeto
				if (listDocumentoHecho != null && listDocumentoHecho.size() == 1) {
					santramexpAux.setIndVariosDocumentos(Y41bConstantes.NO);

					santramexpAux.setU5codocumento(listDocumentoHecho.get(0).getU5codocumento());
					santramexpAux.setU5nofile(listDocumentoHecho.get(0).getU5nofile());
					santramexpAux.setU5sizefile(listDocumentoHecho.get(0).getU5sizefile());
					santramexpAux.setU5contenttypefile(listDocumentoHecho.get(0).getU5conttype());
					santramexpAux.setU5tedesfile(listDocumentoHecho.get(0).getU5tedesfile());
				} else {
					if (listDocumentoHecho != null && listDocumentoHecho.size() > 1) {
						// si tiene mas de un documento
						santramexpAux.setIndVariosDocumentos(Y41bConstantes.SI);
					}

				}
				// Formatear estado del tramite segun sus documentos
				if (registroBandeja.getBatipo() == null) {
					if (listDocumentoHecho != null) {
						boolean error = false;
						boolean sinLocalizarPorTiempo = false;
						boolean localizado = false;
						boolean firmado = false;

						for (Sandoctemp sandoctemp : listDocumentoHecho) {
							if (sandoctemp.getU5fechasollocalizador() != null
									&& !registroBandeja.getBaestado().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)
									&& !registroBandeja.getBaestado()
											.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
									&& !registroBandeja.getBaestado()
											.equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)) {
								if (sandoctemp != null && sandoctemp.getU5nofile() != null
										&& !com.ejie.y41b.utils.Y41bUtils.getExtensionFile(sandoctemp.getU5nofile())
												.equalsIgnoreCase(Y41bConstantes.PDF)) {
									SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

									Date d1 = null;
									Date d2 = null;
									long diffMinutes = 0;
									try {
										d1 = format.parse(format.format(sandoctemp.getU5fechasollocalizador()));

										d2 = format.parse(format.format(new Date()));

										long diff = d2.getTime() - d1.getTime();

										diffMinutes = diff / (Y41bConstantes.NUM_60 * Y41bConstantes.NUM_1000);
									} catch (ParseException e) {
										diffMinutes = 0;
									}

									if (diffMinutes > minutos) {

										error = true;
									} else {

										sinLocalizarPorTiempo = true;
									}
								} else {
									if (registroBandeja.getBaestado().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADO)) {
										firmado = true;
									} else if (!registroBandeja.getBaestado()
											.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA)
											&& !registroBandeja.getBaestado()
													.equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)
											&& !registroBandeja.getBaestado()
													.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
											&& !registroBandeja.getBaestado()
													.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION)
											&& !registroBandeja.getBaestado()
													.equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
										localizado = true;
									}
								}
							}
						}
						if (error) {
							registroBandeja.setBaestado(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION);
						} else if (sinLocalizarPorTiempo) {
							registroBandeja.setBaestado(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION);
						} else if (firmado) {
							registroBandeja.setBaestado(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
						} else if (localizado) {
							registroBandeja.setBaestado(Y41bConstantes.ESTADO_TRAMITE_LOCALIZADO);
						}
						registroBandeja.setSantramexp(santramexpAux);
					}
				}
			}
			// Si es un aviso formateamos el texto a mostrar
			/*
			 * Comentado por 86469: [Evolutivo Bandejas ] - Bandeja Sancionador
			 * if (!Y41bUtils.esNullOCadenaVacia(registroBandeja.getBatipo())) {
			 * Parametros parametrosAvisos = new Parametros();
			 * parametrosAvisos.setParametro(registroBandeja.getBatipo() +
			 * "_TEXTOES"); parametrosAvisos =
			 * this.parametrosDao.find(parametrosAvisos); String tipoAvisoES =
			 * parametrosAvisos.getValor(); parametrosAvisos = new Parametros();
			 * parametrosAvisos.setParametro(registroBandeja.getBatipo() +
			 * "_TEXTOEU"); parametrosAvisos =
			 * this.parametrosDao.find(parametrosAvisos); String tipoAvisoEU =
			 * parametrosAvisos.getValor();
			 * registroBandeja.getSantramexp().getTramite()
			 * .setTrnombre(tipoAvisoES);
			 * registroBandeja.getSantramexp().getTramite()
			 * .setTrnombree(tipoAvisoEU); }
			 */

			if (registroBandeja.getSantramexp().getTrfechaEnvioBOPVBOE() != null) {
				StringBuffer sbTrnombre = new StringBuffer();
				sbTrnombre.append(registroBandeja.getSantramexp().getTramite().getTrnombre());
				sbTrnombre.append(" (");
				sbTrnombre.append(Y41bUtils.parseDateToString(registroBandeja.getSantramexp().getTrfechaEnvioBOPVBOE(),
						Y41bConstantes.CASTELLANO));
				sbTrnombre.append(")");

				StringBuffer sbTrnombree = new StringBuffer();
				sbTrnombree.append(registroBandeja.getSantramexp().getTramite().getTrnombree());
				sbTrnombree.append(" (");
				sbTrnombree.append(Y41bUtils.parseDateToString(registroBandeja.getSantramexp().getTrfechaEnvioBOPVBOE(),
						Y41bConstantes.EUSKERA));
				sbTrnombree.append(")");

				registroBandeja.getSantramexp().getTramite().setTrnombre(sbTrnombre.toString());
				registroBandeja.getSantramexp().getTramite().setTrnombree(sbTrnombree.toString());
			}

			if (registroBandeja.getSantramexp().getTristelematica() != null) {
				StringBuffer sbTrnombre = new StringBuffer();
				sbTrnombre.append(registroBandeja.getSantramexp().getTramite().getTrnombre());
				sbTrnombre.append(" (");
				sbTrnombre.append(
						appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.CASTELLANO)));
				sbTrnombre.append(")");

				StringBuffer sbTrnombree = new StringBuffer();
				sbTrnombree.append(registroBandeja.getSantramexp().getTramite().getTrnombree());
				sbTrnombree.append(" (");
				sbTrnombree.append(
						appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.EUSKERA)));
				sbTrnombree.append(")");

				registroBandeja.getSantramexp().getTramite().setTrnombre(sbTrnombre.toString());
				registroBandeja.getSantramexp().getTramite().setTrnombree(sbTrnombree.toString());
			}

			// Consulta si hay documentos pendiente de firma
			Sandoctemp sandoctemp = new Sandoctemp();
			sandoctemp.setExpedien(new Expedien(registroBandeja.getExpedien().getExcodigo()));
			sandoctemp.setU5estadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
			Long numDocumentosPendienteFirma = this.sandoctempDao.findAllCount(sandoctemp);
			if (numDocumentosPendienteFirma > 0) {
				registroBandeja.setEstadoFirma(Y41bConstantes.VALOR_SI);
			}

		}
		return listaBandeja;

	}

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Long dameBandejaCount(Sanbandeja sanbandeja, CensoMonitor censoMonitor, String perfil) {
		return this.sanbandejaDao.dameBandejaCount(sanbandeja, censoMonitor, perfil);

	}

	/**
	 * Finds a single row in the Sanbandeja table.
	 * 
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void deleteBandejaAvisosCaducados() {
		this.sanbandejaDao.deleteBandejaAvisosCaducados();
	}

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */
	public List<Sanbandeja> dameBandejaTP(Sanbandeja sanbandeja, Pagination pagination, CensoMonitor censoMonitor,
			String perfil) {
		if (pagination != null) {
			if ("expedien.excodigo".equals(pagination.getSort())) {
				pagination.setSort("EXCODIGO");
			} else if ("fase.fnombre".equals(pagination.getSort())) {
				pagination.setSort("FASEFNOMBRE");
			} else if ("fase.fnombree".equals(pagination.getSort())) {
				pagination.setSort("FASEFNOMBREE");
			} else if ("santramexp.trnomtramCompletoes".equals(pagination.getSort())) {
				pagination.setSort("TRNOMBRE");
			} else if ("santramexp.trnomtramCompletoeu".equals(pagination.getSort())) {
				pagination.setSort("TRNOMBREE");
			} else if ("santramexp.trfecini".equals(pagination.getSort())) {
				pagination.setSort("TRFECINI");
			} else if ("baestado".equals(pagination.getSort())) {
				pagination.setSort("BAESTADO");
			} else if ("monitor.monombre".equals(pagination.getSort())) {
				pagination.setSort("MONITORMONOMBRE");
			}
		}
		List<Sanbandeja> listaBandeja = (List<Sanbandeja>) this.sanbandejaDao.dameBandejaTP(sanbandeja, pagination,
				censoMonitor, perfil);
		Santramexp santramexpAux = new Santramexp();

		Parametros parametros = new Parametros();

		parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
		parametros = this.parametrosDao.find(parametros);
		int minutos = 0;

		if (parametros != null && parametros.getValor() != null && Y41bUtils.isNumeric(parametros.getValor())) {
			minutos = Integer.parseInt(parametros.getValor());
		}

		for (Sanbandeja registroBandeja : listaBandeja) {
			// Batrid es el id del tramite en cuestin o del tramite relacionado
			// con el aviso
			if (registroBandeja.getBatrid() != null) {

				String idTramite = registroBandeja.getBatrid();
				TramiteComun tramiteComun = new TramiteComun();

				tramiteComun.setIdTramite(idTramite.toString());

				List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);
				santramexpAux = registroBandeja.getSantramexp();

				// Formatear estado del tramite segun sus documentos
				if (registroBandeja.getBatipo() == null) {
					if (listDocumentoHecho != null) {
						boolean error = false;
						boolean sinLocalizarPorTiempo = false;
						boolean localizado = false;
						boolean firmado = false;

						for (Sandoctemp sandoctemp : listDocumentoHecho) {
							if (sandoctemp.getU5fechasollocalizador() != null
									&& !registroBandeja.getBaestado().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)
									&& !registroBandeja.getBaestado()
											.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
									&& !registroBandeja.getBaestado()
											.equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)) {
								if (sandoctemp != null && sandoctemp.getU5nofile() != null
										&& !com.ejie.y41b.utils.Y41bUtils.getExtensionFile(sandoctemp.getU5nofile())
												.equalsIgnoreCase(Y41bConstantes.PDF)) {
									SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

									Date d1 = null;
									Date d2 = null;
									long diffMinutes = 0;
									try {
										d1 = format.parse(format.format(sandoctemp.getU5fechasollocalizador()));

										d2 = format.parse(format.format(new Date()));

										long diff = d2.getTime() - d1.getTime();

										diffMinutes = diff / (Y41bConstantes.NUM_60 * Y41bConstantes.NUM_1000);
									} catch (ParseException e) {
										diffMinutes = 0;
									}

									if (diffMinutes > minutos) {

										error = true;
									} else {

										sinLocalizarPorTiempo = true;
									}
								} else {
									if (registroBandeja.getBaestado().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADO)) {
										firmado = true;
									} else if (!registroBandeja.getBaestado()
											.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA)
											&& !registroBandeja.getBaestado()
													.equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)
											&& !registroBandeja.getBaestado()
													.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
											&& !registroBandeja.getBaestado()
													.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION)
											&& !registroBandeja.getBaestado()
													.equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
										localizado = true;
									}
								}
							}
						}
						if (error) {
							registroBandeja.setBaestado(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION);
						} else if (sinLocalizarPorTiempo) {
							registroBandeja.setBaestado(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION);
						} else if (firmado) {
							registroBandeja.setBaestado(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
						} else if (localizado) {
							registroBandeja.setBaestado(Y41bConstantes.ESTADO_TRAMITE_LOCALIZADO);
						}
						registroBandeja.setSantramexp(santramexpAux);
					}
				}
			}

			if (registroBandeja.getSantramexp().getTrfechaEnvioBOPVBOE() != null) {
				StringBuffer sbTrnombre = new StringBuffer();
				sbTrnombre.append(registroBandeja.getSantramexp().getTramite().getTrnombre());
				sbTrnombre.append(" (");
				sbTrnombre.append(Y41bUtils.parseDateToString(registroBandeja.getSantramexp().getTrfechaEnvioBOPVBOE(),
						Y41bConstantes.CASTELLANO));
				sbTrnombre.append(")");

				StringBuffer sbTrnombree = new StringBuffer();
				sbTrnombree.append(registroBandeja.getSantramexp().getTramite().getTrnombree());
				sbTrnombree.append(" (");
				sbTrnombree.append(Y41bUtils.parseDateToString(registroBandeja.getSantramexp().getTrfechaEnvioBOPVBOE(),
						Y41bConstantes.EUSKERA));
				sbTrnombree.append(")");

				registroBandeja.getSantramexp().getTramite().setTrnombre(sbTrnombre.toString());
				registroBandeja.getSantramexp().getTramite().setTrnombree(sbTrnombree.toString());
			}

			if (registroBandeja.getSantramexp().getTristelematica() != null) {
				StringBuffer sbTrnombre = new StringBuffer();
				sbTrnombre.append(registroBandeja.getSantramexp().getTramite().getTrnombre());
				sbTrnombre.append(" (");
				sbTrnombre.append(
						appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.CASTELLANO)));
				sbTrnombre.append(")");

				StringBuffer sbTrnombree = new StringBuffer();
				sbTrnombree.append(registroBandeja.getSantramexp().getTramite().getTrnombree());
				sbTrnombree.append(" (");
				sbTrnombree.append(
						appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.EUSKERA)));
				sbTrnombree.append(")");

				registroBandeja.getSantramexp().getTramite().setTrnombre(sbTrnombre.toString());
				registroBandeja.getSantramexp().getTramite().setTrnombree(sbTrnombree.toString());
			}

			// Mostrar una observacin que depende del tipo de tramite
			if (Y41bConstantes.TRAMITE_SANCIONES_COMUNICACION.equals(registroBandeja.getSantramexp().getTrcodigo())
					|| Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION
							.equals(registroBandeja.getSantramexp().getTrcodigo())
					|| Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO
							.equals(registroBandeja.getSantramexp().getTrcodigo())) {

				// Datos de santramexp
				santramexpAux = registroBandeja.getSantramexp();
				santramexpAux = this.santramexpDao.find(santramexpAux);

				// Datos de tramite (tabla basica)
				if (santramexpAux.getTrtridrel() != null) {
					Santramexp tramiteOrigenYRelacionado = new Santramexp();
					tramiteOrigenYRelacionado.setExpedien(santramexpAux.getExpedien());
					tramiteOrigenYRelacionado.setTrid(santramexpAux.getTrtridrel());
					tramiteOrigenYRelacionado = this.santramexpDao.find(tramiteOrigenYRelacionado);

					// Si es acuse, buscamos el tramite relacionado con la
					// notificacin
					if (Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO
							.equals(registroBandeja.getSantramexp().getTrcodigo()) && tramiteOrigenYRelacionado != null
							&& tramiteOrigenYRelacionado.getTrtridrel() != null) {

						Santramexp tramiteOrigenNoti = tramiteOrigenYRelacionado;
						tramiteOrigenYRelacionado = new Santramexp();
						tramiteOrigenYRelacionado.setExpedien(tramiteOrigenNoti.getExpedien());
						tramiteOrigenYRelacionado.setTrid(tramiteOrigenNoti.getTrtridrel());
						tramiteOrigenYRelacionado = this.santramexpDao.find(tramiteOrigenYRelacionado);

						registroBandeja.setObs_tramiteOrigenFecha(tramiteOrigenYRelacionado.getTrfecfin());
						if (tramiteOrigenYRelacionado.getTramite() != null) {
							registroBandeja
									.setObs_tramiteOrigenNombre(tramiteOrigenYRelacionado.getTramite().getTrnombre());
							registroBandeja
									.setObs_tramiteOrigenNombree(tramiteOrigenYRelacionado.getTramite().getTrnombree());
						}
					} else if (tramiteOrigenYRelacionado != null) {
						registroBandeja.setObs_tramiteOrigenFecha(tramiteOrigenYRelacionado.getTrfecfin());
						if (tramiteOrigenYRelacionado.getTramite() != null) {
							registroBandeja
									.setObs_tramiteOrigenNombre(tramiteOrigenYRelacionado.getTramite().getTrnombre());
							registroBandeja
									.setObs_tramiteOrigenNombree(tramiteOrigenYRelacionado.getTramite().getTrnombree());
						}
					}

					// notificaciones/comunicaciones/acuses: Nombre del
					// destinatario
					Saninterv intervinientes = new Saninterv();
					intervinientes.setUaidinterv(santramexpAux.getTruaidinterv());
					intervinientes = this.sanintervDao.find(intervinientes);
					if (null != intervinientes) {
						StringBuffer sbPerson = new StringBuffer();
						if (Y41bUtils.isFilled(intervinientes.getUanoco())) {
							sbPerson.append(intervinientes.getUanoco());
							sbPerson.append(" ");
						} else {
							if (Y41bUtils.isFilled(intervinientes.getUanombre())) {
								sbPerson.append(intervinientes.getUanombre());
								sbPerson.append(" ");
							}
							if (Y41bUtils.isFilled(intervinientes.getUaapellido1())) {
								sbPerson.append(intervinientes.getUaapellido1());
								sbPerson.append(" ");
							}
							if (Y41bUtils.isFilled(intervinientes.getUaapellido2())) {
								sbPerson.append(intervinientes.getUaapellido2());
								sbPerson.append(" ");
							}
						}
						registroBandeja.setObs_destinatarioNombre(sbPerson.toString());

						// notificaciones/comunicaciones: Tipo de destinatario
						registroBandeja.setObs_tipoDestinatario(intervinientes.getUatipointerv());
					}
				}
			}
		}
		return listaBandeja;

	}

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Long dameBandejaTPCount(Sanbandeja sanbandeja, CensoMonitor censoMonitor, String perfil) {
		return this.sanbandejaDao.dameBandejaTPCount(sanbandeja, censoMonitor, perfil);

	}

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */
	public List<Sanbandeja> dameBandejaAvisos(Sanbandeja sanbandeja, Pagination pagination, CensoMonitor censoMonitor,
			String perfil) {
		if (pagination != null) {
			if ("fase.fnombre".equals(pagination.getSort())) {
				pagination.setSort("FASEFNOMBRE");
			} else if ("fase.fnombree".equals(pagination.getSort())) {
				pagination.setSort("FASEFNOMBREE");
			} else if ("batexto".equals(pagination.getSort())) {
				pagination.setSort("BATEXTO");
			} else if ("batextoe".equals(pagination.getSort())) {
				pagination.setSort("BATEXTOE");
			} else if ("santramexp.trnomtramCompletoes".equals(pagination.getSort())) {
				pagination.setSort("BATIPO");
			} else if ("santramexp.trnomtramCompletoeu".equals(pagination.getSort())) {
				pagination.setSort("BATIPO");
			} else if ("bafeclimite".equals(pagination.getSort())) {
				pagination.setSort("BAFECLIMITE");
			}
		}
		List<Sanbandeja> listaBandeja = (List<Sanbandeja>) this.sanbandejaDao.dameBandejaAvisos(sanbandeja, pagination,
				censoMonitor, perfil);
		try {
			for (Sanbandeja registroBandeja : listaBandeja) {
				Parametros parametrosAvisos = new Parametros();
				parametrosAvisos.setParametro(registroBandeja.getBatipo() + "_TEXTOES");
				parametrosAvisos = this.parametrosDao.find(parametrosAvisos);
				String tipoAvisoES = parametrosAvisos.getValor();
				parametrosAvisos = new Parametros();
				parametrosAvisos.setParametro(registroBandeja.getBatipo() + "_TEXTOEU");
				parametrosAvisos = this.parametrosDao.find(parametrosAvisos);
				String tipoAvisoEU = parametrosAvisos.getValor();
				registroBandeja.setBatexto(tipoAvisoES);
				registroBandeja.setBatextoe(tipoAvisoEU);

			}
		} catch (Exception e) {
		}
		return listaBandeja;

	}

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Long dameBandejaAvisosCount(Sanbandeja sanbandeja, CensoMonitor censoMonitor, String perfil) {
		return this.sanbandejaDao.dameBandejaAvisosCount(sanbandeja, censoMonitor, perfil);

	}

}
