package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Sanbandeja;

/**
 * SanbandejaService  
 * 
 *  
 */

public interface SanbandejaService {

	/**
	 * Inserts a single row in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @return Sanbandeja
	 */
	Sanbandeja add(Sanbandeja sanbandeja);

	/**
	 * Updates a single row in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @return Sanbandeja
	 */
	Sanbandeja update(Sanbandeja sanbandeja);

	/**
	 * Finds a single row in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @return Sanbandeja
	 */
	Sanbandeja find(Sanbandeja sanbandeja);

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Sanbandeja> findAll(Sanbandeja sanbandeja, Pagination pagination);

	/**
	 * Counts rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @return Long
	 */
	Long findAllCount(Sanbandeja sanbandeja);

	/**
	 * Finds rows in the Sanbandeja table using like.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Sanbandeja> findAllLike(Sanbandeja sanbandeja, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Sanbandeja table using like.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Sanbandeja sanbandeja, Boolean startsWith);

	/**
	 * Deletes a single row in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @return
	 */
	void remove(Sanbandeja sanbandeja);

	/**
	 * Deletes multiple rows in the Sanbandeja table.
	 * 
	 * @param sanbandejaList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Sanbandeja> sanbandejaList);

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            String
	 * @return List
	 */
	List<Sanbandeja> dameBandeja(Sanbandeja sanbandeja, Pagination pagination,
			CensoMonitor censoMonitor, String perfil);

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            String
	 * @return List
	 */

	public Long dameBandejaCount(Sanbandeja sanbandeja,
			CensoMonitor censoMonitor, String perfil);

	/**
	 * Finds a single row in the Sanbandeja table.
	 */

	public void deleteBandejaAvisosCaducados();

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            String
	 * @return List
	 */
	List<Sanbandeja> dameBandejaTP(Sanbandeja sanbandeja,
			Pagination pagination, CensoMonitor censoMonitor, String perfil);

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            String
	 * @return List
	 */

	public Long dameBandejaTPCount(Sanbandeja sanbandeja,
			CensoMonitor censoMonitor, String perfil);

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            String
	 * @return List
	 */
	List<Sanbandeja> dameBandejaAvisos(Sanbandeja sanbandeja,
			Pagination pagination, CensoMonitor censoMonitor, String perfil);

	/**
	 * Finds a List of rows in the Sanbandeja table.
	 * 
	 * @param sanbandeja
	 *            Sanbandeja
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            String
	 * @return List
	 */

	public Long dameBandejaAvisosCount(Sanbandeja sanbandeja,
			CensoMonitor censoMonitor, String perfil);

}
