package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.RespuestaDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Respuesta;

/**
 * * RespuestaServiceImpl  
 * 
 *  
 */

@Service(value = "respuestaService")
public class RespuestaServiceImpl implements RespuestaService {

	private static final Logger logger = LoggerFactory
			.getLogger(RespuestaServiceImpl.class);
	@Autowired
	private RespuestaDao respuestaDao;

	/**
	 * Inserts a single row in the Respuesta table.
	 * 
	 * @param respuesta
	 *            Respuesta
	 * @return Respuesta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Respuesta add(Respuesta respuesta) {
		return this.respuestaDao.add(respuesta);
	}

	/**
	 * Updates a single row in the Respuesta table.
	 * 
	 * @param respuesta
	 *            Respuesta
	 * @return Respuesta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Respuesta update(Respuesta respuesta) {
		return this.respuestaDao.update(respuesta);
	}

	/**
	 * Finds a single row in the Respuesta table.
	 * 
	 * @param respuesta
	 *            Respuesta
	 * @return Respuesta
	 */
	public Respuesta find(Respuesta respuesta) {
		return (Respuesta) this.respuestaDao.find(respuesta);
	}

	/**
	 * Finds a List of rows in the Respuesta table.
	 * 
	 * @param respuesta
	 *            Respuesta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Respuesta> findAll(Respuesta respuesta, Pagination pagination) {
		return (List<Respuesta>) this.respuestaDao.findAll(respuesta,
				pagination);
	}

	/**
	 * Counts rows in the Respuesta table.
	 * 
	 * @param respuesta
	 *            Respuesta
	 * @return Long
	 */
	public Long findAllCount(Respuesta respuesta) {
		return this.respuestaDao.findAllCount(respuesta);
	}

	/**
	 * Finds rows in the Respuesta table using like.
	 * 
	 * @param respuesta
	 *            Respuesta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Respuesta> findAllLike(Respuesta respuesta,
			Pagination pagination, Boolean startsWith) {
		return (List<Respuesta>) this.respuestaDao.findAllLike(respuesta,
				pagination, startsWith);
	}

	/**
	 * Deletes a single row in the Respuesta table.
	 * 
	 * @param respuesta
	 *            Respuesta
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Respuesta respuesta) {
		this.respuestaDao.remove(respuesta);
	}

	/**
	 * Deletes multiple rows in the Respuesta table.
	 * 
	 * @param respuestaList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Respuesta> respuestaList) {
		for (Respuesta respuestaAux : respuestaList) {
			this.respuestaDao.remove(respuestaAux);
		}
	}

	/**
	 * Getter method for RespuestaDao
	 * 
	 * @return RespuestaDao
	 */
	public RespuestaDao getRespuestaDao() {
		return this.respuestaDao;
	}

	/**
	 * Setter method for RespuestaDao.
	 * 
	 * @param respuestaDao
	 *            RespuestaDao
	 * @return
	 */
	public void setRespuestaDao(RespuestaDao respuestaDao) {
		logger.info("Setting Dependency " + respuestaDao);
		this.respuestaDao = respuestaDao;
	}
}
