package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.RespuestaFileDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.RespuestaFile;

/**
 * * RespuestaFileServiceImpl  
 * 
 *  
 */

@Service(value = "respuestaFileService")
public class RespuestaFileServiceImpl implements RespuestaFileService {

	private static final Logger logger = LoggerFactory
			.getLogger(RespuestaFileServiceImpl.class);
	@Autowired
	private RespuestaFileDao respuestaFileDao;

	/**
	 * Inserts a single row in the RespuestaFile table.
	 * 
	 * @param respuestaFile
	 *            RespuestaFile
	 * @return RespuestaFile
	 */
	@Transactional(rollbackFor = Throwable.class)
	public RespuestaFile add(RespuestaFile respuestaFile) {
		return this.respuestaFileDao.add(respuestaFile);
	}

	/**
	 * Updates a single row in the RespuestaFile table.
	 * 
	 * @param respuestaFile
	 *            RespuestaFile
	 * @return RespuestaFile
	 */
	@Transactional(rollbackFor = Throwable.class)
	public RespuestaFile update(RespuestaFile respuestaFile) {
		return this.respuestaFileDao.update(respuestaFile);
	}

	/**
	 * Finds a single row in the RespuestaFile table.
	 * 
	 * @param respuestaFile
	 *            RespuestaFile
	 * @return RespuestaFile
	 */
	public RespuestaFile find(RespuestaFile respuestaFile) {
		return (RespuestaFile) this.respuestaFileDao.find(respuestaFile);
	}

	/**
	 * Finds a List of rows in the RespuestaFile table.
	 * 
	 * @param respuestaFile
	 *            RespuestaFile
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<RespuestaFile> findAll(RespuestaFile respuestaFile,
			Pagination pagination) {
		return (List<RespuestaFile>) this.respuestaFileDao.findAll(
				respuestaFile, pagination);
	}

	/**
	 * Counts rows in the RespuestaFile table.
	 * 
	 * @param respuestaFile
	 *            RespuestaFile
	 * @return Long
	 */
	public Long findAllCount(RespuestaFile respuestaFile) {
		return this.respuestaFileDao.findAllCount(respuestaFile);
	}

	/**
	 * Finds rows in the RespuestaFile table using like.
	 * 
	 * @param respuestaFile
	 *            RespuestaFile
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<RespuestaFile> findAllLike(RespuestaFile respuestaFile,
			Pagination pagination, Boolean startsWith) {
		return (List<RespuestaFile>) this.respuestaFileDao.findAllLike(
				respuestaFile, pagination, startsWith);
	}

	/**
	 * Deletes a single row in the RespuestaFile table.
	 * 
	 * @param respuestaFile
	 *            RespuestaFile
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(RespuestaFile respuestaFile) {
		this.respuestaFileDao.remove(respuestaFile);
	}

	/**
	 * Deletes multiple rows in the RespuestaFile table.
	 * 
	 * @param respuestaFileList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<RespuestaFile> respuestaFileList) {
		for (RespuestaFile respuestaFileAux : respuestaFileList) {
			this.respuestaFileDao.remove(respuestaFileAux);
		}
	}

	/**
	 * Getter method for RespuestaFileDao
	 * 
	 * @return RespuestaFileDao
	 */
	public RespuestaFileDao getRespuestaFileDao() {
		return this.respuestaFileDao;
	}

	/**
	 * Setter method for RespuestaFileDao.
	 * 
	 * @param respuestaFileDao
	 *            RespuestaFileDao
	 * @return
	 */
	public void setRespuestaFileDao(RespuestaFileDao respuestaFileDao) {
		logger.info("Setting Dependency " + respuestaFileDao);
		this.respuestaFileDao = respuestaFileDao;
	}
}
