package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.ArrayList;
import java.util.List;

import com.ejie.y41b.model.RespuestaFile;

/**
 * * RespuestaFileService  
 * 
 *  
 */

public interface RespuestaFileService {

	/**
	 * Inserts a single row in the RespuestaFile table.
	 * 
	 * @param respuestaFile
	 *            RespuestaFile
	 * @return RespuestaFile
	 */
	RespuestaFile add(RespuestaFile respuestaFile);

	/**
	 * Updates a single row in the RespuestaFile table.
	 * 
	 * @param respuestaFile
	 *            RespuestaFile
	 * @return RespuestaFile
	 */
	RespuestaFile update(RespuestaFile respuestaFile);

	/**
	 * Finds a single row in the RespuestaFile table.
	 * 
	 * @param respuestaFile
	 *            RespuestaFile
	 * @return RespuestaFile
	 */
	RespuestaFile find(RespuestaFile respuestaFile);

	/**
	 * Finds a List of rows in the RespuestaFile table.
	 * 
	 * @param respuestaFile
	 *            RespuestaFile
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<RespuestaFile> findAll(RespuestaFile respuestaFile,
			Pagination pagination);

	/**
	 * Counts rows in the RespuestaFile table.
	 * 
	 * @param respuestaFile
	 *            RespuestaFile
	 * @return Long
	 */
	Long findAllCount(RespuestaFile respuestaFile);

	/**
	 * Finds rows in the RespuestaFile table using like.
	 * 
	 * @param respuestaFile
	 *            RespuestaFile
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<RespuestaFile> findAllLike(RespuestaFile respuestaFile,
			Pagination pagination, Boolean startsWith);

	/**
	 * Deletes a single row in the RespuestaFile table.
	 * 
	 * @param respuestaFile
	 *            RespuestaFile
	 * @return
	 */
	void remove(RespuestaFile respuestaFile);

	/**
	 * Deletes multiple rows in the RespuestaFile table.
	 * 
	 * @param respuestaFileList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<RespuestaFile> respuestaFileList);

}
