/**
 * 
 */
package com.ejie.y41b.service;

import java.math.BigDecimal;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ArbexpDao;
import com.ejie.y41b.dao.ArbintervDao;
import com.ejie.y41b.dao.ExpedienDao;
import com.ejie.y41b.dao.SanexpDao;
import com.ejie.y41b.dao.SanintervDao;
import com.ejie.y41b.dao.SolarbDao;
import com.ejie.y41b.model.Arbexp;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Sanexp;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * RepresentantesServiceImpl  
 * 
 *  
 */
@Service(value = "RepresentantesService")
public class RepresentantesServiceImpl implements RepresentantesService {

	@Autowired()
	private ArbintervDao arbintervDao;

	@Autowired()
	private SanintervDao sanintervDao;

	@Autowired()
	private SolarbDao solarbDao;

	@Autowired()
	private ArbexpDao arbexpDao;

	@Autowired()
	private SanexpDao sanexpDao;

	@Autowired()
	private ExpedienDao expedienDao;

	@Autowired()
	private ArbintervService arbintervService;

	@Autowired()
	private SanexpService sanexpService;

	/**
	 * CargarIntervinienteRepresentanteARB
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Arbinterv
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbinterv cargarIntervinienteRepresentanteARB(
			Intervinientes intervinientes) {
		Arbinterv arbintervAux = new Arbinterv();
		boolean insercion = false;

		// Intervinientes intervinien = new Intervinientes();
		// intervinien.setIdExpediente(intervinientes.getIdExpediente());
		// intervinien.setTipoInterviniente(intervinientes.getTipoInterviniente());
		//
		// try {
		// intervinien = this.intervinientesDao
		// .findIntervinienteTipo(intervinien);
		// } catch (Exception e) {
		// intervinien = null;
		// }
		//
		// if (intervinien == null) {
		// intervinientes.setIdinterviniente(Y41bUIDGenerator.getInstance()
		// .generateId(Y41bConstantes.PK_SIZE));
		//
		// if (intervinientes.getExtranjero().equalsIgnoreCase(
		// Y41bConstantes.NO)) {
		// intervinientes.setNoraPaisId(null);
		// intervinientes.setNombrePais(null);
		//
		// if (intervinientes.getNoraProvinciaId().equals(
		// Y41bConstantes.CODIGO_PROVINCIA_ARABA)
		// || intervinientes.getNoraProvinciaId().equals(
		// Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA)
		// || intervinientes.getNoraProvinciaId().equals(
		// Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA)) {
		// intervinientes.setDireccionNocapv(null);
		// } else {
		// intervinientes.setNombreCalle(null);
		// intervinientes.setNoraCalleId(null);
		// intervinientes.setNoraPortalId(null);
		// intervinientes.setNombrePortal(null);
		// intervinientes.setNombrePiso(null);
		// }
		// } else {
		// intervinientes.setNoraProvinciaId(null);
		// intervinientes.setNombreProvincia(null);
		// intervinientes.setNoraMunicipioId(null);
		// intervinientes.setNombreMunicipio(null);
		// intervinientes.setNoraLocalidadId(null);
		// intervinientes.setNombreLocalidad(null);
		// intervinientes.setNoraCalleId(null);
		// intervinientes.setNombreCalle(null);
		// intervinientes.setNoraPortalId(null);
		// intervinientes.setNombrePortal(null);
		// intervinientes.setNombrePiso(null);
		// }
		// this.intervinientesDao.add(intervinientes);
		// } else {
		// intervinientes.setIdinterviniente(intervinien.getIdinterviniente());
		// this.intervinientesDao.update(intervinientes);
		// }

		/*
		 * REPRESENTANTE
		 */
		try {
			// arbintervAux.setUanif(intervinientes.getNif());
			arbintervAux.setUatipointerv(intervinientes.getTipoInterviniente());
			arbintervAux
					.setSolarb(new Solarb(intervinientes.getIdExpediente()));
			List<Arbinterv> listaIntervinientes = this.arbintervDao.findAll(
					arbintervAux, null);
			if (listaIntervinientes != null) {
				if (listaIntervinientes.size() > 0) {
					arbintervAux = listaIntervinientes.get(0);
				} else {
					insercion = true;
				}
			} else {
				insercion = true;
			}
		} catch (Exception e) {
			arbintervAux = null;
			insercion = true;
		}

		if (arbintervAux == null) {
			arbintervAux = new Arbinterv();
		}
		Solarb solarb = new Solarb();
		solarb.setSacodigo(intervinientes.getIdExpediente());
		arbintervAux.setSolarb(solarb);
		arbintervAux.setUanombre(intervinientes.getNombre());
		arbintervAux.setUaapellido1(intervinientes.getApellido1());
		arbintervAux.setUaapellido2(intervinientes.getApellido2());
		// sanintervAux.setUacoem(establecimiento.getEscoem());
		arbintervAux.setUanif(intervinientes.getNif());
		arbintervAux.setUanrtel(intervinientes.getNrtel());
		arbintervAux.setUanrtel2(intervinientes.getNrtel2());
		arbintervAux.setUaprovId(intervinientes.getNoraProvinciaId());
		arbintervAux.setUamunId(intervinientes.getNoraMunicipioId());
		arbintervAux.setUalocId(intervinientes.getNoraLocalidadId());
		arbintervAux.setUacalleId(intervinientes.getNoraCalleId());
		// El campo noraCpId no se utiliza. Nora y no nora guarda el cp en
		// nombrecp
		// arbintervAux.setUacpId(organismo.getNoraCpId());
		arbintervAux.setUacpId(intervinientes.getNombreCp());
		arbintervAux.setUaportalId(intervinientes.getNoraPortalId());
		if (intervinientes.getDireccionAntigua() != null
				&& intervinientes.getDireccionAntigua().length() > Y41bConstantes.NUM_40) {
			arbintervAux.setUadireAnt(intervinientes.getDireccionAntigua()
					.substring(0, Y41bConstantes.NUM_40));
		} else {
			arbintervAux.setUadireAnt(intervinientes.getDireccionAntigua());
		}
		arbintervAux.setUanombrePiso(intervinientes.getNombrePiso());
		if (Y41bUtils.esNullOCadenaVacia(intervinientes.getNoraProvinciaId())
				|| (!Y41bConstantes.ARABA.equals(intervinientes
						.getNoraProvinciaId())
						&& !Y41bConstantes.BIZKAIA.equals(intervinientes
								.getNoraProvinciaId()) && !Y41bConstantes.GIPUZKOA
						.equals(intervinientes.getNoraProvinciaId()))) {
			arbintervAux.setUadireNocapv(intervinientes.getDireccionNocapv());
		}
		arbintervAux.setUadireAnt(intervinientes.getDireccionAntigua());
		arbintervAux.setUaentidadId(intervinientes.getEntidadId());
		if (Y41bUtils.esNullOCadenaVacia(intervinientes.getNoraPaisId())) {
			arbintervAux.setUapaisId(Y41bConstantes.COD_PAIS_ESTADO);
		} else {
			arbintervAux.setUapaisId(intervinientes.getNoraPaisId());
		}
		arbintervAux.setUaurl(intervinientes.getEsteurl());
		arbintervAux.setUacoem(intervinientes.getCoem());

		arbintervAux.setUafecultmod(null);
		arbintervAux.setUausuultmod(null);

		if (!insercion) {
			this.arbintervDao.update(arbintervAux);
		} else {
			this.arbintervDao.add(arbintervAux);
		}

		return arbintervAux;
	}

	/**
	 * CargarIntervinienteRepresentanteSAN
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Saninterv
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Saninterv cargarIntervinienteRepresentanteSAN(
			Intervinientes intervinientes) {
		Saninterv sanintervAux = new Saninterv();
		boolean insercion = false;

		// Intervinientes intervinien = new Intervinientes();
		// intervinien.setIdExpediente(intervinientes.getIdExpediente());
		// intervinien.setTipoInterviniente(intervinientes.getTipoInterviniente());
		//
		// try {
		// intervinien = this.intervinientesDao
		// .findIntervinienteTipo(intervinien);
		// } catch (Exception e) {
		// intervinien = null;
		// }
		//
		// if (intervinien == null) {
		// intervinientes.setIdinterviniente(Y41bUIDGenerator.getInstance()
		// .generateId(Y41bConstantes.PK_SIZE));
		//
		// if (intervinientes.getExtranjero().equalsIgnoreCase(
		// Y41bConstantes.NO)) {
		// intervinientes.setNoraPaisId(null);
		// intervinientes.setNombrePais(null);
		//
		// if (intervinientes.getNoraProvinciaId().equals(
		// Y41bConstantes.CODIGO_PROVINCIA_ARABA)
		// || intervinientes.getNoraProvinciaId().equals(
		// Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA)
		// || intervinientes.getNoraProvinciaId().equals(
		// Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA)) {
		// intervinientes.setDireccionNocapv(null);
		// } else {
		// intervinientes.setNombreCalle(null);
		// intervinientes.setNoraCalleId(null);
		// intervinientes.setNoraPortalId(null);
		// intervinientes.setNombrePortal(null);
		// intervinientes.setNombrePiso(null);
		// }
		// } else {
		// intervinientes.setNoraProvinciaId(null);
		// intervinientes.setNombreProvincia(null);
		// intervinientes.setNoraMunicipioId(null);
		// intervinientes.setNombreMunicipio(null);
		// intervinientes.setNoraLocalidadId(null);
		// intervinientes.setNombreLocalidad(null);
		// intervinientes.setNoraCalleId(null);
		// intervinientes.setNombreCalle(null);
		// intervinientes.setNoraPortalId(null);
		// intervinientes.setNombrePortal(null);
		// intervinientes.setNombrePiso(null);
		// }
		// this.intervinientesDao.add(intervinientes);
		// } else {
		// intervinientes.setIdinterviniente(intervinien.getIdinterviniente());
		// this.intervinientesDao.update(intervinientes);
		// }

		/*
		 * REPRESENTANTE
		 */
		try {
			// sanintervAux.setUanif(intervinientes.getNif());
			sanintervAux.setUatipointerv(intervinientes.getTipoInterviniente());
			sanintervAux.setExpedien(new Expedien(intervinientes
					.getIdExpediente()));
			List<Saninterv> listaIntervinientes = this.sanintervDao.findAll(
					sanintervAux, null);
			if (listaIntervinientes != null) {
				if (listaIntervinientes.size() > 0) {
					sanintervAux = listaIntervinientes.get(0);
				} else {
					insercion = true;
				}
			} else {
				insercion = true;
			}
		} catch (Exception e) {
			sanintervAux = null;
			insercion = true;
		}

		if (sanintervAux == null) {
			sanintervAux = new Saninterv();
		}
		Expedien expedien = new Expedien();
		expedien.setExcodigo(intervinientes.getIdExpediente());
		sanintervAux.setExpedien(expedien);
		sanintervAux.setUanombre(intervinientes.getNombre());
		sanintervAux.setUaapellido1(intervinientes.getApellido1());
		sanintervAux.setUaapellido2(intervinientes.getApellido2());
		sanintervAux.setUacoem(intervinientes.getCoem());
		sanintervAux.setUaextranjero(intervinientes.getExtranjero().toString());

		sanintervAux.setUanif(intervinientes.getNif());
		sanintervAux.setUanrtel(intervinientes.getNrtel());
		sanintervAux.setUanrtel2(intervinientes.getNrtel2());
		sanintervAux.setUaprovId(intervinientes.getNoraProvinciaId());
		sanintervAux.setUamunId(intervinientes.getNoraMunicipioId());
		sanintervAux.setUalocId(intervinientes.getNoraLocalidadId());
		sanintervAux.setUacalleId(intervinientes.getNoraCalleId());
		// El campo noraCpId no se utiliza. Nora y no nora guarda el cp en
		// nombrecp
		// sanintervAux.setUacpId(organismo.getNoraCpId());
		sanintervAux.setUacpId(intervinientes.getNombreCp());
		sanintervAux.setUaportalId(intervinientes.getNoraPortalId());
		if (intervinientes.getDireccionAntigua() != null
				&& intervinientes.getDireccionAntigua().length() > Y41bConstantes.NUM_40) {
			sanintervAux.setUadireAnt(intervinientes.getDireccionAntigua()
					.substring(0, Y41bConstantes.NUM_40));
		} else {
			sanintervAux.setUadireAnt(intervinientes.getDireccionAntigua());
		}
		sanintervAux.setUanombrePiso(intervinientes.getNombrePiso());
		if (Y41bUtils.esNullOCadenaVacia(intervinientes.getNoraProvinciaId())
				|| (!Y41bConstantes.ARABA.equals(intervinientes
						.getNoraProvinciaId())
						&& !Y41bConstantes.BIZKAIA.equals(intervinientes
								.getNoraProvinciaId()) && !Y41bConstantes.GIPUZKOA
						.equals(intervinientes.getNoraProvinciaId()))) {
			sanintervAux.setUadireNocapv(intervinientes.getDireccionNocapv());
		}
		sanintervAux.setUadireAnt(intervinientes.getDireccionAntigua());
		sanintervAux.setUaentidad_id(intervinientes.getEntidadId());
		if (Y41bUtils.esNullOCadenaVacia(intervinientes.getNoraPaisId())) {
			sanintervAux.setUapaisId(Y41bConstantes.COD_PAIS_ESTADO);
		} else {
			sanintervAux.setUapaisId(intervinientes.getNoraPaisId());
		}
		sanintervAux.setUaurl(intervinientes.getEsteurl());

		sanintervAux.setUafecultmod(null);
		sanintervAux.setUausuultmod(null);

		if (!insercion) {
			this.sanintervDao.update(sanintervAux);
		} else {
			this.sanintervDao.add(sanintervAux);
		}

		return sanintervAux;
	}

	/**
	 * Update a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void eliminarRepresentacionARB(Intervinientes intervinientes,
			CensoMonitor censoMonitor) throws Exception {

		// TramiteComun tramiteComun = new TramiteComun();
		// tramiteComun.setIdExpediente(intervinientes.getIdExpediente());
		//
		// intervinientes = this.intervinientesDao
		// .findIntervinienteTipo(intervinientes);
		//

		Arbinterv arbinterv = new Arbinterv();
		arbinterv.setUatipointerv(intervinientes.getTipoInterviniente());

		Solarb solarb = new Solarb();
		solarb.setSacodigo(intervinientes.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbinterv.setSolarb(solarb);
		try {
			arbinterv = this.arbintervDao.findAll(arbinterv, null).get(0);
		} catch (Exception e) {
			arbinterv = null;
		}

		this.arbintervDao.updateTipointervinienteAnterior(arbinterv,
				intervinientes.getTipoInterviniente());

		// if (intervinientes.getTipoInterviniente().equals(
		// Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE)
		// || intervinientes
		// .getTipoInterviniente()
		// .equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO))
		// {
		// intervinientes
		// .setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_ANTERIOR);
		// } else if (intervinientes.getTipoInterviniente().equals(
		// Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO)
		// || intervinientes
		// .getTipoInterviniente()
		// .equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO))
		// {
		// intervinientes
		// .setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_ANTERIOR);
		// }
		//
		// this.intervinientesDao.updateTipoInterviniente(intervinientes);

		// ESTO ESTA DANDO PROBLEMAS
		if (intervinientes != null
				&& intervinientes.getTipoInterviniente() != null) {
			if (intervinientes
					.getTipoInterviniente()
					.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE)) {
				this.arbintervService
						.actualizarParticipantPlatea(
								solarb,
								this.arbintervService.dameInterviniente(
										intervinientes.getIdExpediente(),
										Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE),
								censoMonitor, true);
			} else if (intervinientes
					.getTipoInterviniente()
					.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO)) {
				this.arbintervService
						.actualizarParticipantPlatea(
								solarb,
								this.arbintervService.dameInterviniente(
										intervinientes.getIdExpediente(),
										Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO),
								censoMonitor, true);

			}
		}

		// TramiteHechoDetalle tramiteHechoDetalle = new
		// TramiteHechoDetalle();
		// tramiteHechoDetalle.setHdcodigo(tramiteComun.getIdExpediente());
		//
		// tramiteHechoDetalle
		// .setTrcodigo(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);
		// try {
		// tramiteHechoDetalle = this.tramiteHechoDao
		// .findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalle);
		// } catch (Exception e) {
		// }

		// si est el tramite de registro de solicitud tramitado
		// if (tramiteHechoDetalle != null
		// && tramiteHechoDetalle.getEhfechafin() != null) {
		// this.soltramexpService
		// .actualizarParticipacionReclamante(tramiteComun);
		// }
		// }
	}

	/**
	 * validarRepresentacionARB
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param censoMonitor
	 *            CensoMonitor
	 * 
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void validarRepresentacionARB(Intervinientes intervinientes,
			CensoMonitor censoMonitor) throws Exception {

		Arbinterv arbinterv = new Arbinterv();
		arbinterv.setUaidinterv(new BigDecimal(intervinientes
				.getIdinterviniente()));

		Solarb solarb = new Solarb();
		solarb.setSacodigo(intervinientes.getIdExpediente());
		arbinterv.setSolarb(solarb);
		solarb = this.solarbDao.find(solarb);

		Arbexp arbexp = new Arbexp();
		arbexp.setExcodigo(solarb.getSacodigo());

		arbexp = this.arbexpDao.find(arbexp);

		if (Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO
				.equals(intervinientes.getTipoInterviniente())) {

			this.arbintervDao
					.updateTipointerviniente(
							arbinterv,
							Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE);

			// si esta creado el expediente en PLATEA
			if (arbexp != null && arbexp.getPlatea() != null
					&& Y41bConstantes.SI.equalsIgnoreCase(arbexp.getPlatea())) {
				this.arbintervService
						.actualizarParticipantPlatea(
								solarb,
								this.arbintervService.dameInterviniente(
										intervinientes.getIdExpediente(),
										Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE),
								censoMonitor, false);
			}
			// 0156281: Validar representacin - Verificar que est tramitado
			// registro de solicitud
			else {
				throw new Y41bUDAException(
						"error.representante.validarRepresentacionException",
						true, new Exception());
			}
			// 0156281: Validar representacin - Verificar que est tramitado
			// registro de solicitud

		} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO
				.equals(intervinientes.getTipoInterviniente())) {

			this.arbintervDao
					.updateTipointerviniente(
							arbinterv,
							Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO);

			// si esta creada la participacion en PLATEA
			if (arbexp != null
					&& Y41bConstantes.SI.equals(arbexp.getExpartrecl())) {
				this.arbintervService
						.actualizarParticipantPlatea(
								solarb,
								this.arbintervService.dameInterviniente(
										intervinientes.getIdExpediente(),
										Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO),
								censoMonitor, false);
			}
			// 0156281: Validar representacin - Verificar que est tramitado
			// registro de solicitud
			else {
				throw new Y41bUDAException(
						"error.representante.validarRepresentacionException",
						true, new Exception());
			}
			// 0156281: Validar representacin - Verificar que est tramitado
			// registro de solicitud
		}
	}

	/**
	 * Update a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void eliminarRepresentacionSAN(Intervinientes intervinientes)
			throws Exception {

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(intervinientes.getIdExpediente());
		//
		// intervinientes = this.intervinientesDao
		// .findIntervinienteTipo(intervinientes);
		//
		// if (intervinientes != null
		// && intervinientes.getTipoInterviniente() != null
		// && (intervinientes
		// .getTipoInterviniente()
		// .equals(Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO)
		// || intervinientes
		// .getTipoInterviniente()
		// .equals(Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO_NO_VALIDADO)))
		// {

		Saninterv saninterv = new Saninterv();
		saninterv.setUatipointerv(intervinientes.getTipoInterviniente());

		Expedien expedien = new Expedien();
		expedien.setExcodigo(intervinientes.getIdExpediente());
		expedien = this.expedienDao.find(expedien);

		saninterv.setExpedien(new Expedien(expedien.getExcodigo()));
		try {
			saninterv = this.sanintervDao.findAll(saninterv, null).get(0);
		} catch (Exception e) {
			saninterv = null;
		}

		this.sanintervDao.updateTipointervinienteAnterior(saninterv,
				intervinientes.getTipoInterviniente());

		// intervinientes
		// .setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO_ANTERIOR);
		//
		// this.intervinientesDao.updateTipoInterviniente(intervinientes);

		// ESTO ESTA DANDO PROBLEMAS
		this.sanexpService.actualizarParticipantPlatea(expedien,
				this.sanintervDao.dameSancionado(intervinientes
						.getIdExpediente()), null, true);

		// TramiteHechoDetalle tramiteHechoDetalle = new
		// TramiteHechoDetalle();
		// tramiteHechoDetalle.setHdcodigo(tramiteComun.getIdExpediente());
		//
		// tramiteHechoDetalle
		// .setTrcodigo(Y41bConstantes.TRAMITE_REGISTRO_SOLICITUD);
		// try {
		// tramiteHechoDetalle = this.tramiteHechoDao
		// .findUltimoTramiteHechoPorTipoTramite(tramiteHechoDetalle);
		// } catch (Exception e) {
		// }

		// si est el tramite de registro de solicitud tramitado
		// if (tramiteHechoDetalle != null
		// && tramiteHechoDetalle.getEhfechafin() != null) {
		// this.soltramexpService
		// .actualizarParticipacionReclamante(tramiteComun);
		// }
		// }
	}

	/**
	 * validarRepresentacionSAN
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param censoMonitor
	 *            CensoMonitor
	 * 
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void validarRepresentacionSAN(Intervinientes intervinientes,
			CensoMonitor censoMonitor) throws Exception {

		Saninterv saninterv = new Saninterv();
		saninterv.setUaidinterv(new BigDecimal(intervinientes
				.getIdinterviniente()));

		Expedien expedien = new Expedien();
		expedien.setExcodigo(intervinientes.getIdExpediente());
		saninterv.setExpedien(expedien);
		try {
			saninterv = this.sanintervDao.findAll(saninterv, null).get(0);
		} catch (Exception e) {
			saninterv = null;
		}
		expedien = this.expedienDao.find(expedien);

		Sanexp sanexp = new Sanexp();
		sanexp.setExcodigo(expedien.getExcodigo());

		sanexp = this.sanexpDao.find(sanexp);

		if (saninterv != null
				&& saninterv.getUatipointerv() != null
				&& (saninterv.getUatipointerv()
						.equals(Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO_NO_VALIDADO))) {

			intervinientes
					.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO);

			this.sanintervDao.updateTipointerviniente(saninterv,
					intervinientes.getTipoInterviniente());

			// si esta creado el expediente en PLATEA
			if (sanexp != null && sanexp.getPlatea() != null
					&& Y41bConstantes.SI.equalsIgnoreCase(sanexp.getPlatea())) {
				this.sanexpService.actualizarParticipantPlatea(expedien,
						this.sanintervDao.dameSancionado(intervinientes
								.getIdExpediente()), null, false);
			}
			// 0156281: Validar representacin - Verificar que est tramitado
			// registro de solicitud
			else {
				throw new Y41bUDAException(
						"error.representante.validarRepresentacionException",
						true, new Exception());
			}
			// 0156281: Validar representacin - Verificar que est tramitado
			// registro de solicitud

		}
	}

}
