/**
 * 
 */
package com.ejie.y41b.service;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Saninterv;

/**
 * RepresentantesService  
 * 
 *  
 */
public interface RepresentantesService {

	/**
	 * CargarIntervinienteRepresentanteARB
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Arbinterv
	 */
	Arbinterv cargarIntervinienteRepresentanteARB(Intervinientes intervinientes);

	/**
	 * CargarIntervinienteRepresentanteSAN
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Saninterv
	 */
	Saninterv cargarIntervinienteRepresentanteSAN(Intervinientes intervinientes);

	/**
	 * Update a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @throws Exception
	 *             Exception
	 */
	void eliminarRepresentacionSAN(Intervinientes intervinientes)
			throws Exception;

	/**
	 * Update a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @throws Exception
	 *             Exception
	 */
	void eliminarRepresentacionARB(Intervinientes intervinientes,
			CensoMonitor censoMonitor) throws Exception;

	/**
	 * validarRepresentacionSAN
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param censoMonitor
	 *            CensoMonitor
	 * 
	 * @throws Exception
	 *             Exception
	 */
	public void validarRepresentacionSAN(Intervinientes intervinientes,
			CensoMonitor censoMonitor) throws Exception;

	/**
	 * validarRepresentacionARB
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param censoMonitor
	 *            CensoMonitor
	 * 
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void validarRepresentacionARB(Intervinientes intervinientes,
			CensoMonitor censoMonitor) throws Exception;
}
