package com.ejie.y41b.service;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

import javax.annotation.Resource;
import javax.sql.rowset.serial.SerialBlob;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.aa66.IdentTramitadorCondicionalWs;
import com.ejie.y41b.aa66.IdentTramitadorWs;
import com.ejie.y41b.aa66.SituacionEntregaWs;
import com.ejie.y41b.aa66.ZipEnvioWs;
import com.ejie.y41b.adapter.services.AA66ServiceImpl;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ArbadhsolDao;
import com.ejie.y41b.dao.ArbadhtramDao;
import com.ejie.y41b.dao.ArbtramexpDao;
import com.ejie.y41b.dao.EnviosPorRemesaDao;
import com.ejie.y41b.dao.ParametrosDao;
import com.ejie.y41b.dao.RemesaDao;
import com.ejie.y41b.dao.SantramexpDao;
import com.ejie.y41b.dao.SituacionY41BConCorreosDao;
import com.ejie.y41b.dao.TramiteHechoDao;
import com.ejie.y41b.dao.TramiteInspeccionDao;
import com.ejie.y41b.jms.Y41bRemesasClientJMSService;
import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.Arbadhtram;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.EnviosPorRemesa;
import com.ejie.y41b.model.NotificacionesComunicacionesBusqueda;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.Remesa;
import com.ejie.y41b.model.RemesaBusqueda;
import com.ejie.y41b.model.Santramexp;
import com.ejie.y41b.model.SituacionCorreos;
import com.ejie.y41b.model.SituacionY41BConCorreos;
import com.ejie.y41b.model.TramiteHecho;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.exception.Y41bAA66Exception;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.ws.Y41bUtilsWS;

/**
 * RemesaServiceImpl  
 * 
 *  
 */

@Service(value = "remesaService")
public class RemesaServiceImpl implements RemesaService {

	private static final Logger logger = LoggerFactory.getLogger(RemesaServiceImpl.class);

	@Autowired
	private RemesaDao remesaDao;

	@Autowired
	private TramiteHechoDao tramiteHechoDao;

	@Autowired
	private SantramexpDao santramexpDao;

	@Autowired
	private EnviosPorRemesaDao enviosPorRemesaDao;
	@Autowired
	private EnviosPorRemesaService enviosPorRemesaService;

	@Autowired
	private ParametrosDao parametrosDao;

	@Autowired
	private SituacionY41BConCorreosDao situacionY41BConCorreosDao;

	@Autowired
	private Y41bRemesasClientJMSService remesasClientJMSService;

	@Autowired
	private CensoMonitorService censoMonitorService;

	@Autowired
	private SoltramexpService soltramexpService;

	@Autowired
	private SantramexpService santramexpService;

	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;
	@Autowired
	private Arbtramexp3Service arbtramexp3Service;
	@Autowired
	private ArbtramexpDao arbtramexpDao;
	@Autowired
	private ArbadhtramService arbadhtramService;
	@Autowired
	private ArbadhtramDao arbadhtramDao;
	@Autowired
	private ArbadhsolDao arbadhsolDao;

	@Autowired
	private InstramexpService instramexpService;
	@Autowired
	private TramiteInspeccionDao tramiteInspeccionDao;

	/**
	 * Comprueba si se ha superado el tiempo mximo en Solicitada para proceder
	 * a cambiarle el estado
	 * 
	 * @param remesa
	 *            Remesa
	 * 
	 * @return Remesa
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Remesa addRemesa(Remesa remesa) {
		RemesaServiceImpl.logger.info("Inicio del mtodo addRemesa");
		Remesa remesaRdo = this.add(remesa);

		validacionTamanoRemesa(remesa);

		if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(remesa.getRmtipoproc())) {
			NotificacionesComunicacionesBusqueda filterNotifComuni = new NotificacionesComunicacionesBusqueda();
			filterNotifComuni.setRmcodigo(remesa.getRmcodigo());

			List<NotificacionesComunicacionesBusqueda> listNotifiComuniBusqueda = this.santramexpService
					.findAllNotifiComuni(filterNotifComuni, null);

			for (NotificacionesComunicacionesBusqueda notificacionesComunicacionesBusquedaAux : listNotifiComuniBusqueda) {
				if (notificacionesComunicacionesBusquedaAux.getExtranjero() != null
						&& notificacionesComunicacionesBusquedaAux.getExtranjero().equals("")) {
					RemesaServiceImpl.logger.error("Se lanza la excepcin Sin Sede");
					throw new Y41bUDAException("error.remesa.sinSedeException", true, new Exception());
				}
			}
		} else if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(remesa.getRmtipoproc())) {
			NotificacionesComunicacionesBusqueda filterNotifComuni = new NotificacionesComunicacionesBusqueda();
			filterNotifComuni.setRmcodigo(remesa.getRmcodigo());

			List<NotificacionesComunicacionesBusqueda> listNotifiComuniBusqueda = this.soltramexpService
					.findAllNotifiComuni(filterNotifComuni, null);

			for (NotificacionesComunicacionesBusqueda notificacionesComunicacionesBusquedaAux : listNotifiComuniBusqueda) {
				if (notificacionesComunicacionesBusquedaAux.getExtranjero() != null
						&& notificacionesComunicacionesBusquedaAux.getExtranjero().equals("")) {
					RemesaServiceImpl.logger.error("Se lanza la excepcin Sin Sede");
					throw new Y41bUDAException("error.remesa.sinSedeException", true, new Exception());
				}
			}
		} else if (Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA.equals(remesa.getRmtipoproc())
				|| Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA.equals(remesa.getRmtipoproc())
				|| Y41bConstantes.TIPO_PROC_ADHESIONES_MOD.equals(remesa.getRmtipoproc())) {
			NotificacionesComunicacionesBusqueda filterNotifComuni = new NotificacionesComunicacionesBusqueda();
			filterNotifComuni.setRmcodigo(remesa.getRmcodigo());

			List<NotificacionesComunicacionesBusqueda> listNotifiComuniBusqueda = this.arbadhtramService
					.findAllNotifiComuni(filterNotifComuni, null);

			for (NotificacionesComunicacionesBusqueda notificacionesComunicacionesBusquedaAux : listNotifiComuniBusqueda) {
				if (notificacionesComunicacionesBusquedaAux.getExtranjero() != null
						&& notificacionesComunicacionesBusquedaAux.getExtranjero().equals("")) {
					RemesaServiceImpl.logger.error("Se lanza la excepcin Sin Sede");
					throw new Y41bUDAException("error.remesa.sinSedeException", true, new Exception());
				}
			}
		} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(remesa.getRmtipoproc())) {
			NotificacionesComunicacionesBusqueda filterNotifComuni = new NotificacionesComunicacionesBusqueda();
			filterNotifComuni.setRmcodigo(remesa.getRmcodigo());

			List<NotificacionesComunicacionesBusqueda> listNotifiComuniBusqueda = this.arbtramexp3Service
					.findAllNotifiComuni(filterNotifComuni, null);

			for (NotificacionesComunicacionesBusqueda notificacionesComunicacionesBusquedaAux : listNotifiComuniBusqueda) {
				if (notificacionesComunicacionesBusquedaAux.getExtranjero() != null
						&& notificacionesComunicacionesBusquedaAux.getExtranjero().equals("")) {
					RemesaServiceImpl.logger.error("Se lanza la excepcin Sin Sede");
					throw new Y41bUDAException("error.remesa.sinSedeException", true, new Exception());
				}
			}
		} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(remesa.getRmtipoproc())) {
			NotificacionesComunicacionesBusqueda filterNotifComuni = new NotificacionesComunicacionesBusqueda();
			filterNotifComuni.setRmcodigo(remesa.getRmcodigo());

			List<NotificacionesComunicacionesBusqueda> listNotifiComuniBusqueda = this.instramexpService
					.findAllNotifiComuni(filterNotifComuni, null);

			for (NotificacionesComunicacionesBusqueda notificacionesComunicacionesBusquedaAux : listNotifiComuniBusqueda) {
				if (notificacionesComunicacionesBusquedaAux.getExtranjero() != null
						&& notificacionesComunicacionesBusquedaAux.getExtranjero().equals("")) {
					RemesaServiceImpl.logger.error("Se lanza la excepcin Sin Sede");
					throw new Y41bUDAException("error.remesa.sinSedeException", true, new Exception());
				}
			}
		}

		try {
			Map<String, String> message = new HashMap<String, String>();
			message.put(Y41bConstantes.OPERACION_REMESA,
					Y41bUtilsWS.encodeString(Y41bConstantes.OPERACION_REMESA_GENERAR_REMESA));
			message.put(Y41bConstantes.CODIGO_REMESA, Y41bUtilsWS.encodeString(remesa.getRmcodigo()));

			remesasClientJMSService.sendMessage(message);
		} catch (Throwable th) {
			RemesaServiceImpl.logger.error("Error en RemesaServiceImpl mtodo addRemesa", th);
			Remesa remesaErronea = new Remesa(remesa.getRmcodigo());
			String error = th.getMessage().trim().replace("\n", "");
			remesaErronea.setRmdesErrores(error);
			remesaErronea.setRmdesErroreu(error);
			remesaErronea.setRmestado(Y41bConstantes.ESTADO_REMESA_ERRONEA);
			this.updateEstadoRemesaErronea(remesaErronea, Y41bConstantes.ESTADO_REMESA_ERRONEA, th);
		}
		return remesaRdo;
	}

	/**
	 * Metodo que valida el tamao maximo de una remesa
	 * 
	 * @param remesa
	 *            Remesa
	 */
	private void validacionTamanoRemesa(Remesa remesa) {

		Parametros parametros = new Parametros();

		parametros.setParametro(Y41bConstantes.PARAMETRO_MB_MAX_REMESA);
		parametros = this.parametrosDao.find(parametros);

		NotificacionesComunicacionesBusqueda filterNotifiComuni = null;

		Long tamanoremesa = new Long(0);

		if (remesa.getRmtipoproc().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

			filterNotifiComuni = new NotificacionesComunicacionesBusqueda();
			filterNotifiComuni.setRmcodigo(remesa.getRmcodigo());
			filterNotifiComuni.setRmtipoExpediente(remesa.getRmtipoproc());

			tamanoremesa = soltramexpService.findSumSizeBlobNotifiComuni(filterNotifiComuni);

		} else if (remesa.getRmtipoproc().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

			filterNotifiComuni = new NotificacionesComunicacionesBusqueda();
			filterNotifiComuni.setRmcodigo(remesa.getRmcodigo());
			filterNotifiComuni.setRmtipoExpediente(remesa.getRmtipoproc());
			tamanoremesa = santramexpService.findSumSizeBlobNotifiComuni(filterNotifiComuni);

		} else if (Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA.equals(remesa.getRmtipoproc())
				|| Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA.equals(remesa.getRmtipoproc())
				|| Y41bConstantes.TIPO_PROC_ADHESIONES_MOD.equals(remesa.getRmtipoproc())) {

			filterNotifiComuni = new NotificacionesComunicacionesBusqueda();
			filterNotifiComuni.setRmcodigo(remesa.getRmcodigo());
			filterNotifiComuni.setRmtipoExpediente(remesa.getRmtipoproc());
			tamanoremesa = arbadhtramService.findSumSizeBlobNotifiComuni(filterNotifiComuni);

		} else if (remesa.getRmtipoproc().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {

			filterNotifiComuni = new NotificacionesComunicacionesBusqueda();
			filterNotifiComuni.setRmcodigo(remesa.getRmcodigo());
			filterNotifiComuni.setRmtipoExpediente(remesa.getRmtipoproc());
			tamanoremesa = arbtramexp3Service.findSumSizeBlobNotifiComuni(filterNotifiComuni);

		} else if (remesa.getRmtipoproc().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

			filterNotifiComuni = new NotificacionesComunicacionesBusqueda();
			filterNotifiComuni.setRmcodigo(remesa.getRmcodigo());
			filterNotifiComuni.setRmtipoExpediente(remesa.getRmtipoproc());

			tamanoremesa = instramexpService.findSumSizeBlobNotifiComuni(filterNotifiComuni);
		}

		tamanoremesa = Y41bUtils.convertBytesToMB(tamanoremesa);

		RemesaServiceImpl.logger.info("#####################TAMAO REMESA[" + tamanoremesa + "]MB");

		if (tamanoremesa > Long.parseLong(parametros.getValor())) {
			String[] args = new String[1];
			args[0] = parametros.getValor();

			String errormsg = this.appMessageSource.getMessage("error.remesa.altaException", args,
					LocaleContextHolder.getLocale());

			throw new Y41bUDAException(errormsg, true, new Exception());
		}
	}

	/**
	 * Inserts a single row in the Remesa table.
	 * 
	 * @param remesa
	 *            Remesa
	 * @return Remesa
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Remesa add(Remesa remesa) {
		RemesaServiceImpl.logger.info("Inicio del mtodo add");
		remesa.setRmestado(Y41bConstantes.ESTADO_REMESA_PENDIENTE);
		if (remesa.getRmtipo().equalsIgnoreCase(Y41bConstantes.TRAMITE_NOTIFICACION_ELECTRONICA)) {
			remesa.setRmfechageneracion(new Date());
		}
		this.remesaDao.add(remesa);

		if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(remesa.getRmtipoproc())) {
			for (TramiteHecho tramiteHechoDetalleAux : remesa.getRmtramiteshechos()) {
				Santramexp santramexp = new Santramexp();
				santramexp.setTrid(tramiteHechoDetalleAux.getEhcodigo());
				santramexp.setTrcodrem(remesa.getRmcodigo());
				santramexpDao.updateRemesa(santramexp);
			}
		} else if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(remesa.getRmtipoproc())) {
			for (TramiteHecho tramiteHechoDetalleAux : remesa.getRmtramiteshechos()) {

				tramiteHechoDetalleAux.setEhcodrem(remesa.getRmcodigo());
				this.tramiteHechoDao.updateRemesa(tramiteHechoDetalleAux);
			}
		} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(remesa.getRmtipoproc())) {
			for (TramiteHecho tramiteHechoDetalleAux : remesa.getRmtramiteshechos()) {
				Arbtramexp arbtramexp = new Arbtramexp();
				arbtramexp.setTrid(tramiteHechoDetalleAux.getEhcodigo());
				arbtramexp.setTrcodrem(remesa.getRmcodigo());
				arbtramexpDao.updateRemesa(arbtramexp);
			}
		} else if (Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA.equals(remesa.getRmtipoproc())
				|| Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA.equals(remesa.getRmtipoproc())
				|| Y41bConstantes.TIPO_PROC_ADHESIONES_MOD.equals(remesa.getRmtipoproc())) {
			for (TramiteHecho tramiteHechoDetalleAux : remesa.getRmtramiteshechos()) {
				Arbadhtram arbadhtram = new Arbadhtram();
				arbadhtram.setTrid(tramiteHechoDetalleAux.getEhcodigo());
				arbadhtram = arbadhtramDao.find(arbadhtram);
				arbadhtram.setTrcodrem(remesa.getRmcodigo());
				arbadhtramDao.updateRemesa(arbadhtram);
				// Tramite de cierre para comunicaciones
				Arbadhsol arbadhsol = new Arbadhsol();
				arbadhsol.setAdhid(arbadhtram.getTrexcodigo());
				arbadhsol = this.arbadhsolDao.find(arbadhsol);
				if (arbadhtram.getTrcodigo().equals(Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_ALTA)
						|| arbadhtram.getTrcodigo().equals(Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_BAJA)
						|| arbadhtram.getTrcodigo().equals(Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_MOD)) {
					Arbadhtram tramiteRelacionado = null;
					if (arbadhtram.getTrtridrel() != null) {
						tramiteRelacionado = this.arbadhtramDao.find(new Arbadhtram(arbadhtram.getTrtridrel()));
						if (tramiteRelacionado != null
								&& !Y41bUtils.esNullOCadenaVacia(tramiteRelacionado.getTrcodigo())
								&& (tramiteRelacionado.getTrcodigo()
										.equals(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_ALTA)
										|| tramiteRelacionado.getTrcodigo()
												.equals(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_BAJA)
										|| tramiteRelacionado.getTrcodigo()
												.equals(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_MOD))) {
							Arbadhtram cierre = new Arbadhtram();
							cierre.setTrid(this.arbadhtramDao.getNewPK().toString());
							cierre.setTrexcodigo(arbadhtram.getTrexcodigo());
							if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
								cierre.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_CIERRE_ALTA);
							} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())
									|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(arbadhsol.getAdhtipo())) {
								cierre.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_CIERRE_BAJA);
							} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
								cierre.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_CIERRE_MOD);
							}
							cierre.setTrfecini(Y41bUtils.hoy());
							cierre.setTrfecfin(Y41bUtils.hoy());
							cierre.setCensoMonitor(null);
							cierre.setCensoMonitorEj(new CensoMonitor(remesa.getRmcomo(), null));
							cierre.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
							cierre.setTrfeccierre(Y41bUtils.hoy());
							this.arbadhtramDao.add(cierre);
							// Finalizar solicitud
							Arbadhtram resolucion = new Arbadhtram();
							resolucion.setTrexcodigo(arbadhtram.getTrexcodigo());
							if (Y41bConstantes.ADH_TIPO_ALTA.equals(arbadhsol.getAdhtipo())) {
								resolucion.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_ALTA);
							} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(arbadhsol.getAdhtipo())) {
								resolucion.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_MOD);
							} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(arbadhsol.getAdhtipo())) {
								resolucion.setTrcodigo(Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_BAJA);
							}
							List<Arbadhtram> ltramites = arbadhtramDao.findAll(resolucion, null);
							if (ltramites != null && ltramites.size() > 0) {
								arbadhsol.setAdhestado(ltramites.get(0).getTrresotipo());
							}
							this.arbadhsolDao.update(arbadhsol);
						}
					}
				}
			}
		} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(remesa.getRmtipoproc())) {
			for (TramiteHecho tramiteHechoDetalleAux : remesa.getRmtramiteshechos()) {

				tramiteHechoDetalleAux.setEhcodrem(remesa.getRmcodigo());
				this.tramiteInspeccionDao.updateRemesa(tramiteHechoDetalleAux);
			}
		}

		return remesa;
	}

	/**
	 * Updates a single row in the Remesa table.
	 * 
	 * @param remesa
	 *            Remesa
	 * @return Remesa
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Remesa updateDatosGeneracion(Remesa remesa) {
		RemesaServiceImpl.logger.info("Inicio del mtodo updateDatosGeneracion");
		return this.remesaDao.updateDatosGeneracion(remesa);
	}

	private Remesa updateEstadoRemesaErronea(Remesa remesa, String tipoError, Throwable t) {
		return updateEstadoRemesaErronea0(remesa, tipoError, t, false, null);
	}

	public Remesa updateEstadoRemesaErronea_Y_Estado(Remesa remesa, String tipoError, Throwable t,
			String trazaPuntoActual) {
		return updateEstadoRemesaErronea0(remesa, tipoError, t, true, trazaPuntoActual);
	}

	/**
	 * updateEstadoRemesaErronea
	 * 
	 * @param idRemesa
	 *            identificador de la remesa
	 */
	private Remesa updateEstadoRemesaErronea0(Remesa remesa, String tipoError, Throwable thOriginal,
			boolean grabaDatosRemesaAA66, String trazaPuntoActual) {

		try {
			if (thOriginal != null) {
				if (thOriginal instanceof Y41bAA66Exception) {
					Y41bAA66Exception excAA66 = (Y41bAA66Exception) thOriginal;
					remesa.setRmdesErrores(excAA66.getDescripcionCastellano());
					remesa.setRmdesErroreu(excAA66.getDescripcionEuskera());
				} else {

					if (remesa.getRmtipo() != null
							&& remesa.getRmtipo().equals(Y41bConstantes.TRAMITE_NOTIFICACION_ELECTRONICA)) {

						String errorCas = appMessageSource.getMessage("remesa.errorWS.General", null,
								new Locale(Y41bConstantes.CASTELLANO));
						String errorEus = appMessageSource.getMessage("remesa.errorWS.General", null,
								new Locale(Y41bConstantes.EUSKERA));

						if (thOriginal instanceof Y41bUDAException) {
							Throwable excOriginal = doRecuperaExcepcionOriginal((Y41bUDAException) thOriginal);
							remesa.setRmdesErrores(errorCas + (trazaPuntoActual == null ? "" : trazaPuntoActual)
									+ "Y41bUDAException: " + excOriginal.getMessage());
							remesa.setRmdesErroreu(errorEus + (trazaPuntoActual == null ? "" : trazaPuntoActual)
									+ "Y41bUDAException: " + excOriginal.getMessage());
						} else {
							remesa.setRmdesErrores(errorCas + thOriginal.getMessage());
							remesa.setRmdesErroreu(errorEus + thOriginal.getMessage());
						}

					} else {

						String errorCas = appMessageSource.getMessage("remesa.error.General", null,
								new Locale(Y41bConstantes.CASTELLANO));
						String errorEus = appMessageSource.getMessage("remesa.error.General", null,
								new Locale(Y41bConstantes.EUSKERA));
						if (thOriginal instanceof Y41bUDAException) {
							Throwable excOriginal = doRecuperaExcepcionOriginal((Y41bUDAException) thOriginal);
							remesa.setRmdesErrores(errorCas + (trazaPuntoActual == null ? "" : trazaPuntoActual)
									+ "Y41bUDAException: " + excOriginal.getMessage());
							remesa.setRmdesErroreu(errorEus + (trazaPuntoActual == null ? "" : trazaPuntoActual)
									+ "Y41bUDAException: " + excOriginal.getMessage());
						} else {
							remesa.setRmdesErrores(errorCas + thOriginal.getMessage());
							remesa.setRmdesErroreu(errorEus + thOriginal.getMessage());
						}
					}

				}
			}
			return enviosPorRemesaService.updateEstadoRemesaTransaccional(remesa, tipoError, grabaDatosRemesaAA66);
		} catch (Throwable thGrave) {
			try {
				// SOLO debiera pasar por aqu en caso de un error en el
				// servidor
				if (thGrave instanceof Y41bUDAException) {
					Throwable excOriginal = doRecuperaExcepcionOriginal((Y41bUDAException) thGrave);
					remesa.setRmdesErrores(excOriginal.getMessage());
					remesa.setRmdesErroreu(excOriginal.getMessage());
				} else {
					remesa.setRmdesErrores(thGrave.getMessage());
					remesa.setRmdesErroreu(thGrave.getMessage());
				}
				return enviosPorRemesaService.updateEstadoRemesaTransaccional(remesa, tipoError, false);
			} catch (Throwable thSegunda) {
				// Para ver algo si aun as da excepcin
				RemesaServiceImpl.logger.error(
						"Y41B.RemesaServiceImpl: updateEstadoRemesaErronea.Excepcion grave (original).", thGrave);

				RemesaServiceImpl.logger.error("Y41B.RemesaServiceImpl: updateEstadoRemesaErronea.Excepcion segunda.",
						thSegunda);

				return null;
			}
		}
	}

	private Throwable doRecuperaExcepcionOriginal(Y41bUDAException t) {

		if (t.getException() instanceof Y41bUDAException) {
			return doRecuperaExcepcionOriginal((Y41bUDAException) t.getException());
		}
		return t.getException();
	}

	/**
	 * updateEstadoEnvioErronea
	 * 
	 * @param idEnvio
	 *            identificador del envio de la remesa
	 */
	public EnviosPorRemesa updateEstadoEnvioErronea(Integer idEnvio, Throwable thOriginal) {

		EnviosPorRemesa envioErroneo = new EnviosPorRemesa(idEnvio);
		try {

			if (thOriginal != null) {
				if (thOriginal instanceof Y41bAA66Exception) {
					Y41bAA66Exception excAA66 = (Y41bAA66Exception) thOriginal;
					envioErroneo.setEnvcdeserrores(excAA66.getDescripcionCastellano());
					envioErroneo.setEnvcdeserroreu(excAA66.getDescripcionEuskera());
				} else {
					String errorCas = appMessageSource.getMessage("remesa.errorWS.General", null,
							new Locale(Y41bConstantes.CASTELLANO));
					String errorEus = appMessageSource.getMessage("remesa.errorWS.General", null,
							new Locale(Y41bConstantes.EUSKERA));

					if (thOriginal instanceof Y41bUDAException) {
						Throwable excOriginal = doRecuperaExcepcionOriginal((Y41bUDAException) thOriginal);
						envioErroneo.setEnvcdeserrores(errorCas + "Y41bUDAException: " + excOriginal.getMessage());
						envioErroneo.setEnvcdeserroreu(errorEus + "Y41bUDAException: " + excOriginal.getMessage());
					} else {
						envioErroneo.setEnvcdeserrores(errorCas + thOriginal.getMessage());
						envioErroneo.setEnvcdeserroreu(errorEus + thOriginal.getMessage());
					}
				}
			}
			return this.enviosPorRemesaService.updateError(envioErroneo);
		} catch (Throwable thGrave) {
			try {
				// SOLO debiera pasar por aqu en caso de un error en el
				// servidor
				if (thGrave instanceof Y41bUDAException) {
					Throwable excOriginal = doRecuperaExcepcionOriginal((Y41bUDAException) thGrave);
					envioErroneo.setEnvcdeserrores(excOriginal.getMessage());
					envioErroneo.setEnvcdeserrores(excOriginal.getMessage());
				} else {
					envioErroneo.setEnvcdeserrores(thGrave.getMessage());
					envioErroneo.setEnvcdeserrores(thGrave.getMessage());
				}
				return this.enviosPorRemesaService.updateError(envioErroneo);
			} catch (Throwable thSegunda) {
				// Para ver algo si aun as da excepcin
				RemesaServiceImpl.logger
						.error("Y41B.RemesaServiceImpl: updateEstadoEnvioErronea.Excepcion grave (original).", thGrave);

				RemesaServiceImpl.logger.error("Y41B.RemesaServiceImpl: updateEstadoEnvioErronea.Excepcion segunda.",
						thSegunda);
				return null;
			}
		}
	}

	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	private void eliminarEnvioDeLasTablas(NotificacionesComunicacionesBusqueda envio, String tipoProcedimiento) {

		if (envio.getEnvcidenvio() != 0) {
			this.enviosPorRemesaDao.remove(new EnviosPorRemesa(envio.getEnvcidenvio()));
		}

		if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(tipoProcedimiento)) {
			this.tramiteHechoDao.removeRemesaFromTramitesByEhcodigo(envio.getCodExpediente());
		} else if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(tipoProcedimiento)) {
			this.santramexpDao.removeRemesaFromTramitesByEhcodigo(envio.getCodExpediente());
		} else if (Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA.equals(tipoProcedimiento)
				|| Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA.equals(tipoProcedimiento)
				|| Y41bConstantes.TIPO_PROC_ADHESIONES_MOD.equals(tipoProcedimiento)) {
			this.arbadhtramDao.removeRemesaFromTramitesByEhcodigo(envio.getCodExpediente());
		} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(tipoProcedimiento)) {
			this.arbtramexpDao.removeRemesaFromTramitesByEhcodigo(envio.getCodExpediente());
		} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(tipoProcedimiento)) {
			this.tramiteInspeccionDao.removeRemesaFromTramitesByEhcodigo(envio.getCodExpediente());
		}
	}

	/**
	 * Updates a single row in the Remesa table.
	 * 
	 * @param remesa
	 *            Remesa
	 * @return Remesa
	 */
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	public Remesa updateEstadoRemesa(Remesa remesa) {
		return this.remesaDao.updateEstadoRemesa(remesa);
	}

	/**
	 * Finds a single row in the Remesa table.
	 * 
	 * @param remesa
	 *            Remesa
	 * @return Remesa
	 */
	public Remesa find(Remesa remesa) {
		return this.remesaDao.find(remesa);
	}

	// /**
	// * Finds a single row in the Remesa table.
	// *
	// * @param rmcodigo
	// * String
	// * @param idTramite
	// * String
	// *
	// * @return Remesa
	// */
	//
	// public Remesa findRemesaEnvio(String rmcodigo, String idTramite) {
	//
	// Remesa remesa = new Remesa(rmcodigo);
	// remesa = this.remesaDao.find(remesa);
	//
	// EnviosPorRemesa enviosPorRemesa = new EnviosPorRemesa();
	// enviosPorRemesa.setEhcodigo(idTramite);
	// enviosPorRemesa = this.enviosPorRemesaDao
	// .findWithoutBlobByEhCodigo(enviosPorRemesa);
	//
	// remesa.setRmFechaActEnvio(enviosPorRemesa.getEnvFechaActualizacion());
	// return remesa;
	//
	// }

	/**
	 * Finds a List of rows in the Remesa table.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Remesa> findAll(Remesa remesa, Pagination pagination) {
		return (List<Remesa>) this.remesaDao.findAll(remesa, pagination);
	}

	/**
	 * Counts rows in the Remesa table.
	 * 
	 * @param remesa
	 *            Remesa
	 * @return Long
	 */
	public Long findAllCount(Remesa remesa) {
		return this.remesaDao.findAllCount(remesa);
	}

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Remesa> findAllLike(Remesa remesa, Pagination pagination, Boolean startsWith) {
		return (List<Remesa>) this.remesaDao.findAllLike(remesa, pagination, startsWith);
	}

	/**
	 * Counts rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Remesa remesa, Boolean startsWith) {
		return this.remesaDao.findAllLikeCount(remesa, startsWith);
	}

	/**
	 * Deletes a single row in the Remesa table.
	 * 
	 * @param remesa
	 *            Remesa
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Remesa remove(Remesa remesa) {
		RemesaServiceImpl.logger.info("Inicio del mtodo remove");

		remesa = this.find(remesa);
		if (remesa != null) {
			if (remesa.getRmtipo() != null
					&& remesa.getRmtipo().equals(Y41bConstantes.TRAMITE_NOTIFICACION_ELECTRONICA)) {

				try {
					boolean laRemesaContieneErrores = false;
					boolean laRemesaEmitida = false;
					AA66ServiceImpl aa66Ws = new AA66ServiceImpl();
					for (NotificacionesComunicacionesBusqueda envio : this.findAllNotiComuni(remesa)) {

						if (envio.getEnvcidenvio() != 0) {
							try {
								IdentTramitadorWs identTramitadorWs = new IdentTramitadorWs();
								identTramitadorWs.setId(envio.getEnvcidenvio());
								identTramitadorWs.setUidPuestoTramitador(this.getPuestoXlNet(remesa));
								// Llamada al metodo del WS de eliminacin
								aa66Ws.eliminarEnvio(identTramitadorWs);

							} catch (Y41bAA66Exception e) {
								String codigoError = e.getCodigoError();
								RemesaServiceImpl.logger
										.error("Ha ocurrido un error Y41bAA66Exception al intentar prepararLaRemesa la remesa. Codigo Error devuelto por el WS:"
												+ codigoError, e);

								if (codigoError != null && (codigoError
										.equals(Y41bConstantes.AA66_WS_ERROR_ELIMINAR_ENVIO_NO_EXISTE))) {
									// Envio no existe
								} else if (codigoError != null
										&& (codigoError.equals(Y41bConstantes.AA66_WS_ERROR_ELIMINAR_ENVIO))) {
									laRemesaEmitida = true;
									remesa.setRmestado(Y41bConstantes.ESTADO_REMESA_EMITIDA);
									remesa.setRmfechaemision(new Date());
									this.updateEstadoRemesa(remesa);
									break;

								} else {
									laRemesaContieneErrores = true;

									// Actualizar tabla envio por remesa
									this.updateEstadoEnvioErronea(envio.getEnvcidenvio(), e);

									// Hay que forzar que pase a la siguiente
									// notificacin.
									continue;
								}
							} catch (Throwable e) {
								laRemesaContieneErrores = true;

								// Actualizar tabla envio por remesa
								this.updateEstadoEnvioErronea(envio.getEnvcidenvio(), e);

								// Hay que forzar que pase a la siguiente
								// notificacin.
								continue;
							}
						}

						if (!laRemesaEmitida) {

							// Se borra de las tablas y se realiza commit (por
							// la
							// transaccionalidad usada)
							eliminarEnvioDeLasTablas(envio, remesa.getRmtipoproc());
						}
					}
					if (!laRemesaEmitida) {
						// Si la remesa tiene errores, se pone como
						// ESTADO_REMESA_ELIMINACION_ERRONEA
						if (laRemesaContieneErrores) {
							actualizarRemesaEliminarErronea(remesa);
							RemesaServiceImpl.logger.info(
									"[DELETE] : No se ha eliminado la remesa dado que algn envo no se pudo eliminar");
						} else {
							this.remesaDao.remove(remesa);
						}
					}
				} catch (Throwable e) {
					actualizarRemesaEliminarErronea(remesa);
				}

			} else {
				// Para el resto de tipos de remesas, se elimina la remesa
				// directamente sin llamar a WS.
				// borramos la remesa en todos los ambitos
				this.santramexpDao.removeRemesaFromTramites(remesa.getRmcodigo());
				this.tramiteHechoDao.removeRemesaFromTramites(remesa.getRmcodigo());
				this.arbadhtramDao.removeRemesaFromTramites(remesa.getRmcodigo());
				this.arbtramexpDao.removeRemesaFromTramites(remesa.getRmcodigo());

				this.remesaDao.remove(remesa);
				RemesaServiceImpl.logger.info("[DELETE] : Remesa borrado correctamente");
			}
		}
		return remesa;
	}

	private void actualizarRemesaEliminarErronea(Remesa remesa) {
		String errorCas = appMessageSource.getMessage("remesa.errorEliminar", null,
				new Locale(Y41bConstantes.CASTELLANO));
		String ErrorEus = appMessageSource.getMessage("remesa.errorEliminar", null, new Locale(Y41bConstantes.EUSKERA));
		remesa.setRmdesErrores(errorCas);
		remesa.setRmdesErroreu(ErrorEus);

		this.updateEstadoRemesaErronea(remesa, Y41bConstantes.ESTADO_REMESA_ELIMINACION_ERRONEA, null);
	}

	/**
	 * Devuelve la list con todas las notificaciones
	 * 
	 * @param remesa
	 *            Remesa
	 * @return List<NotificacionesComunicacionesBusqueda>
	 */
	public List<NotificacionesComunicacionesBusqueda> findAllNotiComuni(Remesa remesa) {
		if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(remesa.getRmtipoproc())) {
			NotificacionesComunicacionesBusqueda notifi = new NotificacionesComunicacionesBusqueda();
			notifi.setRmcodigo(remesa.getRmcodigo());
			notifi.setCompatibleAA66(this.compatibleConAA66());
			return this.santramexpDao.findAllNotifiComuni(notifi, null);
		} else if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(remesa.getRmtipoproc())) {
			NotificacionesComunicacionesBusqueda notifi = new NotificacionesComunicacionesBusqueda();
			notifi.setRmcodigo(remesa.getRmcodigo());
			notifi.setCompatibleAA66(this.compatibleConAA66());
			return this.tramiteHechoDao.findAllNotifiComuni(notifi, null);
		} else if (Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA.equals(remesa.getRmtipoproc())
				|| Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA.equals(remesa.getRmtipoproc())
				|| Y41bConstantes.TIPO_PROC_ADHESIONES_MOD.equals(remesa.getRmtipoproc())) {
			NotificacionesComunicacionesBusqueda notifi = new NotificacionesComunicacionesBusqueda();
			notifi.setRmcodigo(remesa.getRmcodigo());
			notifi.setCompatibleAA66(this.compatibleConAA66());
			return this.arbadhtramDao.findAllNotifiComuni(notifi, null);
		} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(remesa.getRmtipoproc())) {
			NotificacionesComunicacionesBusqueda notifi = new NotificacionesComunicacionesBusqueda();
			notifi.setRmcodigo(remesa.getRmcodigo());
			notifi.setCompatibleAA66(this.compatibleConAA66());
			return this.arbtramexpDao.findAllNotifiComuni(notifi, null);
		} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(remesa.getRmtipoproc())) {
			NotificacionesComunicacionesBusqueda notifi = new NotificacionesComunicacionesBusqueda();
			notifi.setRmcodigo(remesa.getRmcodigo());
			notifi.setCompatibleAA66(this.compatibleConAA66());
			return this.tramiteInspeccionDao.findAllNotifiComuni(notifi, null);
		}
		return null;
	}

	/**
	 * Devuelve el usuario XlNet del envo
	 * 
	 * @param paramRemesa
	 *            Remesa
	 * @return String
	 */
	public String getPuestoXlNet(Remesa paramRemesa) {
		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
		String local = (String) prop.getProperty("y41bVistaWar.entorno.local");

		if (local.equals("true")) {
			return "Y41BU001";
		} else {
			CensoMonitor censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(paramRemesa.getRmcomo());
			censoMonitor = this.censoMonitorService.find(censoMonitor);

			return censoMonitor.getPuestoxlnet();
		}
	}

	/**
	 * Comprueba si existe compatibilidad con AA66
	 * 
	 * @return boolean
	 */
	private boolean compatibleConAA66() {
		Parametros parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.INTEGRACION_CON_AA66);
		parametros = this.parametrosDao.find(parametros);
		if (null != parametros && null != parametros.getValor()) {
			String integracion = parametros.getValor();
			return integracion.equalsIgnoreCase(Y41bConstantes.VALOR_SI);
		}
		return false;
	}

	/**
	 * Mtodo para emitir la remesa
	 * 
	 * @param codRemesa
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Throwable.class)
	public void prepararLaRemesa(Remesa remesaEmitida) {
		RemesaServiceImpl.logger.info("Inicio del mtodo prepararLaRemesa");

		if (remesaEmitida.getRmtipo().equalsIgnoreCase(Y41bConstantes.TRAMITE_NOTIFICACION_ELECTRONICA)) {
			try {
				RemesaServiceImpl.logger.info("[GET - pepararRemesa] : Inicio");

				AA66ServiceImpl aa66Ws = new AA66ServiceImpl();
				aa66Ws.prepararColeccion(this.getIdentTramitadorWsRemesa(remesaEmitida));

				remesaEmitida.setRmestado(Y41bConstantes.ESTADO_REMESA_EMITIDA);
				remesaEmitida.setRmfechaemision(new Date());
				this.updateEstadoRemesa(remesaEmitida);
				RemesaServiceImpl.logger.info("[GET - pepararRemesa] : Fin");
			} catch (Y41bAA66Exception e) {
				String codigoError = e.getCodigoError();
				RemesaServiceImpl.logger
						.error("Ha ocurrido un error Y41bAA66Exception al intentar prepararLaRemesa la remesa. Codigo Error devuelto por el WS:"
								+ codigoError, e);

				if (codigoError != null && (codigoError.equals(Y41bConstantes.AA66_WS_ERROR_PREPARAR_NO_EXISTE)
						|| codigoError.equals(Y41bConstantes.AA66_WS_ERROR_PREPARAR_CERRADA))) {
					if (codigoError.equals(Y41bConstantes.AA66_WS_ERROR_PREPARAR_NO_EXISTE)) {
						throw new Y41bUDAException("remesa.errorWS.Preparar.01", true, e);
					}
					if (codigoError.equals(Y41bConstantes.AA66_WS_ERROR_PREPARAR_CERRADA)) {
						remesaEmitida.setRmestado(Y41bConstantes.ESTADO_REMESA_EMITIDA);
						remesaEmitida.setRmfechaemision(new Date());
						this.updateEstadoRemesa(remesaEmitida);
						RemesaServiceImpl.logger.info("[GET - pepararRemesa] : Fin");
					}
				} else {
					throw new Y41bUDAException(e.getDescripcion(LocaleContextHolder.getLocale()), true, e);

				}

			} catch (Throwable e) {
				RemesaServiceImpl.logger.error("Ha ocurrido un error Throwable al intentar prepararLaRemesa la remesa",
						e);

				throw new Y41bUDAException(
						appMessageSource.getMessage("remesa.errorWS.General", null, LocaleContextHolder.getLocale())
								+ e.getMessage(),
						true, e);
			}
		} else if (remesaEmitida.getRmtipo().equalsIgnoreCase(Y41bConstantes.TRAMITE_COMUNICACION)) {
			remesaEmitida.setRmestado(Y41bConstantes.ESTADO_REMESA_EMITIDA);
			remesaEmitida.setRmfechaemision(new Date());
			this.updateEstadoRemesa(remesaEmitida);

			Map<String, String> message = new HashMap<String, String>();
			message.put(Y41bConstantes.OPERACION_REMESA,
					Y41bUtilsWS.encodeString(Y41bConstantes.OPERACION_REMESA_ACTUALIZAR_MISGESTIONES));
			message.put(Y41bConstantes.CODIGO_REMESA, Y41bUtilsWS.encodeString(remesaEmitida.getRmcodigo()));

			remesasClientJMSService.sendMessage(message);
		}
	}

	/**
	 * Obtiene el tramitador de la remesa
	 * 
	 * @param remesaEmitida
	 * @return
	 */
	private IdentTramitadorWs getIdentTramitadorWsRemesa(Remesa remesaEmitida) {
		IdentTramitadorWs identTramitadorWs = new IdentTramitadorWs();
		identTramitadorWs.setId(remesaEmitida.getRmidColeccionAA66());
		identTramitadorWs.setUidPuestoTramitador(this.getPuestoXlNet(remesaEmitida));

		return identTramitadorWs;
	}

	/**
	 * Sin transaccionalidad
	 */
	@Override
	public void actualizarEnvios(Remesa remesaEmitida) {
		actualizarEnvios0(remesaEmitida, null);
	}

	/**
	 * Con transaccionalidad
	 */
	@Override
	@Transactional(rollbackFor = Throwable.class)
	public void actualizarEnvios(Remesa remesaEmitida, CensoMonitor censoMonitor) {
		actualizarEnvios0(remesaEmitida, censoMonitor);
	}

	/**
	 * Consulta los estados de los envos de las notificaciones electrnicas en
	 * correos y en caso de obtener respuesta, actualiza el trmite, los envos
	 * y la remesa
	 */
	private void actualizarEnvios0(Remesa remesaEmitida, CensoMonitor censoMonitor) {
		RemesaServiceImpl.logger.info("########################[GET - actualizarEnvios0] : Inicio. " + remesaEmitida);

		EnviosPorRemesa enviosPorRemesa = new EnviosPorRemesa();
		try {
			AA66ServiceImpl aa66Ws = new AA66ServiceImpl();
			boolean cerrarRemesa = true;
			boolean laRemesaContieneErrores = false;
			boolean conPendientes = false;
			String filename = null;

			enviosPorRemesaService.updateFechaActualizacionRemesa(remesaEmitida);

			for (NotificacionesComunicacionesBusqueda envio : this.findAllNotiComuni(remesaEmitida)) {
				// "Se comprueba que el envio est en un estado diferente a
				// Respondido_por_correos"
				enviosPorRemesa = new EnviosPorRemesa();
				enviosPorRemesa.setEhcodigo(envio.getCodExpediente());
				enviosPorRemesa = this.enviosPorRemesaDao.findWithoutBlobByEhCodigo(enviosPorRemesa);

				if (enviosPorRemesa != null && (enviosPorRemesa.getEnvcestado() == null || (!enviosPorRemesa
						.getEnvcestado().equals(Y41bConstantes.AA66_ENVIO_SITUACION_RESPONDIDO_POR_CORREOS)
						&& !enviosPorRemesa.getEnvcestado()
								.equals(Y41bConstantes.REMESAS_BUSQUEDA_ESTADOENVIO_RESPCORREOSSINPEE)))) {
					EnviosPorRemesa enviosPorRemesaFechaActualizacion = new EnviosPorRemesa(envio.getEnvcidenvio());
					enviosPorRemesaService.updateFechaActualizacionEnvioRemesa(enviosPorRemesaFechaActualizacion);

					try {

						RemesaServiceImpl.logger
								.info("########################[GET - actualizarEnvios0] : Inicio Envio:" + envio);

						IdentTramitadorCondicionalWs identTramitadorCondicionalWs = new IdentTramitadorCondicionalWs();
						identTramitadorCondicionalWs.setId(envio.getEnvcidenvio());
						identTramitadorCondicionalWs.setUidPuestoTramitador(this.getPuestoXlNet(remesaEmitida));
						identTramitadorCondicionalWs.setTodas(true);

						// Llamada al WS
						SituacionEntregaWs situacion = aa66Ws.situacionEntregaEnvio(identTramitadorCondicionalWs);

						RemesaServiceImpl.logger
								.info("########################[GET - actualizarEnvios0] : situacionEntregaEnvio:"
										+ situacion.getCodigoSituacion());

						String codigoSituacion = situacion.getCodigoSituacion();
						if (!Y41bConstantes.AA66_COD_SITUACION_SIN_ACTUALIZAR_CORREOS
								.equalsIgnoreCase(codigoSituacion)) {

							// "Se realiza la conversin de la situacion de
							// Correos a la situacin Y41b"
							SituacionY41BConCorreos situacionY41BConCorreos = this.situacionY41BConCorreosDao
									.find(codigoSituacion);

							RemesaServiceImpl.logger
									.info("########################[GET - actualizarEnvios0] : situacionY41BConCorreos:"
											+ situacionY41BConCorreos);

							String situacionCorreos = situacionY41BConCorreos.getEhacusereciborecibido();

							// nuevo campo
							String sitConPEE = situacionY41BConCorreos.getSitConPEE();

							byte[] documentoByte = null;
							try {
								IdentTramitadorWs identTramitadorWsRemesa = new IdentTramitadorWs();
								identTramitadorWsRemesa.setId(envio.getEnvcidenvio());
								identTramitadorWsRemesa.setUidPuestoTramitador(this.getPuestoXlNet(remesaEmitida));

								RemesaServiceImpl.logger
										.info("########################[GET - actualizarEnvios0] : ANTES pruebaEntregaEnvio"
												+ envio);

								ZipEnvioWs zipEnvioWs = aa66Ws.pruebaEntregaEnvio(identTramitadorWsRemesa);

								RemesaServiceImpl.logger
										.info("########################[GET - actualizarEnvios0] : DESPUES pruebaEntregaEnvio"
												+ envio);

								int extracted = 0;
								byte[] bytes = null;

								if (zipEnvioWs != null && zipEnvioWs.getFicheroZip() != null
										&& zipEnvioWs.getFicheroZip().size() > 0) {

									RemesaServiceImpl.logger.info(
											"########################[GET - actualizarEnvios0] : CON ZIP" + envio);

									documentoByte = zipEnvioWs.getFicheroZip().get(0);
									// Descomprimir fichero
									Blob blob = new SerialBlob(documentoByte);
									InputStream is = blob.getBinaryStream();
									ZipInputStream zis = new ZipInputStream(is);
									is.close();

									ZipEntry entry = null;

									while ((entry = zis.getNextEntry()) != null) {
										filename = entry.getName();

										ByteArrayOutputStream out = new ByteArrayOutputStream();
										bytes = new byte[Y41bConstantes.NUM_1024];
										int bytesRead = 0;
										while ((bytesRead = zis.read(bytes)) != -1) {
											out.write(bytes, 0, bytesRead);
										}
										bytes = out.toByteArray();
										out.close();

										// do something with 'filename' and
										// 'bytes'...
										zis.closeEntry();

										extracted++;
									}
								}

								if (extracted == 1) {
									RemesaServiceImpl.logger
											.info("########################[GET - actualizarEnvios0] : AA66_ENVIO_SITUACION_RESPONDIDO_POR_CORREOS:"
													+ envio);
									documentoByte = bytes;
									enviosPorRemesa
											.setEnvcestado(Y41bConstantes.AA66_ENVIO_SITUACION_RESPONDIDO_POR_CORREOS);
								} else {
									if (sitConPEE != null && sitConPEE.equalsIgnoreCase(Y41bConstantes.NO)) {
										RemesaServiceImpl.logger
												.info("########################[GET - actualizarEnvios0] : REMESAS_BUSQUEDA_ESTADOENVIO_RESPCORREOSSINPEE:"
														+ envio);
										enviosPorRemesa.setEnvcestado(
												Y41bConstantes.REMESAS_BUSQUEDA_ESTADOENVIO_RESPCORREOSSINPEE);
									} else if (sitConPEE != null && sitConPEE.equalsIgnoreCase(Y41bConstantes.SI)) {
										RemesaServiceImpl.logger
												.info("########################[GET - actualizarEnvios0] : REMESAS_BUSQUEDA_ESTADOENVIO_PENDIENTEDOCPEE:"
														+ envio);
										enviosPorRemesa.setEnvcestado(
												Y41bConstantes.REMESAS_BUSQUEDA_ESTADOENVIO_PENDIENTEDOCPEE);
										conPendientes = true;
									}
								}
							} catch (Throwable t) {
								if (t instanceof Y41bAA66Exception) {
									Y41bAA66Exception excAA66 = (Y41bAA66Exception) t;

									RemesaServiceImpl.logger
											.error("########################[GET - actualizarEnvios0] : EXCEPTION:"
													+ envio + excAA66.getCodigoError());

									if (Y41bConstantes.AA66_WS_ERROR_NO_HAY_PDF.equals(excAA66.getCodigoError())) {
										RemesaServiceImpl.logger
												.error("########################[GET - actualizarEnvios0] : EXCEPTION AA66_WS_ERROR_NO_HAY_PDF:"
														+ envio);
										if (sitConPEE.equalsIgnoreCase(Y41bConstantes.NO)) {
											RemesaServiceImpl.logger
													.error("########################[GET - actualizarEnvios0] : EXCEPTION AA66_WS_ERROR_NO_HAY_PDF REMESAS_BUSQUEDA_ESTADOENVIO_RESPCORREOSSINPEE:"
															+ envio);
											enviosPorRemesa.setEnvcestado(
													Y41bConstantes.REMESAS_BUSQUEDA_ESTADOENVIO_RESPCORREOSSINPEE);
										} else if (sitConPEE.equalsIgnoreCase(Y41bConstantes.SI)) {
											RemesaServiceImpl.logger
													.error("########################[GET - actualizarEnvios0] : EXCEPTION AA66_WS_ERROR_NO_HAY_PDF REMESAS_BUSQUEDA_ESTADOENVIO_PENDIENTEDOCPEE:"
															+ envio);
											enviosPorRemesa.setEnvcestado(
													Y41bConstantes.REMESAS_BUSQUEDA_ESTADOENVIO_PENDIENTEDOCPEE);
											conPendientes = true;
										}
									} else {
										throw t;
									}
								} else {
									throw t;
								}
							}

							// "Actualizar el trmite de acuse relacionado, el
							// mtodo tiene la lgica de que hacer"
							this.actualizaTramiteDeAcuseRecibo(censoMonitor, remesaEmitida, envio,
									situacion.getFechaSituacion(), situacionCorreos, enviosPorRemesa.getEnvcestado(),
									documentoByte, filename);

							// "Lo ultimo es actualizar el envio de la remesa"
							this.updateSitCorreosEnviosPorRemesa(enviosPorRemesa, situacion);

						} else {
							RemesaServiceImpl.logger
									.info("########################[GET - actualizarEnvios0] : AA66_COD_SITUACION_SIN_ACTUALIZAR_CORREOS:"
											+ envio);
							cerrarRemesa = false;
						}

					} catch (Throwable e) {
						RemesaServiceImpl.logger
								.error("########################[GET - actualizarEnvios0] : updateEstadoEnvioErronea"
										+ remesaEmitida, e);

						laRemesaContieneErrores = true;
						cerrarRemesa = false;

						// Actualizar tabla envio por remesa
						this.updateEstadoEnvioErronea(envio.getEnvcidenvio(), e);
					}
				} else if (enviosPorRemesa == null) {
					cerrarRemesa = false;
				}
			} // Fin del bucle

			// Si la remesa tiene errores, se pone como
			// ESTADO_REMESA_ELIMINACION_ERRONEA
			if (laRemesaContieneErrores) {
				RemesaServiceImpl.logger
						.info("########################[GET - actualizarEnvios0] : actualizarRemesaEmitidaRespuestaErronea:"
								+ remesaEmitida);

				actualizarRemesaEmitidaRespuestaErronea(remesaEmitida);
			} else {
				if (cerrarRemesa && !(conPendientes)) {

					RemesaServiceImpl.logger
							.info("########################[GET - actualizarEnvios0] : cerrarRemesa:" + remesaEmitida);

					enviosPorRemesaService.cerrarRemesa(remesaEmitida);
				} else {
					// Comprobar si existe algun envio con error, entonces
					// modificar el estado a emitida respuesta erronea
					for (NotificacionesComunicacionesBusqueda envio : this.findAllNotiComuni(remesaEmitida)) {
						// "Se comprueba que el envio est en un estado
						// diferente a Respondido_por_correos"
						enviosPorRemesa = new EnviosPorRemesa();
						enviosPorRemesa.setEhcodigo(envio.getCodExpediente());
						enviosPorRemesa = this.enviosPorRemesaDao.findWithoutBlobByEhCodigo(enviosPorRemesa);
						if (enviosPorRemesa != null && enviosPorRemesa.getEnvcestado() != null
								&& enviosPorRemesa.getEnvcestado().equals(Y41bConstantes.AA66_ENVIO_SITUACION_ERROR)) {

							RemesaServiceImpl.logger
									.info("########################[GET - actualizarEnvios0] : actualizarRemesaEmitidaRespuestaErronea con envios AA66_ENVIO_SITUACION_ERROR:"
											+ remesaEmitida);

							actualizarRemesaEmitidaRespuestaErronea(remesaEmitida);
						}
					}

				}
			}
		} catch (Throwable e) {
			RemesaServiceImpl.logger
					.error("########################[GET - actualizarEnvios0] : EXCEPTION ESTADO_REMESA_EMITIDA_RESPUESTAS_ERRONEAS "
							+ remesaEmitida, e);

			remesaEmitida.setRmestado(Y41bConstantes.ESTADO_REMESA_EMITIDA_RESPUESTAS_ERRONEAS);
			updateEstadoRemesaErronea(remesaEmitida, Y41bConstantes.ESTADO_REMESA_EMITIDA_RESPUESTAS_ERRONEAS, e);
		} finally {
			RemesaServiceImpl.logger.info("########################[GET - actualizarEnvios0] : Fin. " + remesaEmitida);
		}
	}

	private void actualizaTramiteDeAcuseRecibo(CensoMonitor censoMonitor, Remesa remesaEmitida,
			NotificacionesComunicacionesBusqueda envio, String fechaSituacion, String situacionCorreos,
			String envcestado, byte[] documentoByte, String filename) {

		if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(remesaEmitida.getRmtipoproc())) {
			this.santramexpService.actualizarTramiteDeAcuseReciboDesdeRemesa(censoMonitor, remesaEmitida, envio,
					fechaSituacion, situacionCorreos, envcestado, documentoByte, filename);
		} else if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(remesaEmitida.getRmtipoproc())) {
			this.soltramexpService.actualizarTramiteDeAcuseReciboDesdeRemesa(censoMonitor, remesaEmitida, envio,
					fechaSituacion, situacionCorreos, envcestado, documentoByte, filename);
		} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(remesaEmitida.getRmtipoproc())) {
			this.arbtramexp3Service.actualizarTramiteDeAcuseReciboDesdeRemesa(censoMonitor, remesaEmitida, envio,
					fechaSituacion, situacionCorreos, envcestado, documentoByte, filename);
		} else if (Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA.equals(remesaEmitida.getRmtipoproc())
				|| Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA.equals(remesaEmitida.getRmtipoproc())
				|| Y41bConstantes.TIPO_PROC_ADHESIONES_MOD.equals(remesaEmitida.getRmtipoproc())) {
			this.arbadhtramService.actualizarTramiteDeAcuseReciboDesdeRemesa(censoMonitor, remesaEmitida, envio,
					fechaSituacion, situacionCorreos, envcestado, documentoByte, filename);
		} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES.equals(remesaEmitida.getRmtipoproc())) {
			this.instramexpService.actualizarTramiteDeAcuseReciboDesdeRemesa(censoMonitor, remesaEmitida, envio,
					fechaSituacion, situacionCorreos, envcestado, documentoByte, filename);
		}
	}

	private void actualizarRemesaEmitidaRespuestaErronea(Remesa remesa) {
		String errorCas = appMessageSource.getMessage("remesa.errorWS.consultaSituacion", null,
				new Locale(Y41bConstantes.CASTELLANO));
		String ErrorEus = appMessageSource.getMessage("remesa.errorWS.consultaSituacion", null,
				new Locale(Y41bConstantes.EUSKERA));
		remesa.setRmdesErrores(errorCas);
		remesa.setRmdesErroreu(ErrorEus);

		this.updateEstadoRemesaErronea(remesa, Y41bConstantes.ESTADO_REMESA_EMITIDA_RESPUESTAS_ERRONEAS, null);
	}

	/**
	 * Actualiza los envos por remesa con la situacin de correos
	 * 
	 * @param enviosPorRemesa
	 * @param situacion
	 * @return
	 */
	private EnviosPorRemesa updateSitCorreosEnviosPorRemesa(EnviosPorRemesa enviosPorRemesa,
			SituacionEntregaWs situacion) {
		enviosPorRemesa.setEnvccodSitCorreos(situacion.getCodigoSituacion() + "");
		enviosPorRemesa.setEnvcdesSitCorreosEs(situacion.getDescripcionCastellano());
		enviosPorRemesa.setEnvcdesSitCorreosEu(situacion.getDescripcionEuskera());

		// Caso especial en que puede venir erroneo:
		// ... Que el WS de AA66 no devuelva documento PEE.
		if (!Y41bConstantes.AA66_ENVIO_SITUACION_ERROR.equals(enviosPorRemesa.getEnvcestado())) {
			// Limpiar las descripciones de error, por si anteriormente hubiese
			// tenido un error.
			enviosPorRemesa.setEnvcdeserrores("");
			enviosPorRemesa.setEnvcdeserroreu("");
		}

		return this.enviosPorRemesaService.updateSitCorreos(enviosPorRemesa);
	}

	/**
	 * Deletes multiple rows in the Remesa table.
	 * 
	 * @param remesaList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Remesa> remesaList) {
		for (Remesa remesaAux : remesaList) {
			this.remesaDao.remove(remesaAux);
		}
	}

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            RemesaBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Remesa> findAllRemesasLikeVista(RemesaBusqueda remesa, Pagination pagination, Boolean startsWith) {

		if (pagination != null) {
			if (pagination.getSidx() != null && pagination.getSidx().startsWith("rmFechaEnvioMasReciente")) {
				pagination.setSidx("RMFECHA_ENVIOMASRECIENTE");
			}
		}

		if (remesa != null && remesa.getRmtipoexpediente() != null
				&& remesa.getRmtipoexpediente().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			return (List<Remesa>) this.remesaDao.findAllRemesasLikeVistaSol(remesa, pagination, startsWith);
		} else if (remesa != null && remesa.getRmtipoexpediente() != null
				&& remesa.getRmtipoexpediente().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			return (List<Remesa>) this.remesaDao.findAllRemesasLikeVistaSan(remesa, pagination, startsWith);
		} else if (remesa != null && remesa.getRmtipoexpediente() != null
				&& remesa.getRmtipoexpediente().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
			return (List<Remesa>) this.remesaDao.findAllRemesasLikeVistaArb(remesa, pagination, startsWith);
		} else if (remesa != null && remesa.getRmtipoexpediente() != null
				&& (remesa.getRmtipoexpediente().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
						|| remesa.getRmtipoexpediente().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
						|| remesa.getRmtipoexpediente().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
			return (List<Remesa>) this.remesaDao.findAllRemesasLikeVistaArbAdh(remesa, pagination, startsWith);
		} else if (remesa != null && remesa.getRmtipoexpediente() != null
				&& remesa.getRmtipoexpediente().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			return (List<Remesa>) this.remesaDao.findAllRemesasLikeVistaIns(remesa, pagination, startsWith);
		} else {
			return null;
		}

	}

	/**
	 * Counts rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            RemesaBusqueda
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllRemesasLikeVistaCount(RemesaBusqueda remesa, Boolean startsWith) {
		if (remesa != null && remesa.getRmtipoexpediente() != null
				&& remesa.getRmtipoexpediente().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			return this.remesaDao.findAllRemesasLikeVistaSolCount(remesa, startsWith);
		} else if (remesa != null && remesa.getRmtipoexpediente() != null
				&& remesa.getRmtipoexpediente().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			return this.remesaDao.findAllRemesasLikeVistaSanCount(remesa, startsWith);
		} else if (remesa != null && remesa.getRmtipoexpediente() != null
				&& remesa.getRmtipoexpediente().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
			return this.remesaDao.findAllRemesasLikeVistaArbCount(remesa, startsWith);
		} else if (remesa != null && remesa.getRmtipoexpediente() != null
				&& (remesa.getRmtipoexpediente().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
						|| remesa.getRmtipoexpediente().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
						|| remesa.getRmtipoexpediente().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
			return this.remesaDao.findAllRemesasLikeVistaArbAdhCount(remesa, startsWith);
		} else if (remesa != null && remesa.getRmtipoexpediente() != null
				&& remesa.getRmtipoexpediente().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			return this.remesaDao.findAllRemesasLikeVistaInsCount(remesa, startsWith);
		} else {
			return null;
		}

	}

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            RemesaBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Remesa> findAllRemesasLike(RemesaBusqueda remesa, Pagination pagination, Boolean startsWith) {
		return (List<Remesa>) this.remesaDao.findAllRemesasLike(remesa, pagination, startsWith);
	}

	/**
	 * Counts rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            RemesaBusqueda
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeRemesasCount(RemesaBusqueda remesa, Boolean startsWith) {
		return this.remesaDao.findAllLikeRemesasCount(remesa, startsWith);
	}

	public Remesa findAllBlobRemesa(String codRemesa) {

		Remesa remesaEncontrada = this.remesaDao.findBlobTablaRemesas(codRemesa);

		return remesaEncontrada;
	}

	/**
	 * Devuelve un cdigo nuevo de Remesa utilizando la tabla Remesa_Secuencias.
	 * 
	 * 
	 * @return String
	 */
	public String getIdRemesa() {
		return this.remesaDao.getIdRemesa();
	}

	/**
	 * Comprueba si se ha superado el tiempo mximo en Solicitada para proceder
	 * a cambiarle el estado
	 * 
	 * @param Remesa
	 *            remesa
	 * 
	 * @return Remesa
	 */
	@Override
	public Remesa solicitadaTiempoMaximoAA66(String rmcodigo) {
		RemesaServiceImpl.logger.info(
				"Se comprueba si se ha superado el tiempo mximo en Solicitada para proceder a cambiarle el estado");
		Remesa remesa = this.find(new Remesa(rmcodigo));
		if (remesa.getRmtipo().equalsIgnoreCase(Y41bConstantes.TRAMITE_NOTIFICACION_ELECTRONICA)
				&& remesa.getRmestado().equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_PENDIENTE)) {
			Date fGeneracion = remesa.getRmfechageneracion();
			Parametros horaMax = this.parametrosDao.find(new Parametros(Y41bConstantes.AA66_CONTROL_GENERACION_REMESA));
			fGeneracion.setMinutes(fGeneracion.getMinutes() + Integer.parseInt(horaMax.getValor()));
			if (fGeneracion.before(new Date())) {
				String errorCas = appMessageSource.getMessage("remesa.errorTiempoMax", null,
						new Locale(Y41bConstantes.CASTELLANO));
				String ErrorEus = appMessageSource.getMessage("remesa.errorTiempoMax", null,
						new Locale(Y41bConstantes.EUSKERA));
				remesa.setRmdesErrores(errorCas);
				remesa.setRmdesErroreu(ErrorEus);

				remesa = this.updateEstadoRemesaErronea(remesa, Y41bConstantes.ESTADO_REMESA_ERRONEA, null);
			} else {
				remesa.setRmfechageneracion(fGeneracion);
			}
		}
		return remesa;
	}

	/**
	 * Devuelve todas las remesas en estado EMITIDA o
	 * EMITIDA_RESPUESTAS_ERRONEAS
	 * 
	 * @param remesa
	 *            RemesaBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Remesa> findAllRemesasPendientes(RemesaBusqueda remesa, Pagination pagination) {

		if (pagination == null) {
			pagination = new Pagination();
			pagination.setSort("RMCODIGO");
			pagination.setAscDsc("asc");
		}

		return (List<Remesa>) this.remesaDao.findAllRemesasPendientes(remesa, pagination);
	}

	/**
	 * Finds a List of rows in the SituacionCorreos table.
	 * 
	 * @param situacionCorreos
	 *            SituacionCorreos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<SituacionCorreos> findAllSituacionCorreos(SituacionCorreos situacionCorreos, Pagination pagination) {

		List<SituacionCorreos> listaSitCorreos = (List<SituacionCorreos>) this.remesaDao
				.findAllSituacionCorreos(situacionCorreos, pagination);

		// Locale locale = LocaleContextHolder.getLocale();
		SituacionCorreos situacionCorreosAux = new SituacionCorreos();
		situacionCorreosAux.setCodSitCorreos(Y41bConstantes.REMESAS_SITUACIONCORREOS_OTROS); // appMessageSource.getMessage("remesa.situacionCorreos.otros.valor",
																								// null,
																								// locale));
		situacionCorreosAux.setDescSitCorreosEs(appMessageSource.getMessage("remesa.situacionCorreos.otros.valor", null,
				new Locale(Y41bConstantes.CASTELLANO)));
		situacionCorreosAux.setDescSitCorreosEu(appMessageSource.getMessage("remesa.situacionCorreos.otros.valor", null,
				new Locale(Y41bConstantes.EUSKERA)));

		listaSitCorreos.add(listaSitCorreos.size(), situacionCorreosAux);

		return listaSitCorreos;

		// return (List<SituacionCorreos>)
		// this.remesaDao.findAllSituacionCorreos(
		// situacionCorreos, pagination);
	}

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            RemesaBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Remesa> findAllRemesasLikeExcel(RemesaBusqueda remesa, Pagination pagination, Boolean startsWith) {

		if (remesa != null && remesa.getRmtipoexpediente() != null
				&& remesa.getRmtipoexpediente().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			return (List<Remesa>) this.remesaDao.findAllRemesasLikeExcelSol(remesa, pagination, startsWith);
		} else if (remesa != null && remesa.getRmtipoexpediente() != null
				&& remesa.getRmtipoexpediente().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
			return (List<Remesa>) this.remesaDao.findAllRemesasLikeExcelSan(remesa, pagination, startsWith);
		} else if (remesa != null && remesa.getRmtipoexpediente() != null
				&& remesa.getRmtipoexpediente().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
			return (List<Remesa>) this.remesaDao.findAllRemesasLikeExcelArb(remesa, pagination, startsWith);
		} else if (remesa != null && remesa.getRmtipoexpediente() != null
				&& (remesa.getRmtipoexpediente().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
						|| remesa.getRmtipoexpediente().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
						|| remesa.getRmtipoexpediente().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {
			return (List<Remesa>) this.remesaDao.findAllRemesasLikeExcelArbAdh(remesa, pagination, startsWith);
		} else if (remesa != null && remesa.getRmtipoexpediente() != null
				&& remesa.getRmtipoexpediente().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
			return (List<Remesa>) this.remesaDao.findAllRemesasLikeExcelIns(remesa, pagination, startsWith);
		} else {
			return null;
		}

	}

}