package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.NotificacionesComunicacionesBusqueda;
import com.ejie.y41b.model.Remesa;
import com.ejie.y41b.model.RemesaBusqueda;
import com.ejie.y41b.model.SituacionCorreos;

/**
 * RemesaService  
 * 
 *  
 */

public interface RemesaService {

	/**
	 * Inserts a single row in the Remesa table.
	 * 
	 * @param remesa
	 *            Remesa
	 * @return Remesa
	 */

	Remesa addRemesa(Remesa remesa);

	/**
	 * Inserts a single row in the Remesa table.
	 * 
	 * @param remesa
	 *            Remesa
	 * @return Remesa
	 */
	Remesa add(Remesa remesa);

	/**
	 * Updates a single row in the Remesa table.
	 * 
	 * @param remesa
	 *            Remesa
	 * @return Remesa
	 */
	Remesa updateDatosGeneracion(Remesa remesa);

	/**
	 * Updates a single row in the Remesa table.
	 * 
	 * @param remesa
	 *            Remesa
	 * @return Remesa
	 */
	Remesa updateEstadoRemesa(Remesa remesa);

	/**
	 * Finds a single row in the Remesa table.
	 * 
	 * @param remesa
	 *            Remesa
	 * @return Remesa
	 */
	Remesa find(Remesa remesa);

	// /**
	// * Finds a single row in the Remesa table.
	// *
	// * @param rmcodigo
	// * String
	// * @param idTramite
	// * String
	// *
	// * @return Remesa
	// *
	// */
	// public Remesa findRemesaEnvio(String rmcodigo, String idTramite);

	/**
	 * Finds a List of rows in the Remesa table.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Remesa> findAll(Remesa remesa, Pagination pagination);

	/**
	 * Counts rows in the Remesa table.
	 * 
	 * @param remesa
	 *            Remesa
	 * @return Long
	 */
	Long findAllCount(Remesa remesa);

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Remesa> findAllLike(Remesa remesa, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Remesa remesa, Boolean startsWith);

	/**
	 * Deletes a single row in the Remesa table.
	 * 
	 * @param remesa
	 *            Remesa
	 * @return
	 */
	Remesa remove(Remesa remesa);

	/**
	 * Deletes multiple rows in the Remesa table.
	 * 
	 * @param remesaList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Remesa> remesaList);

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Remesa> findAllRemesasLikeVista(RemesaBusqueda remesa,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllRemesasLikeVistaCount(RemesaBusqueda remesa, Boolean startsWith);

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Remesa> findAllRemesasLike(RemesaBusqueda remesa,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            Remesa
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeRemesasCount(RemesaBusqueda remesa, Boolean startsWith);

	/**
	 * Find a single row in the RemesaTemporal table.
	 * 
	 * @param codRemesa
	 * 
	 * @return
	 */
	public Remesa findAllBlobRemesa(String codRemesa);

	/**
	 * Devuelve un cdigo nuevo de Remesa utilizando la tabla Remesa_Secuencias.
	 * 
	 * 
	 * @return String
	 */
	public String getIdRemesa();

	void prepararLaRemesa(Remesa remesa);

	/**
	 * Consulta los estados de los envos de las notificaciones electrnicas en
	 * correos y en caso de obtener respuesta, actualiza el trmite, los envos
	 * y la remesa
	 */
	public void actualizarEnvios(Remesa remesaEmitida);

	public void actualizarEnvios(Remesa remesaEmitida, CensoMonitor censoMonitor);

	public Remesa updateEstadoRemesaErronea_Y_Estado(Remesa remesa,
			String tipoError, Throwable t, String trazaPuntoActual);

	public Remesa solicitadaTiempoMaximoAA66(String rmcodigo);

	/**
	 * Devuelve todas las remesas en estado EMITIDA o
	 * EMITIDA_RESPUESTAS_ERRONEAS
	 * 
	 * @param remesa
	 *            RemesaBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Remesa> findAllRemesasPendientes(RemesaBusqueda remesa,
			Pagination pagination);

	/**
	 * Finds a List of rows in the SituacionCorreos table.
	 * 
	 * @param situacionCorreos
	 *            SituacionCorreos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<SituacionCorreos> findAllSituacionCorreos(
			SituacionCorreos situacionCorreos, Pagination pagination);

	/**
	 * Finds rows in the Remesa table using like.
	 * 
	 * @param remesa
	 *            RemesaBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Remesa> findAllRemesasLikeExcel(RemesaBusqueda remesa,
			Pagination pagination, Boolean startsWith);

	/**
	 * Devuelve la list con todas las notificaciones
	 * 
	 * @param remesa
	 *            Remesa
	 * @return List<NotificacionesComunicacionesBusqueda>
	 */
	public List<NotificacionesComunicacionesBusqueda> findAllNotiComuni(
			Remesa remesa);

	/**
	 * Devuelve el usuario XlNet del envo
	 * 
	 * @param paramRemesa
	 *            Remesa
	 * @return String
	 */
	public String getPuestoXlNet(Remesa paramRemesa);
}
