package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.RecursoDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Recurso;
import com.ejie.y41b.utils.Y41bUIDGenerator;

/**
 * RecursoServiceImpl  
 * 
 *  
 */

@Service(value = "recursoService")
public class RecursoServiceImpl implements RecursoService {

	@Autowired
	private RecursoDao recursoDao;

	/**
	 * Inserts a single row in the Recurso table.
	 * 
	 * @param recurso
	 *            Recurso
	 * @return Recurso
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Recurso add(Recurso recurso) {

		recurso.setRecodigo(Y41bUIDGenerator.getInstance().generateId(
				Y41bConstantes.PK_SIZE));

		return this.recursoDao.add(recurso);
	}

	/**
	 * Updates a single row in the Recurso table.
	 * 
	 * @param recurso
	 *            Recurso
	 * @return Recurso
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Recurso update(Recurso recurso) {
		return this.recursoDao.update(recurso);
	}

	/**
	 * Finds a single row in the Recurso table.
	 * 
	 * @param recurso
	 *            Recurso
	 * @return Recurso
	 */
	public Recurso find(Recurso recurso) {
		return (Recurso) this.recursoDao.find(recurso);
	}

	/**
	 * Finds a List of rows in the Recurso table.
	 * 
	 * @param recurso
	 *            Recurso
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Recurso> findAll(Recurso recurso, Pagination pagination) {
		return (List<Recurso>) this.recursoDao.findAll(recurso, pagination);
	}

	/**
	 * Counts rows in the Recurso table.
	 * 
	 * @param recurso
	 *            Recurso
	 * @return Long
	 */
	public Long findAllCount(Recurso recurso) {
		return this.recursoDao.findAllCount(recurso);
	}

	/**
	 * Finds rows in the Recurso table using like.
	 * 
	 * @param recurso
	 *            Recurso
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Recurso> findAllLike(Recurso recurso, Pagination pagination,
			Boolean startsWith) {
		return (List<Recurso>) this.recursoDao.findAllLike(recurso, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Recurso table using like.
	 * 
	 * @param recurso
	 *            Recurso
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Recurso recurso, Boolean startsWith) {
		return this.recursoDao.findAllLikeCount(recurso, startsWith);
	}

	/**
	 * Deletes a single row in the Recurso table.
	 * 
	 * @param recurso
	 *            Recurso
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Recurso recurso) {
		this.recursoDao.remove(recurso);
	}

	/**
	 * Deletes multiple rows in the Recurso table.
	 * 
	 * @param recursoList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Recurso> recursoList) {
		for (Recurso recursoAux : recursoList) {
			this.recursoDao.remove(recursoAux);
		}
	}

}
