package com.ejie.y41b.service;


import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Recurso;

/**
 * RecursoService  
 *  
 */

public interface RecursoService {

	/**
	 * Inserts a single row in the Recurso table.
	 *
	 * @param recurso Recurso
	 * @return Recurso
	 */
    Recurso add(Recurso recurso);

	/**
	 * Updates a single row in the Recurso table.
	 *
	 * @param recurso Recurso
	 * @return Recurso
	 */
	Recurso update(Recurso recurso);

	/**
	 * Finds a single row in the Recurso table.
	 *
	 * @param recurso Recurso
	 * @return Recurso
	 */
	Recurso find(Recurso recurso);

	/**
	 * Finds a List of rows in the Recurso table.
	 *
	 * @param recurso Recurso
	 * @param pagination Pagination
	 * @return List
	 */
	List<Recurso> findAll(Recurso recurso, Pagination pagination);

	/**
	 * Counts rows in the Recurso table.
	 *
	 * @param recurso Recurso
	 * @return Long
	 */
	Long findAllCount(Recurso recurso);
	
	/**
	 * Finds rows in the Recurso table using like.
	 *
	 * @param recurso Recurso
	 * @param pagination Pagination
     * @param startsWith Boolean	 
	 * @return List
	 */
	List<Recurso> findAllLike(Recurso recurso, Pagination pagination, Boolean startsWith) ;

	/**
	 * Counts rows in the Recurso table using like.
	 *
	 * @param recurso Recurso
     * @param startsWith Boolean	 
	 * @return Long
	 */
	Long findAllLikeCount(Recurso recurso, Boolean startsWith) ;
  
	/**
	 * Deletes a single row in the Recurso table.
	 *
	 * @param recurso Recurso
	 * @return 
	 */
	void remove(Recurso recurso);
	
	/**
	 * Deletes multiple rows in the Recurso table.
	 *
	 * @param recursoList List
	 * @return 
	 */	
	void removeMultiple(List<Recurso> recursoList);
    
}


