// CHECKSTYLE:OFF
package com.ejie.y41b.service;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.ReclamacionArbDao;
import com.ejie.y41b.model.ReclamacionArb;

/**
 * * ReclamacionArbServiceImpl  
 * 
 *  
 */
@Service(value = "ReclamacionArbService")
public class ReclamacionArbServiceImpl implements ReclamacionArbService {

	private static final Logger logger = LoggerFactory
			.getLogger(ReclamacionArbServiceImpl.class);

	@Autowired
	private ReclamacionArbDao reclamacionArbDao;

	/**
	 * Finds a List of rows in the ReclamacionArb table.
	 * 
	 * @param solicitudesBusqueda
	 *            ReclamacionArb
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<ReclamacionArb> findAllLikeSolicitudes(
			ReclamacionArb solicitudesBusqueda, Pagination pagination,
			Boolean startsWith) {

		ReclamacionArbServiceImpl.logger
				.debug("inicio mtodo findAllLikeSolicitudes");

		try {
			List<ReclamacionArb> listSolicitudesBusqueda = this.reclamacionArbDao
					.findAllLikeSolicitudes(solicitudesBusqueda, pagination,
							startsWith);

			return listSolicitudesBusqueda;
		} catch (Exception e) {
			return null;
		}
	}

	/**
	 * Counts rows in the ReclamacionArb table.
	 * 
	 * @param solicitudesBusqueda
	 *            ReclamacionArb
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeSolicitudesCount(ReclamacionArb solicitudesBusqueda,
			Boolean startsWith) {
		return this.reclamacionArbDao.findAllLikeSolicitudesCount(
				solicitudesBusqueda, startsWith);
	}

}