package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.ReclamacionArb;

/**
 * * ReclamacionArbService  
 * 
 *  
 */

public interface ReclamacionArbService {

	/**
	 * Finds a List of rows in the ReclamacionArb table.
	 * 
	 * @param solicitudesBusqueda
	 *            ReclamacionArb
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<ReclamacionArb> findAllLikeSolicitudes(
			ReclamacionArb solicitudesBusqueda, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param solicitudesBusqueda
	 *            ReclamacionArb
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeSolicitudesCount(ReclamacionArb solicitudesBusqueda,
			Boolean startsWith);

}
