package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.RangoEdadDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.RangoEdad;

/**
 * * RangoEdadServiceImpl  
 * 
 *  
 */

@Service(value = "rangoEdadService")
public class RangoEdadServiceImpl implements RangoEdadService {

	private static final Logger logger = LoggerFactory
			.getLogger(RangoEdadServiceImpl.class);
	@Autowired
	private RangoEdadDao rangoEdadDao;

	/**
	 * Inserts a single row in the RangoEdad table.
	 * 
	 * @param rangoEdad
	 *            RangoEdad
	 * @return RangoEdad
	 */
	@Transactional(rollbackFor = Throwable.class)
	public RangoEdad add(RangoEdad rangoEdad) {
		return this.rangoEdadDao.add(rangoEdad);
	}

	/**
	 * Updates a single row in the RangoEdad table.
	 * 
	 * @param rangoEdad
	 *            RangoEdad
	 * @return RangoEdad
	 */
	@Transactional(rollbackFor = Throwable.class)
	public RangoEdad update(RangoEdad rangoEdad) {
		return this.rangoEdadDao.update(rangoEdad);
	}

	/**
	 * Finds a single row in the RangoEdad table.
	 * 
	 * @param rangoEdad
	 *            RangoEdad
	 * @return RangoEdad
	 */
	public RangoEdad find(RangoEdad rangoEdad) {
		return (RangoEdad) this.rangoEdadDao.find(rangoEdad);
	}

	/**
	 * Finds a List of rows in the RangoEdad table.
	 * 
	 * @param rangoEdad
	 *            RangoEdad
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<RangoEdad> findAll(RangoEdad rangoEdad, Pagination pagination) {
		return (List<RangoEdad>) this.rangoEdadDao.findAll(rangoEdad,
				pagination);
	}

	/**
	 * Counts rows in the RangoEdad table.
	 * 
	 * @param rangoEdad
	 *            RangoEdad
	 * @return Long
	 */
	public Long findAllCount(RangoEdad rangoEdad) {
		return this.rangoEdadDao.findAllCount(rangoEdad);
	}

	/**
	 * Finds rows in the RangoEdad table using like.
	 * 
	 * @param rangoEdad
	 *            RangoEdad
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<RangoEdad> findAllLike(RangoEdad rangoEdad,
			Pagination pagination, Boolean startsWith) {
		return (List<RangoEdad>) this.rangoEdadDao.findAllLike(rangoEdad,
				pagination, startsWith);
	}

	/**
	 * Deletes a single row in the RangoEdad table.
	 * 
	 * @param rangoEdad
	 *            RangoEdad
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(RangoEdad rangoEdad) {
		this.rangoEdadDao.remove(rangoEdad);
	}

	/**
	 * Deletes multiple rows in the RangoEdad table.
	 * 
	 * @param rangoEdadList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<RangoEdad> rangoEdadList) {
		for (RangoEdad rangoEdadAux : rangoEdadList) {
			this.rangoEdadDao.remove(rangoEdadAux);
		}
	}

	/**
	 * Getter method for RangoEdadDao
	 * 
	 * @return RangoEdadDao
	 */
	public RangoEdadDao getRangoEdadDao() {
		return this.rangoEdadDao;
	}

	/**
	 * Setter method for RangoEdadDao.
	 * 
	 * @param rangoEdadDao
	 *            RangoEdadDao
	 * @return
	 */
	public void setRangoEdadDao(RangoEdadDao rangoEdadDao) {
		logger.info("Setting Dependency " + rangoEdadDao);
		this.rangoEdadDao = rangoEdadDao;
	}
}
