package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.ArrayList;
import java.util.List;

import com.ejie.y41b.model.RangoEdad;

/**
 * * RangoEdadService  
 * 
 *  
 */

public interface RangoEdadService {

	/**
	 * Inserts a single row in the RangoEdad table.
	 * 
	 * @param rangoEdad
	 *            RangoEdad
	 * @return RangoEdad
	 */
	RangoEdad add(RangoEdad rangoEdad);

	/**
	 * Updates a single row in the RangoEdad table.
	 * 
	 * @param rangoEdad
	 *            RangoEdad
	 * @return RangoEdad
	 */
	RangoEdad update(RangoEdad rangoEdad);

	/**
	 * Finds a single row in the RangoEdad table.
	 * 
	 * @param rangoEdad
	 *            RangoEdad
	 * @return RangoEdad
	 */
	RangoEdad find(RangoEdad rangoEdad);

	/**
	 * Finds a List of rows in the RangoEdad table.
	 * 
	 * @param rangoEdad
	 *            RangoEdad
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<RangoEdad> findAll(RangoEdad rangoEdad, Pagination pagination);

	/**
	 * Counts rows in the RangoEdad table.
	 * 
	 * @param rangoEdad
	 *            RangoEdad
	 * @return Long
	 */
	Long findAllCount(RangoEdad rangoEdad);

	/**
	 * Finds rows in the RangoEdad table using like.
	 * 
	 * @param rangoEdad
	 *            RangoEdad
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<RangoEdad> findAllLike(RangoEdad rangoEdad, Pagination pagination,
			Boolean startsWith);

	/**
	 * Deletes a single row in the RangoEdad table.
	 * 
	 * @param rangoEdad
	 *            RangoEdad
	 * @return
	 */
	void remove(RangoEdad rangoEdad);

	/**
	 * Deletes multiple rows in the RangoEdad table.
	 * 
	 * @param rangoEdadList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<RangoEdad> rangoEdadList);

}
