package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.ProvincDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Provinc;

/**
 * ProvincServiceImpl  
 *  
 */

@Service(value = "provincService")
public class ProvincServiceImpl implements ProvincService {

	@Autowired
	private ProvincDao provincDao;

	/**
	 * Inserts a single row in the Provinc table.
	 *
	 * @param provinc Provinc
	 * @return Provinc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Provinc add(Provinc provinc) {
		return this.provincDao.add(provinc);
	}

	/**
	 * Updates a single row in the Provinc table.
	 *
	 * @param provinc Provinc
	 * @return Provinc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Provinc update(Provinc provinc) {
		return this.provincDao.update(provinc);
	 }

	/**
	 * Finds a single row in the Provinc table.
	 *
	 * @param provinc Provinc
	 * @return Provinc
	 */
	public Provinc find(Provinc provinc) {
		return (Provinc) this.provincDao.find(provinc);
	}

	/**
	 * Finds a List of rows in the Provinc table.
	 *
	 * @param provinc Provinc
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Provinc> findAll(Provinc provinc, Pagination pagination) {
		return (List<Provinc>) this.provincDao.findAll(provinc, pagination);
	}
    
	/**
	 * Counts rows in the Provinc table.
	 *
	 * @param provinc Provinc
	 * @return Long
	 */
	public Long findAllCount(Provinc provinc) {        
		return  this.provincDao.findAllCount(provinc);
	}

	/**
	 * Finds rows in the Provinc table using like.
	 *
	 * @param provinc Provinc
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Provinc> findAllLike(Provinc provinc, Pagination pagination, Boolean startsWith) {
		return (List<Provinc>) this.provincDao.findAllLike(provinc, pagination, startsWith);
	}

	/**
	 * Counts rows in the Provinc table using like.
	 *
	 * @param provinc Provinc
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Provinc provinc, Boolean startsWith) {
		return this.provincDao.findAllLikeCount(provinc, startsWith);
	}
	    
	/**
	 * Deletes a single row in the Provinc table.
	 *
	 * @param provinc Provinc
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Provinc provinc) {
		this.provincDao.remove(provinc);
	}
	
	/**
	 * Deletes multiple rows in the Provinc table.
	 *
	 * @param provincList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Provinc> provincList) {
		for (Provinc  provincAux:provincList) {
			this.provincDao.remove(provincAux);
		}
	}
	
}

