package com.ejie.y41b.service;

import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestParam;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ActaDao;
import com.ejie.y41b.dao.ActaInfraccionDao;
import com.ejie.y41b.dao.ActaNuevaDao;
import com.ejie.y41b.dao.ActuacionDao;
import com.ejie.y41b.dao.IntervinientesDao;
import com.ejie.y41b.dao.ProtocolDao;
import com.ejie.y41b.dao.TipPregProtocDao;
import com.ejie.y41b.dao.TipProtocoloDao;
import com.ejie.y41b.model.ActaInfraccion;
import com.ejie.y41b.model.ActaNueva;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Protocol;
import com.ejie.y41b.model.ProtocoloCabecera;
import com.ejie.y41b.model.TipPregProtoc;
import com.ejie.y41b.model.TipProtocolo;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * ProtocolServiceImpl  
 * 
 *  
 */

@Service(value = "protocolService")
public class ProtocolServiceImpl implements ProtocolService {

	@Autowired
	private ProtocolDao protocolDao;

	@Autowired
	private TipProtocoloDao tipProtocoloDao;

	@Autowired
	private TipPregProtocDao tipPregProtocDao;

	@Autowired
	private ActaInfraccionDao actaInfraccionDao;

	@Autowired
	private IntervinientesDao intervinientesDao;

	@Autowired
	private ActuacionDao actuacionDao;

	@Autowired
	private ActaDao actaDao;

	@Autowired
	private ActaNuevaDao actaNuevaDao;

	@Autowired
	private InstramexpService instramexpService;

	@Autowired
	private TipPregProtocService tipPregProtocService;

	/**
	 * Inserts a single row in the Protocol table.
	 * 
	 * @param protocol
	 *            Protocol
	 * @return Protocol
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Protocol add(Protocol protocol) {
		return this.protocolDao.add(protocol);
	}

	/**
	 * Updates rows in the Protocol table.
	 * 
	 * @param allRequestParams
	 *            Protocol
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void updateAnswers(@RequestParam Map<String, String> allRequestParams) {

		String codActuacion = allRequestParams.get("codActuacion");
		String tipProtocolo = allRequestParams.get("tipProtocolo");
		allRequestParams.remove("codActuacion");
		allRequestParams.remove("_");
		allRequestParams.remove("tipProtocolo");
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcoat(codActuacion);
		protocolDao.removeByActuacion(actuacion, tipProtocolo);
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(codActuacion);
		actaInfraccionDao.removeAllInfraccionesByProtocolo(tramiteComun, tipProtocolo);

		HashMap<String, String> mapInfracciones = new HashMap<String, String>();

		for (Map.Entry<String, String> entry : allRequestParams.entrySet()) {
			Protocol protocol = new Protocol();
			protocol.setPtcotr(entry.getKey());
			protocol.setPtcoat(codActuacion);
			if (entry.getValue().equalsIgnoreCase("si")) {
				protocol.setPtcoretp("S");
			} else if (entry.getValue().equalsIgnoreCase("no")) {
				protocol.setPtcoretp("N");
			} else if (entry.getValue().equalsIgnoreCase("np")) {
				protocol.setPtcoretp("-");
			}
			protocol.setPtcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			protocol.setPtnrprtp(1);

			protocolDao.add(protocol);

			if (!entry.getValue().equalsIgnoreCase("np")) {
				TipPregProtoc tipPregProtoc = new TipPregProtoc();
				tipPregProtoc.setTrcodigo(entry.getKey());
				tipPregProtoc = tipPregProtocDao.find(tipPregProtoc);
				if (tipPregProtoc != null && tipPregProtoc.getTrinre() != null
						&& tipPregProtoc.getTrinre().equalsIgnoreCase("S") && tipPregProtoc.getTrrees() != null
						&& !tipPregProtoc.getTrrees().equalsIgnoreCase(protocol.getPtcoretp())) {
					if (tipPregProtoc.getTrcotti() != null
							&& !mapInfracciones.containsKey(tipPregProtoc.getTrcotti())) {
						mapInfracciones.put(tipPregProtoc.getTrcotti(), "S");
						ActaInfraccion actaInfraccion = new ActaInfraccion();
						String aiinexii = "N";
						if (tipPregProtoc.getTrcotti() != null && tipPregProtoc.getTrcotti().indexOf("N0") > -1) {
							// es un articulo
							aiinexii = "S";
						}
						actaInfraccion.setAicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
						actaInfraccion.setAicotti(tipPregProtoc.getTrcotti());
						actaInfraccion.setAicoat(codActuacion);
						actaInfraccion.setAiinexii(aiinexii);
						actaInfraccion.setAicotp(tipProtocolo);
						actaInfraccionDao.add(actaInfraccion);
					}

				}
			}

		}

		if (this.tipPregProtocService.checkAnswersFilledProtocolo(codActuacion, tipProtocolo)) {
			Actuacion actuacionAux = new Actuacion();
			actuacionAux.setAtcodigo(codActuacion);

			TipProtocolo tipprotocolo = new TipProtocolo();
			tipprotocolo.setTpcodigo(tipProtocolo);

			tipprotocolo = this.tipProtocoloDao.find(tipprotocolo);

			InspeccionDetalle inspeccionDetalle = this.actaDao.findInspeccion(actuacionAux);

			if (inspeccionDetalle != null && inspeccionDetalle.getAttipo() != null
					&& (inspeccionDetalle.getAttipo().equals(Y41bConstantes.TIPO_INSPECCION_CONTROL_ESTANDAR)
							|| inspeccionDetalle.getAttipo().equals(Y41bConstantes.TIPO_INSPECCION_CONTROL_OTROS))) {
				if (tipprotocolo != null && tipprotocolo.getTpestandar() != null
						&& tipprotocolo.getTpestandar().equals(Y41bConstantes.VALOR_SI)) {
					this.actuacionDao.updateIsCONTROLESTANDAR(actuacionAux);
				} else {
					this.actuacionDao.updateIsCONTROLOTROS(actuacionAux);
				}
			}
		}
	}

	/**
	 * Updates a bunch of rows in the Protocol table.
	 * 
	 * @param protocol
	 *            Protocol
	 * @return Protocol
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Protocol update(Protocol protocol) {
		return this.protocolDao.update(protocol);
	}

	/**
	 * Finds a single row in the Protocol table.
	 * 
	 * @param protocol
	 *            Protocol
	 * @return Protocol
	 */
	public Protocol find(Protocol protocol) {
		return (Protocol) this.protocolDao.find(protocol);
	}

	/**
	 * Finds a List of rows in the Protocol table.
	 * 
	 * @param protocol
	 *            Protocol
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Protocol> findAll(Protocol protocol, Pagination pagination) {
		return (List<Protocol>) this.protocolDao.findAll(protocol, pagination);
	}

	/**
	 * Counts rows in the Protocol table.
	 * 
	 * @param protocol
	 *            Protocol
	 * @return Long
	 */
	public Long findAllCount(Protocol protocol) {
		return this.protocolDao.findAllCount(protocol);
	}

	/**
	 * Finds rows in the Protocol table using like.
	 * 
	 * @param protocol
	 *            Protocol
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Protocol> findAllLike(Protocol protocol, Pagination pagination, Boolean startsWith) {
		return (List<Protocol>) this.protocolDao.findAllLike(protocol, pagination, startsWith);
	}

	/**
	 * Counts rows in the Protocol table using like.
	 * 
	 * @param protocol
	 *            Protocol
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Protocol protocol, Boolean startsWith) {
		return this.protocolDao.findAllLikeCount(protocol, startsWith);
	}

	/**
	 * Deletes a single row in the Protocol table.
	 * 
	 * @param protocol
	 *            Protocol
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Protocol protocol) {
		this.protocolDao.remove(protocol);
	}

	/**
	 * Deletes multiple rows in the Protocol table.
	 * 
	 * @param protocolList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Protocol> protocolList) {
		for (Protocol protocolAux : protocolList) {
			this.protocolDao.remove(protocolAux);
		}
	}

	/**
	 * Updates a single row in the Protocol table.
	 * 
	 * @param codActuacion
	 *            String
	 * @param codTipoProtocolo
	 *            String
	 * @return ProtocoloCabecera
	 */
	public ProtocoloCabecera findCabecera(String codActuacion, String codTipoProtocolo) {

		ProtocoloCabecera protocoloCabecera = new ProtocoloCabecera();

		// ESTABLECIMIENTO VISITADO
		Intervinientes intervinientesV = new Intervinientes();
		intervinientesV.setIdExpediente(codActuacion);
		intervinientesV.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO);

		List<Intervinientes> listIntervinientesV = this.intervinientesDao.findAll(intervinientesV, null);

		Intervinientes intervinientesVAux = null;
		if (listIntervinientesV.size() > 0) {
			intervinientesVAux = listIntervinientesV.get(0);

			protocoloCabecera.setNifV(intervinientesVAux.getNif());

			protocoloCabecera.setRazonSocialV(intervinientesVAux.getNombre());

			protocoloCabecera.setTelefonoV(intervinientesVAux.getNrtel());

			protocoloCabecera.setNombreComercialV(intervinientesVAux.getEsnoco());

			protocoloCabecera.setMunicipioV(intervinientesVAux.getNombreMunicipio());

		}

		StringBuffer direccionCompletaV = new StringBuffer();

		if (intervinientesVAux != null && intervinientesVAux.getNombreCalle() != null
				&& !intervinientesVAux.getNombreCalle().equals("")) {
			direccionCompletaV.append(intervinientesVAux.getNombreCalle());

			if (intervinientesVAux.getNombrePortal() != null && intervinientesVAux.getNombrePortal() != null
					&& !intervinientesVAux.getNombrePortal().equals("")) {
				direccionCompletaV.append(", ").append(intervinientesVAux.getNombrePortal());
			}
			if (intervinientesVAux.getNombrePiso() != null && intervinientesVAux.getNombrePiso() != null
					&& !intervinientesVAux.getNombrePiso().equals("")) {
				direccionCompletaV.append(" ").append(intervinientesVAux.getNombrePiso());
			}
		}

		protocoloCabecera.setDireccionV(direccionCompletaV.toString());

		// ESTABLECIMIENTO RESPONSABLE
		Intervinientes intervinientesR = new Intervinientes();
		intervinientesR.setIdExpediente(codActuacion);
		intervinientesR.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE);

		List<Intervinientes> listIntervinientesR = this.intervinientesDao.findAll(intervinientesR, null);

		Intervinientes intervinientesRAux = null;
		if (listIntervinientesR.size() > 0) {
			intervinientesRAux = listIntervinientesR.get(0);

			protocoloCabecera.setNifR(intervinientesRAux.getNif());

			protocoloCabecera.setResponsableProducto(intervinientesRAux.getNombre());

		}

		StringBuffer direccionCompletaR = new StringBuffer();

		if (intervinientesRAux != null && intervinientesRAux.getNombreCalle() != null
				&& !intervinientesRAux.getNombreCalle().equals("")) {
			direccionCompletaR.append(intervinientesRAux.getNombreCalle());

			if (intervinientesRAux.getNombrePortal() != null && intervinientesRAux.getNombrePortal() != null
					&& !intervinientesRAux.getNombrePortal().equals("")) {
				direccionCompletaR.append(", ").append(intervinientesRAux.getNombrePortal());
			}
			if (intervinientesRAux.getNombrePiso() != null && intervinientesRAux.getNombrePiso() != null
					&& !intervinientesRAux.getNombrePiso().equals("")) {
				direccionCompletaR.append(" ").append(intervinientesRAux.getNombrePiso());
			}
		}

		protocoloCabecera.setDireccionR(direccionCompletaR.toString());

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(codActuacion);
		InspeccionDetalle inspeccionDetalle = this.actaDao.findInspeccion(actuacion);

		// Producto
		protocoloCabecera.setDenominacion(inspeccionDetalle.getAtnoprse());
		protocoloCabecera.setMarcaComercial(inspeccionDetalle.getAtnomaps());
		protocoloCabecera.setModelo(inspeccionDetalle.getAtnomops());
		protocoloCabecera.setTipoLoteModelo(inspeccionDetalle.getAtnrlops());
		protocoloCabecera.setCodigoBarras(inspeccionDetalle.getAtcodigobarras());

		protocoloCabecera.setInforme(this.instramexpService.findNumExpedienteActuacion(codActuacion));

		try {
			protocoloCabecera.setFecha(Y41bUtils.formatearDateToString(inspeccionDetalle.getAtfeprotocolo(),
					Y41bConstantes.FORMATO_FECHA_ES, Y41bConstantes.CASTELLANO));
		} catch (ParseException e) {
			protocoloCabecera.setFecha(null);
		}

		// Texto Tipo Protocolo.
		TipProtocolo tipProtocolo = new TipProtocolo();
		tipProtocolo.setTpcodigo(codTipoProtocolo);
		tipProtocolo = this.tipProtocoloDao.find(tipProtocolo);
		protocoloCabecera.setTipoProtocolo(tipProtocolo.getTpnombre());

		// cod acta
		ActaNueva actanueva = new ActaNueva();
		actanueva.setAncodins(codActuacion);
		actanueva = this.actaNuevaDao.findUltimoActaTramitadaLigadaAProtocolo(actanueva);
		if (actanueva != null && Y41bUtils.isFilled(actanueva.getAncodac())) {
			protocoloCabecera.setCodActa(actanueva.getAncodac());
		}

		return protocoloCabecera;

	}
}
