package com.ejie.y41b.service;

import java.util.List;
import java.util.Map;

import org.springframework.web.bind.annotation.RequestParam;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Protocol;
import com.ejie.y41b.model.ProtocoloCabecera;

/**
 * ProtocolService  
 * 
 *  
 */

public interface ProtocolService {

	/**
	 * Inserts a single row in the Protocol table.
	 * 
	 * @param protocol
	 *            Protocol
	 * @return Protocol
	 */
	Protocol add(Protocol protocol);

	/**
	 * Updates a single row in the Protocol table.
	 * 
	 * @param protocol
	 *            Protocol
	 * @return Protocol
	 */
	Protocol update(Protocol protocol);

	/**
	 * Finds a single row in the Protocol table.
	 * 
	 * @param protocol
	 *            Protocol
	 * @return Protocol
	 */
	Protocol find(Protocol protocol);

	/**
	 * Finds a List of rows in the Protocol table.
	 * 
	 * @param protocol
	 *            Protocol
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Protocol> findAll(Protocol protocol, Pagination pagination);

	/**
	 * Counts rows in the Protocol table.
	 * 
	 * @param protocol
	 *            Protocol
	 * @return Long
	 */
	Long findAllCount(Protocol protocol);

	/**
	 * Finds rows in the Protocol table using like.
	 * 
	 * @param protocol
	 *            Protocol
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Protocol> findAllLike(Protocol protocol, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Protocol table using like.
	 * 
	 * @param protocol
	 *            Protocol
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Protocol protocol, Boolean startsWith);

	/**
	 * Deletes a single row in the Protocol table.
	 * 
	 * @param protocol
	 *            Protocol
	 * @return
	 */
	void remove(Protocol protocol);

	/**
	 * Deletes multiple rows in the Protocol table.
	 * 
	 * @param protocolList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Protocol> protocolList);

	/**
	 * Updates a single row in the Protocol table.
	 * 
	 * @param allRequestParams
	 *            Map<String, String>
	 */
	public void updateAnswers(@RequestParam Map<String, String> allRequestParams);

	/**
	 * Updates a single row in the Protocol table.
	 * 
	 * @param codActuacion
	 *            String
	 * @param codTipoProtocolo
	 *            String
	 * @return ProtocoloCabecera
	 */
	public ProtocoloCabecera findCabecera(String codActuacion,
			String codTipoProtocolo);
}
