package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CampanhaProd;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.Producto;

/**
 * * ProductoService  
 * 
 *  
 */

public interface ProductoService {

	/**
	 * Inserts a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	Producto add(Producto producto);

	/**
	 * Inserts a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	public Producto addProducto(Producto producto);

	/**
	 * Updates a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	Producto update(Producto producto);

	/**
	 * Updates a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	public Producto updateProducto(Producto producto);

	/**
	 * Finds a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	Producto find(Producto producto);

	/**
	 * Finds a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	public Producto findProducto(Producto producto);

	/**
	 * Finds a List of rows in the ProductoDescriptor table.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Descriptor> findAllProductoDescriptor(Producto producto,
			Pagination pagination);

	/**
	 * Finds a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	Producto findProductoSeleccionable(Producto producto);

	/**
	 * Finds a single row in the Producto table.
	 * 
	 * @param campanhaProd
	 *            CampanhaProd
	 * @return Producto
	 */
	public Producto findProductoSeleccionableCampanha(CampanhaProd campanhaProd);

	/**
	 * Finds a List of rows in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Producto> findAll(Producto producto, Pagination pagination);

	/**
	 * Counts rows in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return Long
	 */
	Long findAllCount(Producto producto);

	/**
	 * Finds rows in the Producto table using like.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Producto> findAllLike(Producto producto, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Producto table using like.
	 * 
	 * @param producto
	 *            Producto
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Producto producto, Boolean startsWith);

	/**
	 * Finds rows in the Producto table using like.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Producto> findAllLikeProducto(Producto producto,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeProductoCount(Producto producto, Boolean startsWith);

	/**
	 * Finds rows in the Producto table using like.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Producto> findAllLikeProductoSeleccion(Producto producto,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeProductoSeleccionCount(Producto producto,
			Boolean startsWith);

	/**
	 * Finds rows in the Producto table using like.
	 * 
	 * @param producto
	 *            Producto
	 * @param campanha
	 *            Campanha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Producto> findAllLikeProductoSeleccionCampanha(
			Producto producto, Campanha campanha, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @param campanha
	 *            Campanha
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeProductoSeleccionCampanhaCount(Producto producto,
			Campanha campanha, Boolean startsWith);

	/**
	 * Deletes a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return
	 */
	void remove(Producto producto);

	/**
	 * Deletes a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return
	 */
	public void removeProducto(Producto producto);

	/**
	 * Deletes multiple rows in the Producto table.
	 * 
	 * @param productoList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Producto> productoList);

}
