package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.ProdAgrupadoDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.ProdAgrupado;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ProdAgrupadoServiceImpl  
 * 
 *  
 */

@Service(value = "prodAgrupadoService")
public class ProdAgrupadoServiceImpl implements ProdAgrupadoService {

	@Autowired
	private ProdAgrupadoDao prodAgrupadoDao;

	/**
	 * Inserts a single row in the ProdAgrupado table.
	 * 
	 * @param prodAgrupado
	 *            ProdAgrupado
	 * @return ProdAgrupado
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ProdAgrupado add(ProdAgrupado prodAgrupado) {
		try {
			return this.prodAgrupadoDao.add(prodAgrupado);
		} catch (DuplicateKeyException e) {
			throw new Y41bUDAException(
					"error.productoagrupado.DuplicateKeyException", true, e);
		}
	}

	/**
	 * Updates a single row in the ProdAgrupado table.
	 * 
	 * @param prodAgrupado
	 *            ProdAgrupado
	 * @return ProdAgrupado
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ProdAgrupado update(ProdAgrupado prodAgrupado) {
		return this.prodAgrupadoDao.update(prodAgrupado);
	}

	/**
	 * Finds a single row in the ProdAgrupado table.
	 * 
	 * @param prodAgrupado
	 *            ProdAgrupado
	 * @return ProdAgrupado
	 */
	public ProdAgrupado find(ProdAgrupado prodAgrupado) {
		return (ProdAgrupado) this.prodAgrupadoDao.find(prodAgrupado);
	}

	/**
	 * Finds a List of rows in the ProdAgrupado table.
	 * 
	 * @param prodAgrupado
	 *            ProdAgrupado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<ProdAgrupado> findAll(ProdAgrupado prodAgrupado,
			Pagination pagination) {
		return (List<ProdAgrupado>) this.prodAgrupadoDao.findAll(prodAgrupado,
				pagination);
	}

	/**
	 * Counts rows in the ProdAgrupado table.
	 * 
	 * @param prodAgrupado
	 *            ProdAgrupado
	 * @return Long
	 */
	public Long findAllCount(ProdAgrupado prodAgrupado) {
		return this.prodAgrupadoDao.findAllCount(prodAgrupado);
	}

	/**
	 * Finds rows in the ProdAgrupado table using like.
	 * 
	 * @param prodAgrupado
	 *            ProdAgrupado
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<ProdAgrupado> findAllLike(ProdAgrupado prodAgrupado,
			Pagination pagination, Boolean startsWith) {
		return (List<ProdAgrupado>) this.prodAgrupadoDao.findAllLike(
				prodAgrupado, pagination, startsWith);
	}

	/**
	 * Counts rows in the ProdAgrupado table using like.
	 * 
	 * @param prodAgrupado
	 *            ProdAgrupado
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(ProdAgrupado prodAgrupado, Boolean startsWith) {
		return this.prodAgrupadoDao.findAllLikeCount(prodAgrupado, startsWith);
	}

	/**
	 * Deletes a single row in the ProdAgrupado table.
	 * 
	 * @param prodAgrupado
	 *            ProdAgrupado
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(ProdAgrupado prodAgrupado) {
		try {
			this.prodAgrupadoDao.remove(prodAgrupado);
		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException(
					"error.productoagrupado.DataIntegrityViolationException",
					true, e);
		}
	}

	/**
	 * Deletes multiple rows in the ProdAgrupado table.
	 * 
	 * @param prodAgrupadoList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<ProdAgrupado> prodAgrupadoList) {
		for (ProdAgrupado prodAgrupadoAux : prodAgrupadoList) {
			this.prodAgrupadoDao.remove(prodAgrupadoAux);
		}
	}

}
