package com.ejie.y41b.service;


import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.ProdAgrupado;

/**
 * ProdAgrupadoService  
 *  
 */

public interface ProdAgrupadoService {

	/**
	 * Inserts a single row in the ProdAgrupado table.
	 *
	 * @param prodAgrupado ProdAgrupado
	 * @return ProdAgrupado
	 */
    ProdAgrupado add(ProdAgrupado prodAgrupado);

	/**
	 * Updates a single row in the ProdAgrupado table.
	 *
	 * @param prodAgrupado ProdAgrupado
	 * @return ProdAgrupado
	 */
	ProdAgrupado update(ProdAgrupado prodAgrupado);

	/**
	 * Finds a single row in the ProdAgrupado table.
	 *
	 * @param prodAgrupado ProdAgrupado
	 * @return ProdAgrupado
	 */
	ProdAgrupado find(ProdAgrupado prodAgrupado);

	/**
	 * Finds a List of rows in the ProdAgrupado table.
	 *
	 * @param prodAgrupado ProdAgrupado
	 * @param pagination Pagination
	 * @return List
	 */
	List<ProdAgrupado> findAll(ProdAgrupado prodAgrupado, Pagination pagination);

	/**
	 * Counts rows in the ProdAgrupado table.
	 *
	 * @param prodAgrupado ProdAgrupado
	 * @return Long
	 */
	Long findAllCount(ProdAgrupado prodAgrupado);
	
	/**
	 * Finds rows in the ProdAgrupado table using like.
	 *
	 * @param prodAgrupado ProdAgrupado
	 * @param pagination Pagination
     * @param startsWith Boolean	 
	 * @return List
	 */
	List<ProdAgrupado> findAllLike(ProdAgrupado prodAgrupado, Pagination pagination, Boolean startsWith) ;

	/**
	 * Counts rows in the ProdAgrupado table using like.
	 *
	 * @param prodAgrupado ProdAgrupado
     * @param startsWith Boolean	 
	 * @return Long
	 */
	Long findAllLikeCount(ProdAgrupado prodAgrupado, Boolean startsWith) ;
  
	/**
	 * Deletes a single row in the ProdAgrupado table.
	 *
	 * @param prodAgrupado ProdAgrupado
	 * @return 
	 */
	void remove(ProdAgrupado prodAgrupado);
	
	/**
	 * Deletes multiple rows in the ProdAgrupado table.
	 *
	 * @param prodAgrupadoList List
	 * @return 
	 */	
	void removeMultiple(List<ProdAgrupado> prodAgrupadoList);
    
}


