package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.PosibleTramite;
import com.ejie.y41b.model.Tramite;

/**
 * PosibleTramiteService  
 * 
 *  
 */

public interface PosibleTramiteService {

	/**
	 * Inserts a single row in the PosibleTramite table.
	 * 
	 * @param posibleTramite
	 *            PosibleTramite
	 * @return PosibleTramite
	 */
	PosibleTramite add(PosibleTramite posibleTramite);

	/**
	 * Updates a single row in the PosibleTramite table.
	 * 
	 * @param posibleTramite
	 *            PosibleTramite
	 * @return PosibleTramite
	 */
	PosibleTramite update(PosibleTramite posibleTramite);

	/**
	 * Updates a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Tramite
	 */
	public Tramite updateTramite(Tramite tramite);

	/**
	 * Finds a single row in the PosibleTramite table.
	 * 
	 * @param posibleTramite
	 *            PosibleTramite
	 * @return PosibleTramite
	 */
	PosibleTramite find(PosibleTramite posibleTramite);

	/**
	 * Finds a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Tramite
	 */
	public Tramite findTramite(Tramite tramite);

	/**
	 * Finds a List of rows in the PosibleTramite table.
	 * 
	 * @param posibleTramite
	 *            PosibleTramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<PosibleTramite> findAll(PosibleTramite posibleTramite, Pagination pagination);

	/**
	 * Finds a List of rows in the PosibleTramite table.
	 * 
	 * @param posibleTramite
	 *            PosibleTramite
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Tramite> findAllPosibleTramiteConsumidor(PosibleTramite posibleTramite, CensoMonitor censoMonitor,
			Pagination pagination);

	/**
	 * Counts rows in the PosibleTramite table.
	 * 
	 * @param posibleTramite
	 *            PosibleTramite
	 * @return Long
	 */
	Long findAllCount(PosibleTramite posibleTramite);

	/**
	 * Finds rows in the PosibleTramite table using like.
	 * 
	 * @param posibleTramite
	 *            PosibleTramite
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<PosibleTramite> findAllLike(PosibleTramite posibleTramite, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the PosibleTramite table using like.
	 * 
	 * @param posibleTramite
	 *            PosibleTramite
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(PosibleTramite posibleTramite, Boolean startsWith);

	/**
	 * Deletes a single row in the PosibleTramite table.
	 * 
	 * @param posibleTramite
	 *            PosibleTramite
	 * @return
	 */
	void remove(PosibleTramite posibleTramite);

	/**
	 * Deletes multiple rows in the PosibleTramite table.
	 * 
	 * @param posibleTramiteList
	 *            List
	 * @return
	 */
	void removeMultiple(List<PosibleTramite> posibleTramiteList);

	/**
	 * Finds a List of rows in the PosibleTramite table.
	 * 
	 * @param posibleTramite
	 *            PosibleTramite
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Tramite> findAllPosibleTramite(PosibleTramite posibleTramite, CensoMonitor censoMonitor,
			Pagination pagination);

	/**
	 * Finds a List of rows in the PosibleTramite table.
	 * 
	 * @param posibleTramite
	 *            PosibleTramite
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Tramite> findAllPosibleTramiteInspecciones(PosibleTramite posibleTramite, CensoMonitor censoMonitor,
			Pagination pagination);

	/**
	 * Counts rows in the PosibleTramite table.
	 * 
	 * @param posibleTramite
	 *            PosibleTramite
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllPosibleTramiteCount(PosibleTramite posibleTramite, CensoMonitor censoMonitor);

	/**
	 * Finds a List of rows in the PosibleTramite table.
	 * 
	 * @param posibleTramite
	 *            PosibleTramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Tramite> findAllPosibleTramiteTemporal(PosibleTramite posibleTramite, Pagination pagination);

	/**
	 * Counts rows in the PosibleTramite table.
	 * 
	 * @param posibleTramite
	 *            PosibleTramite
	 * @return Long
	 */
	public Long findAllPosibleTramiteTemporalCount(PosibleTramite posibleTramite);

	/**
	 * Inserts a single row in the PosibleTramite table.
	 * 
	 * @param posibleTramite
	 *            PosibleTramite
	 * @return PosibleTramite
	 */
	public PosibleTramite addPosibleTramiteTemporal(PosibleTramite posibleTramite);

	/**
	 * Deletes a single row in the PosibleTramite table.
	 * 
	 * @param posibleTramite
	 *            PosibleTramite
	 * @return
	 */
	public void removePosibleTramiteTemporal(PosibleTramite posibleTramite);

}
