package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.PlantillaDecisionDao;
import com.ejie.y41b.model.Decision;
import com.ejie.y41b.model.PlantillaDecision;
import com.ejie.y41b.model.PlantillaDecisionBusqueda;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * PlantillaDecisionServiceImpl  
 * 
 *  
 */

@Service(value = "plantillaDecisionService")
public class PlantillaDecisionServiceImpl implements PlantillaDecisionService {

	private static final Logger logger = LoggerFactory
			.getLogger(PlantillaDecisionServiceImpl.class);
	@Autowired
	private PlantillaDecisionDao plantillaDecisionDao;

	/**
	 * Inserts a single row in the PlantillaDecision table.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @return PlantillaDecision
	 */
	@Transactional(rollbackFor = Throwable.class)
	public PlantillaDecision add(PlantillaDecision plantillaDecision) {
		plantillaDecision.setPdcodigo(Y41bUIDGenerator.getInstance()
				.generateId(Y41bConstantes.PK_SIZE));
		plantillaDecision.setPdcoor(Y41bConstantes.CODIGO_ORGANISMO_LAKUA);

		this.plantillaDecisionDao.add(plantillaDecision);

		// comprobacion de que sea unico la descripcion el procedimiento y
		// decision
		PlantillaDecision plantillaDecisionAux = new PlantillaDecision();
		plantillaDecisionAux.setPdnombre(plantillaDecision.getPdnombre());
		plantillaDecisionAux.setPdnombree(plantillaDecision.getPdnombree());

		Decision decisionAux = new Decision();
		decisionAux.setDecodigo(plantillaDecision.getDecision().getDecodigo());
		decisionAux.setPcodigo(plantillaDecision.getDecision().getPcodigo());

		plantillaDecisionAux.setDecision(decisionAux);

		Long numPlantillas = this.plantillaDecisionDao
				.findAllCount(plantillaDecisionAux);

		if (numPlantillas > 1) {
			throw new Y41bUDAException(
					"error.plantilladecision.duplicateException", true,
					new Exception());
		}

		return plantillaDecision;

	}

	/**
	 * Updates a single row in the PlantillaDecision table.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @return PlantillaDecision
	 */
	@Transactional(rollbackFor = Throwable.class)
	public PlantillaDecision update(PlantillaDecision plantillaDecision) {
		return this.plantillaDecisionDao.update(plantillaDecision);
	}

	/**
	 * Updates a single row in the PlantillaDecision table.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @return PlantillaDecision
	 */
	@Transactional(rollbackFor = Throwable.class)
	public PlantillaDecision updateDecision(PlantillaDecision plantillaDecision) {
		return this.plantillaDecisionDao.updateDecision(plantillaDecision);
	}

	/**
	 * Updates a single row in the PlantillaDecision table.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @return PlantillaDecision
	 */
	@Transactional(rollbackFor = Throwable.class)
	public PlantillaDecision updateDecisionTodosOrganismos(
			PlantillaDecision plantillaDecision) {

		// buscar los diferentes codigos de organismo que tienen plantillas
		List<PlantillaDecision> listPlantillaDecision = this.plantillaDecisionDao
				.findAllOrganismos();

		for (PlantillaDecision plantDecision : listPlantillaDecision) {
			plantillaDecision.setPdcoor(plantDecision.getPdcoor());

			this.plantillaDecisionDao.updateDecision(plantillaDecision);
		}
		/*
		 * if (listPlantillaDecision.size() == 0) {
		 * plantillaDecision.setPdcoor(Y41bConstantes.CODIGO_ORGANISMO_LAKUA);
		 * 
		 * this.plantillaDecisionDao.updateDecision(plantillaDecision); }
		 */
		return plantillaDecision;
	}

	/**
	 * Obtiene la plantilla de la decision
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @return PlantillaDecision
	 */
	@Transactional(rollbackFor = Throwable.class)
	public PlantillaDecision obtenerDocumentoPlantilla(
			PlantillaDecision plantillaDecision) {
		plantillaDecision = (PlantillaDecision) this.plantillaDecisionDao
				.find(plantillaDecision);

		return plantillaDecision;
	}

	/**
	 * Finds a single row in the PlantillaDecision table.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @return PlantillaDecision
	 */
	public PlantillaDecision find(PlantillaDecision plantillaDecision) {
		return (PlantillaDecision) this.plantillaDecisionDao
				.find(plantillaDecision);
	}

	/**
	 * Finds a List of rows in the PlantillaDecision table.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<PlantillaDecision> findAll(PlantillaDecision plantillaDecision,
			Pagination pagination) {
		return (List<PlantillaDecision>) this.plantillaDecisionDao.findAll(
				plantillaDecision, pagination);
	}

	/**
	 * Finds a List of rows in the PlantillaDecision table. Nota: Solo busca si
	 * existe el codigo del tipo de decision
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<PlantillaDecisionBusqueda> findAllPlantillaDecisionByDecision(
			PlantillaDecision plantillaDecision, Pagination pagination) {
		List<PlantillaDecisionBusqueda> listPlantillaDecisionBusqueda = new ArrayList<PlantillaDecisionBusqueda>();
		List<PlantillaDecision> listPlantillaDecision = this.plantillaDecisionDao
				.findAllDecisionByDecision(plantillaDecision, pagination);

		for (PlantillaDecision plantDecision : listPlantillaDecision) {

			listPlantillaDecisionBusqueda.add(new PlantillaDecisionBusqueda(
					plantDecision.getPdcodigo(), plantDecision.getDecision()
							.getDecodigo(), plantDecision.getDecision()
							.getDenombre(), plantDecision.getDecision()
							.getDenombree(), plantDecision.getDecision()
							.getDebaja(), plantDecision.getPdcoor(),
					plantDecision.getPdnombre(), plantDecision.getPdnombree(),
					plantDecision.getPdplantilla(), plantDecision
							.getPdplantillae(), plantDecision
							.getPdultmodificacion(), plantDecision
							.getPdcontenttypefile(), plantDecision
							.getPdnofile(), plantDecision.getPdsizefile(),
					plantDecision.getPdcontenttypefilee(), plantDecision
							.getPdnofilee(), plantDecision.getPdsizefilee()));
		}

		return listPlantillaDecisionBusqueda;
	}

	/**
	 * Finds a List of rows in the PlantillaDecision table.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<PlantillaDecisionBusqueda> findAllPlantillaDecision(
			PlantillaDecision plantillaDecision, Pagination pagination) {
		List<PlantillaDecisionBusqueda> listPlantillaDecisionBusqueda = new ArrayList<PlantillaDecisionBusqueda>();
		List<PlantillaDecision> listPlantillaDecision = this.plantillaDecisionDao
				.findAllDecision(plantillaDecision, pagination);

		for (PlantillaDecision plantDecision : listPlantillaDecision) {

			listPlantillaDecisionBusqueda.add(new PlantillaDecisionBusqueda(
					plantDecision.getPdcodigo(), plantDecision.getDecision()
							.getDecodigo(), plantDecision.getDecision()
							.getDenombre(), plantDecision.getDecision()
							.getDenombree(), plantDecision.getDecision()
							.getDebaja(), plantDecision.getPdcoor(),
					plantDecision.getPdnombre(), plantDecision.getPdnombree(),
					plantDecision.getPdplantilla(), plantDecision
							.getPdplantillae(), plantDecision
							.getPdultmodificacion(), plantDecision
							.getPdcontenttypefile(), plantDecision
							.getPdnofile(), plantDecision.getPdsizefile(),
					plantDecision.getPdcontenttypefilee(), plantDecision
							.getPdnofilee(), plantDecision.getPdsizefilee()));
		}

		return listPlantillaDecisionBusqueda;
	}

	/**
	 * Counts rows in the PlantillaDecision table.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @return Long
	 */
	public Long findAllPlantillaDecisionCount(
			PlantillaDecision plantillaDecision) {
		return this.plantillaDecisionDao
				.findAllDecisionCount(plantillaDecision);
	}

	/**
	 * Counts rows in the PlantillaDecision table.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @return Long
	 */
	public Long findAllCount(PlantillaDecision plantillaDecision) {
		return this.plantillaDecisionDao.findAllCount(plantillaDecision);
	}

	/**
	 * Counts rows in the PlantillaDecision table.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @return Long
	 */
	public Long findAllCountPlantillaDecisionByNombre(
			PlantillaDecision plantillaDecision) {
		return this.plantillaDecisionDao
				.findAllCountPlantillaDecisionByNombre(plantillaDecision);
	}

	/**
	 * Finds rows in the PlantillaDecision table using like.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<PlantillaDecision> findAllLike(
			PlantillaDecision plantillaDecision, Pagination pagination,
			Boolean startsWith) {
		return (List<PlantillaDecision>) this.plantillaDecisionDao.findAllLike(
				plantillaDecision, pagination, startsWith);
	}

	/**
	 * Deletes a single row in the PlantillaDecision table.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(PlantillaDecision plantillaDecision) {
		this.plantillaDecisionDao.remove(plantillaDecision);
	}

	/**
	 * Deletes multiple rows in the PlantillaDecision table.
	 * 
	 * @param plantillaDecisionList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(
			ArrayList<PlantillaDecision> plantillaDecisionList) {
		for (PlantillaDecision plantillaDecisionAux : plantillaDecisionList) {
			this.plantillaDecisionDao.remove(plantillaDecisionAux);
		}
	}

	/**
	 * Getter method for PlantillaDecisionDao
	 * 
	 * @return PlantillaDecisionDao
	 */
	public PlantillaDecisionDao getPlantillaDecisionDao() {
		return this.plantillaDecisionDao;
	}

	/**
	 * Setter method for PlantillaDecisionDao.
	 * 
	 * @param plantillaDecisionDao
	 *            PlantillaDecisionDao
	 * @return
	 */
	public void setPlantillaDecisionDao(
			PlantillaDecisionDao plantillaDecisionDao) {
		logger.info("Setting Dependency " + plantillaDecisionDao);
		this.plantillaDecisionDao = plantillaDecisionDao;
	}
}
