package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.PlantillaDecision;
import com.ejie.y41b.model.PlantillaDecisionBusqueda;

/**
 * * PlantillaDecisionService  
 * 
 *  
 */

public interface PlantillaDecisionService {

	/**
	 * Inserts a single row in the PlantillaDecision table.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @return PlantillaDecision
	 */
	PlantillaDecision add(PlantillaDecision plantillaDecision);

	/**
	 * Updates a single row in the PlantillaDecision table.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @return PlantillaDecision
	 */
	PlantillaDecision update(PlantillaDecision plantillaDecision);

	/**
	 * Updates a single row in the PlantillaDecision table.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @return PlantillaDecision
	 */
	PlantillaDecision updateDecision(PlantillaDecision plantillaDecision);

	/**
	 * Updates a single row in the PlantillaDecision table.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @return PlantillaDecision
	 */
	PlantillaDecision updateDecisionTodosOrganismos(
			PlantillaDecision plantillaDecision);

	/**
	 * Obtiene la plantilla de la decision
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @return PlantillaDecision
	 */
	PlantillaDecision obtenerDocumentoPlantilla(
			PlantillaDecision plantillaDecision);

	/**
	 * Finds a single row in the PlantillaDecision table.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @return PlantillaDecision
	 */
	PlantillaDecision find(PlantillaDecision plantillaDecision);

	/**
	 * Finds a List of rows in the PlantillaDecision table.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<PlantillaDecision> findAll(PlantillaDecision plantillaDecision,
			Pagination pagination);

	/**
	 * Finds a List of rows in the PlantillaDecision table. Nota: Solo busca si
	 * existe el codigo del tipo de decision
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<PlantillaDecisionBusqueda> findAllPlantillaDecisionByDecision(
			PlantillaDecision plantillaDecision, Pagination pagination);

	/**
	 * Finds a List of rows in the PlantillaDecision table.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<PlantillaDecisionBusqueda> findAllPlantillaDecision(
			PlantillaDecision plantillaDecision, Pagination pagination);

	/**
	 * Counts rows in the PlantillaDecision table.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @return Long
	 */
	Long findAllPlantillaDecisionCount(PlantillaDecision plantillaDecision);

	/**
	 * Counts rows in the PlantillaDecision table.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @return Long
	 */
	Long findAllCount(PlantillaDecision plantillaDecision);

	/**
	 * Counts rows in the PlantillaDecision table.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @return Long
	 */
	Long findAllCountPlantillaDecisionByNombre(
			PlantillaDecision plantillaDecision);

	/**
	 * Finds rows in the PlantillaDecision table using like.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<PlantillaDecision> findAllLike(PlantillaDecision plantillaDecision,
			Pagination pagination, Boolean startsWith);

	/**
	 * Deletes a single row in the PlantillaDecision table.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @return
	 */
	void remove(PlantillaDecision plantillaDecision);

	/**
	 * Deletes multiple rows in the PlantillaDecision table.
	 * 
	 * @param plantillaDecisionList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<PlantillaDecision> plantillaDecisionList);

}
