package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.Peta1Dao;
import com.ejie.y41b.model.Peta1;

/**
 * Peta1ServiceImpl  
 * 
 *  
 */

@Service(value = "peta1Service")
public class Peta1ServiceImpl implements Peta1Service {

	@Autowired()
	private Peta1Dao peta1Dao;

	/**
	 * Inserts a single row in the Peta1 table.
	 * 
	 * @param peta1
	 *            Peta1
	 * @return Peta1
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Peta1 add(Peta1 peta1) {
		return this.peta1Dao.add(peta1);
	}

	/**
	 * Updates a single row in the Peta1 table.
	 * 
	 * @param peta1
	 *            Peta1
	 * @return Peta1
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Peta1 update(Peta1 peta1) {
		return this.peta1Dao.update(peta1);
	}

	/**
	 * Finds a single row in the Peta1 table.
	 * 
	 * @param peta1
	 *            Peta1
	 * @return Peta1
	 */
	public Peta1 find(Peta1 peta1) {
		return (Peta1) this.peta1Dao.find(peta1);
	}

	/**
	 * Finds a List of rows in the Peta1 table.
	 * 
	 * @param peta1
	 *            Peta1
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Peta1> findAll(Peta1 peta1, Pagination pagination) {
		return (List<Peta1>) this.peta1Dao.findAll(peta1, pagination);
	}

	/**
	 * Counts rows in the Peta1 table.
	 * 
	 * @param peta1
	 *            Peta1
	 * @return Long
	 */
	public Long findAllCount(Peta1 peta1) {
		return this.peta1Dao.findAllCount(peta1);
	}

	/**
	 * Finds rows in the Peta1 table using like.
	 * 
	 * @param peta1
	 *            Peta1
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Peta1> findAllLike(Peta1 peta1, Pagination pagination,
			Boolean startsWith) {
		return (List<Peta1>) this.peta1Dao.findAllLike(peta1, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Peta1 table using like.
	 * 
	 * @param peta1
	 *            Peta1
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Peta1 peta1, Boolean startsWith) {
		return this.peta1Dao.findAllLikeCount(peta1, startsWith);
	}

	/**
	 * Deletes a single row in the Peta1 table.
	 * 
	 * @param peta1
	 *            Peta1
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Peta1 peta1) {
		this.peta1Dao.remove(peta1);
	}

	/**
	 * Deletes multiple rows in the Peta1 table.
	 * 
	 * @param peta1List
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Peta1> peta1List) {
		for (Peta1 peta1Aux : peta1List) {
			this.peta1Dao.remove(peta1Aux);
		}
	}

}
