package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Peta1;

/**
 * Peta1Service  
 * 
 *  
 */

public interface Peta1Service {

	/**
	 * Inserts a single row in the Peta1 table.
	 * 
	 * @param peta1
	 *            Peta1
	 * @return Peta1
	 */
	Peta1 add(Peta1 peta1);

	/**
	 * Updates a single row in the Peta1 table.
	 * 
	 * @param peta1
	 *            Peta1
	 * @return Peta1
	 */
	Peta1 update(Peta1 peta1);

	/**
	 * Finds a single row in the Peta1 table.
	 * 
	 * @param peta1
	 *            Peta1
	 * @return Peta1
	 */
	Peta1 find(Peta1 peta1);

	/**
	 * Finds a List of rows in the Peta1 table.
	 * 
	 * @param peta1
	 *            Peta1
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Peta1> findAll(Peta1 peta1, Pagination pagination);

	/**
	 * Counts rows in the Peta1 table.
	 * 
	 * @param peta1
	 *            Peta1
	 * @return Long
	 */
	Long findAllCount(Peta1 peta1);

	/**
	 * Finds rows in the Peta1 table using like.
	 * 
	 * @param peta1
	 *            Peta1
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Peta1> findAllLike(Peta1 peta1, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Peta1 table using like.
	 * 
	 * @param peta1
	 *            Peta1
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Peta1 peta1, Boolean startsWith);

	/**
	 * Deletes a single row in the Peta1 table.
	 * 
	 * @param peta1
	 *            Peta1
	 * @return
	 */
	void remove(Peta1 peta1);

	/**
	 * Deletes multiple rows in the Peta1 table.
	 * 
	 * @param peta1List
	 *            List
	 * @return
	 */
	void removeMultiple(List<Peta1> peta1List);

}
