package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.PeseDao;
import com.ejie.y41b.model.Pese;

/**
 * PeseServiceImpl  
 * 
 *  
 */

@Service(value = "peseService")
public class PeseServiceImpl implements PeseService {

	@Autowired()
	private PeseDao peseDao;

	/**
	 * Inserts a single row in the Pese table.
	 * 
	 * @param pese
	 *            Pese
	 * @return Pese
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Pese add(Pese pese) {
		return this.peseDao.add(pese);
	}

	/**
	 * Updates a single row in the Pese table.
	 * 
	 * @param pese
	 *            Pese
	 * @return Pese
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Pese update(Pese pese) {
		return this.peseDao.update(pese);
	}

	/**
	 * Finds a single row in the Pese table.
	 * 
	 * @param pese
	 *            Pese
	 * @return Pese
	 */
	public Pese find(Pese pese) {
		return (Pese) this.peseDao.find(pese);
	}

	/**
	 * Finds a List of rows in the Pese table.
	 * 
	 * @param pese
	 *            Pese
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Pese> findAll(Pese pese, Pagination pagination) {
		return (List<Pese>) this.peseDao.findAll(pese, pagination);
	}

	/**
	 * Counts rows in the Pese table.
	 * 
	 * @param pese
	 *            Pese
	 * @return Long
	 */
	public Long findAllCount(Pese pese) {
		return this.peseDao.findAllCount(pese);
	}

	/**
	 * Finds rows in the Pese table using like.
	 * 
	 * @param pese
	 *            Pese
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Pese> findAllLike(Pese pese, Pagination pagination,
			Boolean startsWith) {
		return (List<Pese>) this.peseDao.findAllLike(pese, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Pese table using like.
	 * 
	 * @param pese
	 *            Pese
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Pese pese, Boolean startsWith) {
		return this.peseDao.findAllLikeCount(pese, startsWith);
	}

	/**
	 * Deletes a single row in the Pese table.
	 * 
	 * @param pese
	 *            Pese
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Pese pese) {
		this.peseDao.remove(pese);
	}

	/**
	 * Deletes multiple rows in the Pese table.
	 * 
	 * @param peseList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Pese> peseList) {
		for (Pese peseAux : peseList) {
			this.peseDao.remove(peseAux);
		}
	}

}
