package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Pese;

/**
 * PeseService  
 * 
 *  
 */

public interface PeseService {

	/**
	 * Inserts a single row in the Pese table.
	 * 
	 * @param pese
	 *            Pese
	 * @return Pese
	 */
	Pese add(Pese pese);

	/**
	 * Updates a single row in the Pese table.
	 * 
	 * @param pese
	 *            Pese
	 * @return Pese
	 */
	Pese update(Pese pese);

	/**
	 * Finds a single row in the Pese table.
	 * 
	 * @param pese
	 *            Pese
	 * @return Pese
	 */
	Pese find(Pese pese);

	/**
	 * Finds a List of rows in the Pese table.
	 * 
	 * @param pese
	 *            Pese
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Pese> findAll(Pese pese, Pagination pagination);

	/**
	 * Counts rows in the Pese table.
	 * 
	 * @param pese
	 *            Pese
	 * @return Long
	 */
	Long findAllCount(Pese pese);

	/**
	 * Finds rows in the Pese table using like.
	 * 
	 * @param pese
	 *            Pese
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Pese> findAllLike(Pese pese, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Pese table using like.
	 * 
	 * @param pese
	 *            Pese
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Pese pese, Boolean startsWith);

	/**
	 * Deletes a single row in the Pese table.
	 * 
	 * @param pese
	 *            Pese
	 * @return
	 */
	void remove(Pese pese);

	/**
	 * Deletes multiple rows in the Pese table.
	 * 
	 * @param peseList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Pese> peseList);

}
