package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.PerfilDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Perfil;

/**
 * PerfilServiceImpl  
 * 
 *  
 */

@Service(value = "perfilService")
public class PerfilServiceImpl implements PerfilService {

	@Autowired
	private PerfilDao perfilDao;

	/**
	 * Inserts a single row in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @return Perfil
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Perfil add(Perfil perfil) {
		return this.perfilDao.add(perfil);
	}

	/**
	 * Updates a single row in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @return Perfil
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Perfil update(Perfil perfil) {
		return this.perfilDao.update(perfil);
	}

	/**
	 * Finds a single row in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @return Perfil
	 */
	public Perfil find(Perfil perfil) {
		return (Perfil) this.perfilDao.find(perfil);
	}

	/**
	 * Finds a List of rows in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Perfil> findAll(Perfil perfil, Pagination pagination) {
		return (List<Perfil>) this.perfilDao.findAll(perfil, pagination);
	}

	/**
	 * Finds a List of rows in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Perfil> findAllPerfilFirma(Perfil perfil, Pagination pagination) {
		return (List<Perfil>) this.perfilDao.findAllPerfilFirma(perfil,
				pagination);
	}

	/**
	 * Finds a List of rows in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Perfil> findAllPerfilTramite(Perfil perfil,
			Pagination pagination) {
		return (List<Perfil>) this.perfilDao.findAllPerfilTramite(perfil,
				pagination);
	}

	/**
	 * Counts rows in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @return Long
	 */
	public Long findAllCount(Perfil perfil) {
		return this.perfilDao.findAllCount(perfil);
	}

	/**
	 * Finds rows in the Perfil table using like.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Perfil> findAllLike(Perfil perfil, Pagination pagination,
			Boolean startsWith) {
		return (List<Perfil>) this.perfilDao.findAllLike(perfil, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Perfil table using like.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Perfil perfil, Boolean startsWith) {
		return this.perfilDao.findAllLikeCount(perfil, startsWith);
	}

	/**
	 * Deletes a single row in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Perfil perfil) {
		this.perfilDao.remove(perfil);
	}

	/**
	 * Deletes multiple rows in the Perfil table.
	 * 
	 * @param perfilList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Perfil> perfilList) {
		for (Perfil perfilAux : perfilList) {
			this.perfilDao.remove(perfilAux);
		}
	}

	/**
	 * Finds a List of rows in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Perfil> findAllSinSanciones(Perfil perfil, Pagination pagination) {
		return (List<Perfil>) this.perfilDao.findAllSinSanciones(perfil,
				pagination);
	}

	/**
	 * Finds a List of rows in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Perfil> findAllControlMercado(Perfil perfil,
			Pagination pagination) {
		return (List<Perfil>) this.perfilDao.findAllControlMercado(perfil,
				pagination);
	}
}
