package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.ParametrosDao;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Parametros;

/**
 * ParametrosServiceImpl  
 * 
 *  
 */

@Service(value = "ParametrosService")
public class ParametrosServiceImpl implements ParametrosService {

	@Autowired
	private ParametrosDao parametrosDao;

	/**
	 * Inserts a single row in the Parametros table.
	 * 
	 * @param Parametros
	 *            parametros
	 * @return Parametros
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Parametros add(Parametros parametros) {
		return this.parametrosDao.add(parametros);
	}

	/**
	 * Updates a single row in the Parametros table.
	 * 
	 * @param Parametros
	 *            parametros
	 * @return Parametros
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Parametros update(Parametros parametros) {
		return this.parametrosDao.update(parametros);
	}

	/**
	 * Finds a single row in the Parametros table.
	 * 
	 * @param Parametros
	 *            parametros
	 * @return Parametros
	 */
	public Parametros find(Parametros parametros) {
		return (Parametros) this.parametrosDao.find(parametros);
	}

	/**
	 * Finds a List of rows in the Parametros table.
	 * 
	 * @param Parametros
	 *            parametros
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Parametros> findAll(Parametros parametros, Pagination pagination) {
		return (List<Parametros>) this.parametrosDao.findAll(parametros,
				pagination);
	}

	/**
	 * Counts rows in the Parametros table.
	 * 
	 * @param Parametros
	 *            parametros
	 * @return Long
	 */
	public Long findAllCount(Parametros parametros) {
		return this.parametrosDao.findAllCount(parametros);
	}

	/**
	 * Finds rows in the Parametros table using like.
	 * 
	 * @param Parametros
	 *            parametros
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Parametros> findAllLike(Parametros parametros,
			Pagination pagination, Boolean startsWith) {
		return (List<Parametros>) this.parametrosDao.findAllLike(parametros,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Parametros table using like.
	 * 
	 * @param Parametros
	 *            parametros
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Parametros parametros, Boolean startsWith) {
		return this.parametrosDao.findAllLikeCount(parametros, startsWith);
	}

	/**
	 * Deletes a single row in the Parametros table.
	 * 
	 * @param Parametros
	 *            parametros
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Parametros parametros) {
		this.parametrosDao.remove(parametros);
	}

	/**
	 * Deletes multiple rows in the Parametros table.
	 * 
	 * @param ParametrosList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Parametros> ParametrosList) {
		for (Parametros ParametrosAux : ParametrosList) {
			this.parametrosDao.remove(ParametrosAux);
		}
	}

	/**
	 * Finds rows in the Parametros table using like.
	 * 
	 * @return Map<String, String>
	 */
	public Map<String, String> findParametrosFicheroADO() {

		Map<String, String> mapa = new HashMap<String, String>();
		Parametros parametros = new Parametros();
		parametros.setParametro("ADO_");
		List<Parametros> lista = (List<Parametros>) this.parametrosDao
				.findAllLike(parametros, null, false);

		if (lista != null && lista.size() > 0) {

			for (int i = 0; i < lista.size(); i++) {

				mapa.put(lista.get(i).getParametro(), lista.get(i).getValor());
			}

		}

		return mapa;

	}

}
