package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.PagosArbitrosDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Pagosarbitros;

/**
 * PagosarbitrosServiceImpl  
 * 
 *  
 */

@Service(value = "pagosarbitrosService")
public class PagosarbitrosServiceImpl implements PagosarbitrosService {

	@Autowired
	private PagosArbitrosDao pagosarbitrosDao;

	/**
	 * Inserts a single row in the Pagosarbitros table.
	 *
	 * @param pagosarbitros
	 *            Pagosarbitros
	 * @return Pagosarbitros
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Pagosarbitros add(Pagosarbitros pagosarbitros) {
		return this.pagosarbitrosDao.add(pagosarbitros);
	}

	/**
	 * Updates a single row in the Pagosarbitros table.
	 *
	 * @param pagosarbitros
	 *            Pagosarbitros
	 * @return Pagosarbitros
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Pagosarbitros update(Pagosarbitros pagosarbitros) {
		return this.pagosarbitrosDao.update(pagosarbitros);
	}

	/**
	 * Finds a single row in the Pagosarbitros table.
	 *
	 * @param pagosarbitros
	 *            Pagosarbitros
	 * @return Pagosarbitros
	 */
	public Pagosarbitros find(Pagosarbitros pagosarbitros) {
		return (Pagosarbitros) this.pagosarbitrosDao.find(pagosarbitros);
	}

	/**
	 * Finds a list of rows in the Pagosarbitros table.
	 *
	 * @param pagosarbitros
	 *            Pagosarbitros
	 * @param pagination
	 *            Pagination
	 * @return List<Pagosarbitros>
	 */
	public List<Pagosarbitros> findAll(Pagosarbitros pagosarbitros, Pagination pagination) {
		return (List<Pagosarbitros>) this.pagosarbitrosDao.findAll(pagosarbitros, pagination);
	}

	/**
	 * Counts rows in the Pagosarbitros table.
	 * 
	 * @param pagosarbitros
	 *            Pagosarbitros
	 * @return Long
	 */
	public Long findAllCount(Pagosarbitros pagosarbitros) {
		return this.pagosarbitrosDao.findAllCount(pagosarbitros);
	}

	/**
	 * Finds rows in the Pagosarbitros table using like.
	 *
	 * @param pagosarbitros
	 *            Pagosarbitros
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List<Pagosarbitros>
	 */
	public List<Pagosarbitros> findAllLike(Pagosarbitros pagosarbitros, Pagination pagination, Boolean startsWith) {
		return (List<Pagosarbitros>) this.pagosarbitrosDao.findAllLike(pagosarbitros, pagination, startsWith);
	}

	/**
	 * Counts rows in the Pagosarbitros table using like.
	 * 
	 * @param pagosarbitros
	 *            Pagosarbitros
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Pagosarbitros pagosarbitros, Boolean startsWith) {
		return this.pagosarbitrosDao.findAllLikeCount(pagosarbitros, startsWith);
	}

	/**
	 * Deletes a single row in the Pagosarbitros table.
	 *
	 * @param pagosarbitros
	 *            Pagosarbitros
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Pagosarbitros pagosarbitros) {
		this.pagosarbitrosDao.remove(pagosarbitros);
	}

	/**
	 * Deletes multiple rows in the Pagosarbitros table.
	 * 
	 * @param pagosArbitrosList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Pagosarbitros> pagosArbitrosList) {
		for (Pagosarbitros pagosArbitrosAux : pagosArbitrosList) {
			this.pagosarbitrosDao.remove(pagosArbitrosAux);
		}
	}

	/**
	 * Finds rows in the Pagosarbitros table no actualizadas.
	 *
	 * @return List<Pagosarbitros>
	 */
	public List<Pagosarbitros> findAllSinActualizarOrdenado() {
		return (List<Pagosarbitros>) this.pagosarbitrosDao.findAllSinActualizarOrdenado();
	}

	/**
	 * Counts rows in the Pagosarbitros table no actualizadas.
	 * 
	 * @return Long
	 */
	public Long findAllSinActualizarCount() {
		return this.pagosarbitrosDao.findAllSinActualizarCount();
	}

}
