package com.ejie.y41b.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Pagosarbitros;

/**
 * PagosarbitrosService  
 * 
 *  
 */

public interface PagosarbitrosService {

	/**
	 * Inserts a single row in the Pagosarbitros table.
	 *
	 * @param pagosarbitros
	 *            Pagosarbitros
	 * @return Pagosarbitros
	 */
	Pagosarbitros add(Pagosarbitros pagosarbitros);

	/**
	 * Updates a single row in the Pagosarbitros table.
	 *
	 * @param pagosarbitros
	 *            Pagosarbitros
	 * @return Pagosarbitros
	 */
	Pagosarbitros update(Pagosarbitros pagosarbitros);

	/**
	 * Finds a single row in the Pagosarbitros table.
	 *
	 * @param pagosarbitros
	 *            Pagosarbitros
	 * @return Pagosarbitros
	 */
	Pagosarbitros find(Pagosarbitros pagosarbitros);

	/**
	 * Counts rows in the Pagosarbitros table using like.
	 * 
	 * @param pagosarbitros
	 *            Pagosarbitros
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Pagosarbitros pagosarbitros, Boolean startsWith);

	/**
	 * Deletes a single row in the Pagosarbitros table.
	 *
	 * @param pagosarbitros
	 *            Pagosarbitros
	 */
	void remove(Pagosarbitros pagosarbitros);

	/**
	 * Finds a list of rows in the Pagosarbitros table.
	 *
	 * @param pagosarbitros
	 *            Pagosarbitros
	 * @param pagination
	 *            Pagination
	 * @return List<Pagosarbitros>
	 */
	public List<Pagosarbitros> findAll(Pagosarbitros pagosarbitros, Pagination pagination);

	/**
	 * Counts rows in the Pagosarbitros table.
	 * 
	 * @param pagosarbitros
	 *            Pagosarbitros
	 * @return Long
	 */
	Long findAllCount(Pagosarbitros pagosarbitros);

	/**
	 * Finds rows in the Pagosarbitros table using like.
	 *
	 * @param pagosarbitros
	 *            Pagosarbitros
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List<Pagosarbitros>
	 */
	public List<Pagosarbitros> findAllLike(Pagosarbitros pagosarbitros, Pagination pagination, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Deletes multiple rows in the Pagosarbitros table.
	 * 
	 * @param pagosArbitrosList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Pagosarbitros> pagosArbitrosList);

	/**
	 * Finds rows in the Pagosarbitros table no actualizadas.
	 *
	 * @return List<Pagosarbitros>
	 */
	public List<Pagosarbitros> findAllSinActualizarOrdenado();

	/**
	 * Counts rows in the Pagosarbitros table no actualizadas.
	 * 
	 * @return Long
	 */
	public Long findAllSinActualizarCount();

}
