package com.ejie.y41b.service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ConceptopagoDao;
import com.ejie.y41b.dao.PagosDao;
import com.ejie.y41b.dao.SanexpDao;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Conceptopago;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Estadopago;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Historico;
import com.ejie.y41b.model.Metodopago;
import com.ejie.y41b.model.Movimientos;
import com.ejie.y41b.model.Pagos;
import com.ejie.y41b.model.PagosBusqueda;
import com.ejie.y41b.model.Sanexp;
import com.ejie.y41b.model.Tipoconceptopago;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteGenerico;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.sipca.Y41bFuncionesSipca;
import com.ejie.y41b.validation.Y41bNieValidator;
import com.ejie.y41b.validation.Y41bNifValidator;

/**
 * PagosServiceImpl  
 * 
 *  
 */

@Service(value = "pagosService")
public class PagosServiceImpl implements PagosService {

	@Autowired()
	private PagosDao pagosDao;

	@Autowired()
	private MovimientosService movimientoService;

	@Autowired()
	private HistoricoService historicoService;
	@Autowired()
	private ConceptopagoDao conceptopagoDao;

	@Autowired()
	private SanexpDao sanexpDao;

	@Autowired()
	private SantramexpService santramexpService;

	@Autowired()
	private ExpedienService expedienService;

	/**
	 * Inserts a single row in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagos
	 * @return Pagos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Pagos add(Pagos pagos) {
		pagos.setSgcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
		return this.pagosDao.add(pagos);
	}

	/**
	 * Updates a single row in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagos
	 * @return Pagos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Pagos update(Pagos pagos) {
		return this.pagosDao.update(pagos);
	}

	/**
	 * Updates a single row in the Pagos table.
	 * 
	 * @param nombreOriginal
	 *            String
	 * @param nombreNuevo
	 *            String
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void updateNombreFichero(String nombreOriginal, String nombreNuevo) {
		this.pagosDao.updateNombreFichero(nombreOriginal, nombreNuevo);
	}

	/**
	 * Finds a single row in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagos
	 * @return Pagos
	 */
	public Pagos find(Pagos pagos) {
		return this.pagosDao.find(pagos);
	}

	/**
	 * Finds a single row in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagos
	 * @return Pagos
	 */
	public Pagos findHR(Pagos pagos) {
		return this.pagosDao.findHR(pagos);
	}

	/**
	 * Finds a List of rows in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Pagos> findAll(Pagos pagos, Pagination pagination) {
		return (List<Pagos>) this.pagosDao.findAll(pagos, pagination);
	}

	/**
	 * Finds a List of rows in the Pagos table.
	 * 
	 * @param pagosBusqueda
	 *            Pagos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Pagos> findAllPagos(PagosBusqueda pagosBusqueda, Pagination pagination) {
		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("sgexpediente")) {
				pagination.setSort("EXCOOR ASC, CORRELATIVOPAD ASC, EXNRAN  ");
			}
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("sgexpediente")) {
				pagination.setSort("EXCOOR DESC, CORRELATIVOPAD DESC, EXNRAN ");
			}
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("sgreferencia")) {
				pagination.setSort("SGREFERENCIA ASC, SGDIGITOCONTROL ");
			}
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("sgreferencia")) {
				pagination.setSort("SGREFERENCIA DESC, SGDIGITOCONTROL ");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("sgreferenciafracc")) {
				pagination.setSort("SGREFERENCIAFRACC");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("sgestablecimiento.esnombre")) {
				pagination.setSort("ESNOMBRE ");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("conceptopago.sddesces")) {
				pagination.setSort("CONCEPTOPAGOSDDESCES ");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("conceptopago.sddesceu")) {
				pagination.setSort("CONCEPTOPAGOSDDESCEU ");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("estadopago.sadesces")) {
				pagination.setSort("ESTADOPAGOSADESCES ");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("estadopago.sadesceu")) {
				pagination.setSort("ESTADOPAGOSADESCEU ");
			}
			if (pagination.getSort() != null && pagination.getSort().equals("sgimporteEuros")) {
				pagination.setSort("SGIMPORTE ");
			}
		}
		return (List<Pagos>) this.pagosDao.findAllPagos(pagosBusqueda, pagination);
	}

	/**
	 * Finds a List of rows in the Pagos table.
	 * 
	 * @param pagosBusqueda
	 *            Pagos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Pagos> findAllOtrosPagos(PagosBusqueda pagosBusqueda, Pagination pagination) {

		if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
				&& pagination.getSort().equals("sgreferencia")) {
			pagination.setSort("SGREFERENCIA ASC, SGDIGITOCONTROL ");
		}
		if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
				&& pagination.getSort().equals("sgreferencia")) {
			pagination.setSort("SGREFERENCIA DESC, SGDIGITOCONTROL ");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("sgestablecimiento.esnombre")) {
			pagination.setSort("ESNOMBRE ");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("sgestablecimiento.esnif")) {
			pagination.setSort("ESNIF ");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("conceptopago.sdejercicio")) {
			pagination.setSort("CONCEPTOPAGOSDEJERCICIO ");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("conceptopago.sddesces")) {
			pagination.setSort("CONCEPTOPAGOSDDESCES ");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("conceptopago.sddesceu")) {
			pagination.setSort("CONCEPTOPAGOSDDESCEU ");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("estadopago.sadesces")) {
			pagination.setSort("ESTADOPAGOSADESCES ");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("estadopago.sadesceu")) {
			pagination.setSort("ESTADOPAGOSADESCEU ");
		}
		if (pagination.getSort() != null && pagination.getSort().equals("sgimporteEuros")) {
			pagination.setSort("SGIMPORTE ");
		}

		return (List<Pagos>) this.pagosDao.findAllOtrosPagos(pagosBusqueda, pagination);
	}

	/**
	 * Counts rows in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagos
	 * @return Long
	 */
	public Long findAllCount(Pagos pagos) {
		return this.pagosDao.findAllCount(pagos);
	}

	/**
	 * Counts rows in the Pagos table.
	 * 
	 * @param pagosBusqueda
	 *            PagosBusqueda
	 * @return Long
	 */
	public Long findAllCountOtrosPagos(PagosBusqueda pagosBusqueda) {
		return this.pagosDao.findAllCountOtrosPagos(pagosBusqueda);
	}

	/**
	 * Counts rows in the Pagos table.
	 * 
	 * @param pagosBusqueda
	 *            PagosBusqueda
	 * @return Long
	 */
	public Long findAllCountPagos(PagosBusqueda pagosBusqueda) {
		return this.pagosDao.findAllCountPagos(pagosBusqueda);
	}

	/**
	 * Finds rows in the Pagos table using like.
	 * 
	 * @param pagos
	 *            Pagos
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Pagos> findAllLike(Pagos pagos, Pagination pagination, Boolean startsWith) {
		return (List<Pagos>) this.pagosDao.findAllLike(pagos, pagination, startsWith);
	}

	/**
	 * Counts rows in the Pagos table using like.
	 * 
	 * @param pagos
	 *            Pagos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Pagos pagos, Boolean startsWith) {
		return this.pagosDao.findAllLikeCount(pagos, startsWith);
	}

	/**
	 * Deletes a single row in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagos
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Pagos pagos) {
		this.pagosDao.remove(pagos);
	}

	/**
	 * Deletes multiple rows in the Pagos table.
	 * 
	 * @param pagosList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Pagos> pagosList) {
		for (Pagos pagosAux : pagosList) {
			this.pagosDao.remove(pagosAux);
		}
	}

	/**
	 * getNewReferencia
	 * 
	 * @return Long
	 */
	public Long getNewReferencia() {
		return this.pagosDao.getNewReferencia();
	}

	/**
	 * getNewReferencia
	 * 
	 * @return Long
	 */
	public String getNewReferenciaString() {
		Long referencia = this.pagosDao.getNewReferencia();
		return Y41bUtils.zeroPad(referencia.toString(), Y41bConstantes.NUM_11);
	}

	/**
	 * Realiza todos los pasos de emision de una liquidación
	 * 
	 * @param pagos
	 *            Pagos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void emisionLiquidacion(Pagos pagos) {

		this.pagosDao.add(pagos);

		Movimientos movimiento = new Movimientos("", pagos.getSgreferencia(), Y41bConstantes.OPERACION_SIPCA_EMISION,
				Y41bConstantes.PERIODO_VOLUNTARIO, Y41bConstantes.SENTIDO_OPERACION_ENTRADA, pagos.getSgfechaemision(),
				Y41bConstantes.ESTADO_MOVIMIENTO_RECIBIDO, "");
		movimiento = this.movimientoService.add(movimiento);

		Historico historico = new Historico(pagos, movimiento);
		this.historicoService.add(historico);

	}

	/**
	 * Realiza todos los pasos de emision de una liquidación
	 * 
	 * @param pagos
	 *            Pagos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void emisionFraccionamiento(Pagos pagos) {

		Movimientos movimiento = new Movimientos("", pagos.getSgreferencia(),
				Y41bConstantes.OPERACION_SIPCA_FRACCIONAMIENTO, Y41bConstantes.PERIODO_VOLUNTARIO,
				Y41bConstantes.SENTIDO_OPERACION_SALIDA, pagos.getSgfechaemision(),
				Y41bConstantes.ESTADO_MOVIMIENTO_PDTE_ENVIO, "");
		movimiento = this.movimientoService.add(movimiento);

		Historico historico = new Historico(pagos, movimiento);
		this.historicoService.add(historico);
	}

	/**
	 * Permite obtener el numero de envio para un fichero.
	 * 
	 * @return long numero de envio
	 */
	public long obtenerNumEnvio() {
		return this.pagosDao.obtenerNumEnvio();
	}

	/**
	 * @param datos
	 *            Object[]
	 * @throws ParseException
	 *             ParseException
	 */
	public void generarLiquidacionesViaApremio(HashMap<String, String>[] datos) throws ParseException {
		Pagos pago = new Pagos();
		HashMap<String, String> mapa = null;
		for (int i = 0; i < datos.length; i++) {
			mapa = (HashMap<String, String>) datos[i];
			pago.setSgidexpediente(mapa.get("excodigo"));
			if (!this.pagosDao.tieneLiquidacionFirmeNoAnulada(mapa.get("excodigo"))) {
				pago.setSgcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
				pago.setSgreferencia(
						Y41bUtils.zeroPad(this.pagosDao.getNewReferencia().toString(), Y41bConstantes.NUM_11));
				String importe = mapa.get("importePendiente").replace("\u20AC", "");
				importe = importe.replaceAll("\\u002E", "");
				importe = importe.replace('\u002C', '\u002E');
				pago.setSgimporte(new BigDecimal(importe.trim()));
				pago.setSgfechaemision(Y41bUtils.obtenerFechaHoy());
				Calendar c = Calendar.getInstance();
				c.add(Calendar.DAY_OF_MONTH, 1);
				pago.setSgfechalimitepago(c.getTime());
				pago.setSgexpediente(Y41bConstantes.TIPO_PROC_SANCIONES
						.concat(Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP).concat(mapa.get("codCompleto")));
				pago.setSgcodproc(Y41bConstantes.TIPO_PROC_SANCIONES);
				pago.setSgestablecimiento(new Establecimiento(mapa.get("escodigo")));
				pago.setEstadopago(new Estadopago(Y41bConstantes.ESTADO_PAGO_PENDIENTE_ENVIO, null, null));
				pago.setSgfechaestado(Y41bUtils.obtenerFechaHoy());
				Conceptopago conceptoPago = new Conceptopago();
				conceptoPago.setSdconceptoing(Integer.parseInt(Y41bConstantes.CONCEPTOPAGO_SIPCA_DEVENGOEMISION));
				conceptoPago.setTipoconceptopago(
						new Tipoconceptopago(Y41bConstantes.TIPO_CONCEPTO_PAGO_SANCIONES, null, null, null));
				Pagination pagination = new Pagination();
				pagination.setSort("SDEJERCICIO");
				pagination.setSord("desc");
				conceptoPago = this.conceptopagoDao.findAllVigentes(conceptoPago, pagination).get(0);
				pago.setConceptopago(conceptoPago);
				pago.setMetodopago(new Metodopago(Y41bConstantes.PAGO_LIQUIDACION, null, null));
				// Calcular referencia de 13 digitos
				String importeCent = Y41bUtils.transformarEurosACents(pago.getSgimporte());
				String fechaFin = Y41bUtils.formatearDateToString(pago.getSgfechalimitepago(),
						Y41bConstantes.FORMATO_FECHA_PASARELA);
				String referencia = Y41bFuncionesSipca.referenciaDigitoControl(pago.getSgreferencia(),
						conceptoPago.getSdentemisora(), conceptoPago.getSdsufijo().toString(), importeCent, fechaFin);
				String digitoControl = referencia.substring(referencia.length() - 2, referencia.length());
				pago.setSgdigitocontrol(digitoControl);
				// Comprobamos si es sancionado no es un cif, en este caso hay
				// que
				// obtener el nombre y apellidos
				Y41bNifValidator nifValidator = new Y41bNifValidator();
				Y41bNieValidator nieValidator = new Y41bNieValidator();
				if (nifValidator.isValid(mapa.get("esnif").trim(), null)
						|| nieValidator.isValid(mapa.get("esnif").trim(), null)) {
					Pagos pagoAux = new Pagos();
					pagoAux.setSgidexpediente(pago.getSgidexpediente());
					pagoAux = this.pagosDao.findAll(pagoAux, null).get(0);
					pago.setSgnombre(pagoAux.getSgnombre());
					pago.setSgapellido1(pagoAux.getSgapellido1());
					pago.setSgapellido2(pagoAux.getSgapellido2());
				}
				pago.setSgviaapremio(Y41bConstantes.VALOR_NO);
				this.pagosDao.add(pago);

				Movimientos movimiento = new Movimientos("", pago.getSgreferencia(),
						Y41bConstantes.OPERACION_SIPCA_EMISION, Y41bConstantes.PERIODO_EJECUTIVO,
						Y41bConstantes.SENTIDO_OPERACION_SALIDA, pago.getSgfechaemision(),
						Y41bConstantes.ESTADO_MOVIMIENTO_PDTE_ENVIO, "");
				movimiento = this.movimientoService.add(movimiento);

				Historico historico = new Historico(pago, movimiento);
				this.historicoService.add(historico);
			}
		}

	}

	/**
	 * @param pago
	 *            Pagos
	 * @throws ParseException
	 *             ParseException
	 */
	public void generarLiquidacionesHR(Pagos pago) throws ParseException {
		String importe = pago.getSgimporteEuros().replace("\u20AC", "");
		importe = importe.replaceAll("\\u002E", "");
		importe = importe.replace('\u002C', '\u002E');
		pago.setSgimporte(new BigDecimal(importe.trim()));
		if (Y41bUtils.esNullOCadenaVacia(pago.getSgcodigo()) || pago.getSgcodigo().equals("nuevo")) {
			pago.setSgcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			pago.setSgreferencia(Y41bUtils.zeroPad(this.pagosDao.getNewReferencia().toString(), Y41bConstantes.NUM_11));
			pago.setSgcodproc(Y41bConstantes.TIPO_PROC_SANCIONES);
			pago.setEstadopago(new Estadopago(Y41bConstantes.ESTADO_PAGO_PENDIENTE_INGRESO, null, null));
			pago.setSgfechaestado(Y41bUtils.obtenerFechaHoy());

			Conceptopago conceptoPago = this.conceptopagoDao.find(pago.getConceptopago());
			pago.setConceptopago(conceptoPago);
			pago.setMetodopago(new Metodopago(Y41bConstantes.PAGO_LIQUIDACION, null, null));
			// Calcular referencia de 13 digitos
			String importeCent = Y41bUtils.transformarEurosACents(pago.getSgimporte());
			String fechaFin = Y41bUtils.formatearDateToString(pago.getSgfechalimitepago(),
					Y41bConstantes.FORMATO_FECHA_PASARELA);

			String referencia = Y41bFuncionesSipca.referenciaDigitoControl(pago.getSgreferencia(),
					conceptoPago.getSdentemisora(), conceptoPago.getSdsufijo().toString(), importeCent, fechaFin);
			String digitoControl = referencia.substring(referencia.length() - 2, referencia.length());
			pago.setSgdigitocontrol(digitoControl);

			this.pagosDao.add(pago);

			Movimientos movimiento = new Movimientos("", pago.getSgreferencia(), Y41bConstantes.OPERACION_SIPCA_EMISION,
					Y41bConstantes.PERIODO_EJECUTIVO, Y41bConstantes.SENTIDO_OPERACION_SALIDA, pago.getSgfechaemision(),
					Y41bConstantes.ESTADO_MOVIMIENTO_PDTE_ENVIO, "");
			movimiento = this.movimientoService.add(movimiento);

			Historico historico = new Historico(pago, movimiento);
			this.historicoService.add(historico);
		} else {
			Pagos pagoAux = this.pagosDao.findHR(pago);
			pago.setSgcodproc(Y41bConstantes.TIPO_PROC_SANCIONES);
			Conceptopago conceptoPago = this.conceptopagoDao.find(pago.getConceptopago());
			String referencia = Y41bFuncionesSipca.referenciaDigitoControl(pago.getSgreferencia(),
					conceptoPago.getSdentemisora(), conceptoPago.getSdsufijo().toString(),
					Y41bUtils.transformarEurosACents(pago.getSgimporte()), Y41bUtils
							.formatearDateToString(pago.getSgfechalimitepago(), Y41bConstantes.FORMATO_FECHA_PASARELA));
			String digitoControl = referencia.substring(referencia.length() - 2, referencia.length());
			pago.setSgdigitocontrol(digitoControl);
			pago.setSgfechaestado(pagoAux.getSgfechaestado());
			pago.setMetodopago(new Metodopago(Y41bConstantes.PAGO_LIQUIDACION, null, null));
			this.pagosDao.update(pago);
		}
	}

	/**
	 * tieneLiquidacionFirmeNoAnulada
	 * 
	 * @param idExpediente
	 *            String
	 * @return boolean
	 */
	public boolean tieneLiquidacionFirmeNoAnulada(String idExpediente) {
		return this.pagosDao.tieneLiquidacionFirmeNoAnulada(idExpediente);
	}

	/**
	 * referenciaLiquidacionFirmeNoAnulada
	 * 
	 * @param idExpediente
	 *            String
	 * @return String
	 */
	public String referenciaLiquidacionFirmeNoAnulada(String idExpediente) {
		return this.pagosDao.referenciaLiquidacionFirmeNoAnulada(idExpediente);
	}

	/**
	 * @param datos
	 *            Object[]
	 * @throws Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void excluirViaApremio(HashMap<String, String>[] datos, CensoMonitor censoMonitor) throws Exception {
		Pagos pago = new Pagos();
		HashMap<String, String> mapa = null;

		Expedien expedien = new Expedien();
		for (int i = 0; i < datos.length; i++) {
			mapa = (HashMap<String, String>) datos[i];
			pago.setSgidexpediente(mapa.get("excodigo"));
			if (!Y41bUtils.esNullOCadenaVacia(mapa.get("excodigo"))) {
				this.sanexpDao.udpateExcluirViaApremio(mapa.get("excodigo"), Y41bConstantes.VALOR_SI);
				expedien.setExcodigo((mapa.get("excodigo")));
				expedien = this.expedienService.find(expedien);
				this.santramexpService.generarTramiteGenericoViaApremio(expedien, censoMonitor, mapa.get("comentario"),
						Y41bConstantes.VALOR_SI);
			}

		}

	}

	/**
	 * @param datos
	 *            Object[]
	 * @throws ParseException
	 *             ParseException
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void incluirViaApremio(HashMap<String, String>[] datos, CensoMonitor censoMonitor) throws Exception {
		Pagos pago = new Pagos();
		HashMap<String, String> mapa = null;

		Expedien expedien = new Expedien();
		for (int i = 0; i < datos.length; i++) {
			mapa = (HashMap<String, String>) datos[i];
			pago.setSgidexpediente(mapa.get("excodigo"));
			if (!Y41bUtils.esNullOCadenaVacia(mapa.get("excodigo"))) {
				this.sanexpDao.udpateExcluirViaApremio(mapa.get("excodigo"), Y41bConstantes.VALOR_NO);
				expedien.setExcodigo((mapa.get("excodigo")));
				expedien = this.expedienService.find(expedien);
				this.santramexpService.generarTramiteGenericoViaApremio(expedien, censoMonitor, mapa.get("comentario"),
						Y41bConstantes.VALOR_NO);
			}

		}

	}

}
