package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;

import java.text.ParseException;
import java.util.HashMap;
import java.util.List;

import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Pagos;
import com.ejie.y41b.model.PagosBusqueda;

/**
 * PagosService  
 * 
 *  
 */

public interface PagosService {

	/**
	 * Inserts a single row in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagos
	 * @return Pagos
	 */
	Pagos add(Pagos pagos);

	/**
	 * Updates a single row in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagos
	 * @return Pagos
	 */
	Pagos update(Pagos pagos);

	/**
	 * Finds a single row in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagos
	 * @return Pagos
	 */
	Pagos find(Pagos pagos);

	/**
	 * Finds a single row in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagos
	 * @return Pagos
	 */
	Pagos findHR(Pagos pagos);

	/**
	 * Finds a List of rows in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Pagos> findAll(Pagos pagos, Pagination pagination);

	/**
	 * Finds a List of rows in the Pagos table.
	 * 
	 * @param pagosBusqueda
	 *            PagosBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Pagos> findAllPagos(PagosBusqueda pagosBusqueda, Pagination pagination);

	/**
	 * Counts rows in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagos
	 * @return Long
	 */
	Long findAllCount(Pagos pagos);

	/**
	 * Counts rows in the Pagos table.
	 * 
	 * @param pagosBusqueda
	 *            PagosBusqueda
	 * @return Long
	 */
	public Long findAllCountPagos(PagosBusqueda pagosBusqueda);

	/**
	 * Finds rows in the Pagos table using like.
	 * 
	 * @param pagos
	 *            Pagos
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Pagos> findAllLike(Pagos pagos, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Pagos table using like.
	 * 
	 * @param pagos
	 *            Pagos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Pagos pagos, Boolean startsWith);

	/**
	 * Deletes a single row in the Pagos table.
	 * 
	 * @param pagos
	 *            Pagos
	 * @return
	 */
	void remove(Pagos pagos);

	/**
	 * Deletes multiple rows in the Pagos table.
	 * 
	 * @param pagosList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Pagos> pagosList);

	/**
	 * getNewReferencia
	 * 
	 * @return Long
	 */
	public Long getNewReferencia();

	/**
	 * getNewReferenciaString
	 * 
	 * @return String
	 */
	public String getNewReferenciaString();

	/**
	 * Realiza todos los pasos de emision de una liquidación
	 * 
	 * @param pagos
	 *            Pagos
	 */
	public void emisionLiquidacion(Pagos pagos);

	/**
	 * Realiza todos los pasos de emision de un fraccionamiento
	 * 
	 * @param pagos
	 *            Pagos
	 */
	public void emisionFraccionamiento(Pagos pagos);

	/**
	 * Permite obtener el numero de envio para un fichero.
	 * 
	 * @return long numero de envio
	 */
	public long obtenerNumEnvio();

	/**
	 * @param nombreOriginal
	 *            String
	 * @param nombreNuevo
	 *            String
	 */
	void updateNombreFichero(String nombreOriginal, String nombreNuevo);

	/**
	 * @param filterPagosBusqueda
	 *            PagosBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Pagos> findAllOtrosPagos(PagosBusqueda filterPagosBusqueda, Pagination pagination);

	/**
	 * @param filterPagosBusqueda
	 *            PagosBusqueda
	 * @return Long
	 */
	Long findAllCountOtrosPagos(PagosBusqueda filterPagosBusqueda);

	/**
	 * @param datos
	 *            HashMap<String, String>[]
	 * @throws ParseException
	 *             ParseException
	 */
	void generarLiquidacionesViaApremio(HashMap<String, String>[] datos) throws ParseException;

	/**
	 * @param pagos
	 *            Pagos
	 * @throws ParseException
	 *             ParseException
	 */
	public void generarLiquidacionesHR(Pagos pagos) throws ParseException;

	/**
	 * tieneLiquidacionFirmeNoAnulada
	 * 
	 * @param idExpediente
	 *            String
	 * @return boolean
	 */
	public boolean tieneLiquidacionFirmeNoAnulada(String idExpediente);

	/**
	 * referenciaLiquidacionFirmeNoAnulada
	 * 
	 * @param idExpediente
	 *            String
	 * @return String
	 */
	public String referenciaLiquidacionFirmeNoAnulada(String idExpediente);

	/**
	 * @param datos
	 *            HashMap<String, String>[]
	 * @param censoMonitor
	 * @throws ParseException
	 *             ParseException
	 */
	void excluirViaApremio(HashMap<String, String>[] datos, CensoMonitor censoMonitor) throws ParseException, Exception;

	/**
	 * @param datos
	 *            HashMap<String, String>[]
	 * @param censoMonitor
	 * @throws ParseException
	 *             ParseException
	 */
	void incluirViaApremio(HashMap<String, String>[] datos, CensoMonitor censoMonitor) throws ParseException, Exception;

}
