package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.OrganismoDao;
import com.ejie.y41b.model.Contacto;
import com.ejie.y41b.model.Grupo;
import com.ejie.y41b.model.Organismo;

/**
 * * OrganismoServiceImpl  
 * 
 *  
 */

@Service(value = "organismoService")
public class OrganismoServiceImpl implements OrganismoService {

	private static final Logger logger = LoggerFactory.getLogger(OrganismoServiceImpl.class);
	@Autowired
	private OrganismoDao organismoDao;

	/**
	 * Inserts a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Organismo add(Organismo organismo) {
		return this.organismoDao.add(organismo);
	}

	/**
	 * Updates a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Organismo update(Organismo organismo) {
		return this.organismoDao.update(organismo);
	}

	/**
	 * Finds a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo find(Organismo organismo) {
		return (Organismo) this.organismoDao.find(organismo);
	}

	/**
	 * Finds a single row in the Organismo table de KontsumoNet.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findOrganismoKnet(Organismo organismo) {
		return (Organismo) this.organismoDao.findOrganismoKnet(organismo);
	}

	/**
	 * Finds a single row in the Organismo table de KontsumoBide.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findOrganismoKbide(Organismo organismo) {
		return (Organismo) this.organismoDao.findOrganismoKbide(organismo);
	}

	/**
	 * Finds a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findOrganismo(Organismo organismo) {
		return (Organismo) this.organismoDao.findOrganismo(organismo);
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Organismo> findAll(Organismo organismo, Pagination pagination) {
		return (List<Organismo>) this.organismoDao.findAll(organismo, pagination);
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Long
	 */
	public Long findAllCount(Organismo organismo) {
		return this.organismoDao.findAllCount(organismo);
	}

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLike(Organismo organismo, Pagination pagination, Boolean startsWith) {
		return (List<Organismo>) this.organismoDao.findAllLike(organismo, pagination, startsWith);
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismoKnet(Organismo organismo, Pagination pagination, Boolean startsWith) {
		return (List<Organismo>) this.organismoDao.findAllLikeOrganismoKnet(organismo, pagination, startsWith);
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismoKnetCount(Organismo organismo, Boolean startsWith) {
		return this.organismoDao.findAllLikeOrganismoKnetCount(organismo, startsWith);
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismoKbide(Organismo organismo, Pagination pagination, Boolean startsWith) {
		return (List<Organismo>) this.organismoDao.findAllLikeOrganismoKbide(organismo, pagination, startsWith);
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismoKbideCount(Organismo organismo, Boolean startsWith) {
		return this.organismoDao.findAllLikeOrganismoKbideCount(organismo, startsWith);
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismoCambioInstructor(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		return (List<Organismo>) this.organismoDao.findAllLikeOrganismoCambioInstructor(organismo, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismoCambioInstructorCount(Organismo organismo, Boolean startsWith) {
		return this.organismoDao.findAllLikeOrganismoCambioInstructorCount(organismo, startsWith);
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismoKbideKnet(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		return (List<Organismo>) this.organismoDao.findAllLikeOrganismoKbideKnet(organismo, pagination, startsWith);
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismoKbideKnetCount(Organismo organismo, Boolean startsWith) {
		return this.organismoDao.findAllLikeOrganismoKbideKnetCount(organismo, startsWith);
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param codOrgConectado
	 *            String
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismo(Organismo organismo, String codOrgConectado, Pagination pagination,
			Boolean startsWith) {
		return (List<Organismo>) this.organismoDao.findAllLikeOrganismo(organismo, codOrgConectado, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param codOrgConectado
	 *            String
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismoCount(Organismo organismo, String codOrgConectado, Boolean startsWith) {
		return this.organismoDao.findAllLikeOrganismoCount(organismo, codOrgConectado, startsWith);
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return List
	 */
	public List<Grupo> obtenerGruposOrganismo(Organismo organismo) {
		return (List<Grupo>) this.organismoDao.obtenerGruposOrganismo(organismo);
	}

	/**
	 * Deletes a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Organismo organismo) {
		this.organismoDao.remove(organismo);
	}

	/**
	 * Deletes multiple rows in the Organismo table.
	 * 
	 * @param organismoList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Organismo> organismoList) {
		for (Organismo organismoAux : organismoList) {
			this.organismoDao.remove(organismoAux);
		}
	}

	/**
	 * Getter method for OrganismoDao
	 * 
	 * @return OrganismoDao
	 */
	public OrganismoDao getOrganismoDao() {
		return this.organismoDao;
	}

	/**
	 * Setter method for OrganismoDao.
	 * 
	 * @param organismoDao
	 *            OrganismoDao
	 * @return
	 */
	public void setOrganismoDao(OrganismoDao organismoDao) {
		logger.info("Setting Dependency " + organismoDao);
		this.organismoDao = organismoDao;
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismoKTodos(Organismo organismo, Pagination pagination, Boolean startsWith) {
		return (List<Organismo>) this.organismoDao.findAllLikeOrganismoKTodos(organismo, pagination, startsWith);
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismoKTodosCount(Organismo organismo, Boolean startsWith) {
		return this.organismoDao.findAllLikeOrganismoKTodosCount(organismo, startsWith);
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismosCrearSolicitudes(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		return (List<Organismo>) this.organismoDao.findAllLikeOrganismosCrearSolicitudes(organismo, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismosCrearSolicitudesCount(Organismo organismo, Boolean startsWith) {
		return this.organismoDao.findAllLikeOrganismosCrearSolicitudesCount(organismo, startsWith);
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismosNotificacionProductor(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		return (List<Organismo>) this.organismoDao.findAllLikeOrganismosNotificacionProductor(organismo, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismosNotificacionProductorCount(Organismo organismo, Boolean startsWith) {
		return this.organismoDao.findAllLikeOrganismosNotificacionProductorCount(organismo, startsWith);
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismosComunicacionExterna(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		return (List<Organismo>) this.organismoDao.findAllLikeOrganismosComunicacionExterna(organismo, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismosComunicacionExternaCount(Organismo organismo, Boolean startsWith) {
		return this.organismoDao.findAllLikeOrganismosComunicacionExternaCount(organismo, startsWith);
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismosUsuariosKbide13(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		return (List<Organismo>) this.organismoDao.findAllLikeOrganismosUsuariosKbide13(organismo, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismosUsuariosKbide13Count(Organismo organismo, Boolean startsWith) {
		return this.organismoDao.findAllLikeOrganismosUsuariosKbide13Count(organismo, startsWith);
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismosTrasladoConsumo(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		return (List<Organismo>) this.organismoDao.findAllLikeOrganismosTrasladoConsumo(organismo, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismosTrasladoConsumoCount(Organismo organismo, Boolean startsWith) {
		return this.organismoDao.findAllLikeOrganismosTrasladoConsumoCount(organismo, startsWith);
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismosInhibicionConsumo(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		return (List<Organismo>) this.organismoDao.findAllLikeOrganismosInhibicionConsumo(organismo, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismosInhibicionConsumoCount(Organismo organismo, Boolean startsWith) {
		return this.organismoDao.findAllLikeOrganismosInhibicionConsumoCount(organismo, startsWith);
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismosOmicAsociacion(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		return (List<Organismo>) this.organismoDao.findAllLikeOrganismosOmicAsociacion(organismo, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismosOmicAsociacionCount(Organismo organismo, Boolean startsWith) {
		return this.organismoDao.findAllLikeOrganismosOmicAsociacionCount(organismo, startsWith);
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismosOOEE(Organismo organismo, Pagination pagination, Boolean startsWith) {
		return (List<Organismo>) this.organismoDao.findAllLikeOrganismosOOEE(organismo, pagination, startsWith);
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismosOOEECount(Organismo organismo, Boolean startsWith) {
		return this.organismoDao.findAllLikeOrganismosOOEECount(organismo, startsWith);
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismosAACC(Organismo organismo, Pagination pagination, Boolean startsWith) {
		return (List<Organismo>) this.organismoDao.findAllLikeOrganismosAACC(organismo, pagination, startsWith);
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismosAACCCount(Organismo organismo, Boolean startsWith) {
		return this.organismoDao.findAllLikeOrganismosAACCCount(organismo, startsWith);
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismosOtros(Organismo organismo, Pagination pagination, Boolean startsWith) {
		return (List<Organismo>) this.organismoDao.findAllLikeOrganismosOtros(organismo, pagination, startsWith);
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismosOtrosCount(Organismo organismo, Boolean startsWith) {
		return this.organismoDao.findAllLikeOrganismosOtrosCount(organismo, startsWith);
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeUsuariosDenunciasEmpresas(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		return (List<Organismo>) this.organismoDao.findAllLikeUsuariosDenunciasEmpresas(organismo, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeUsuariosDenunciasEmpresasCount(Organismo organismo, Boolean startsWith) {
		return this.organismoDao.findAllLikeUsuariosDenunciasEmpresasCount(organismo, startsWith);
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeCensoUsuarios(Organismo organismo, Pagination pagination, Boolean startsWith) {
		return (List<Organismo>) this.organismoDao.findAllLikeCensoUsuarios(organismo, pagination, startsWith);
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCensoUsuariosCount(Organismo organismo, Boolean startsWith) {
		return this.organismoDao.findAllLikeCensoUsuariosCount(organismo, startsWith);
	}

	/**
	 * Finds a single row in the Organismo table de CrearSolicitudes.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findOrganismoCrearSolicitudes(Organismo organismo) {
		return (Organismo) this.organismoDao.findOrganismoCrearSolicitudes(organismo);
	}

	/**
	 * Finds a single row in the Organismo table de CrearSolicitudes.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findOrganismoNotificacionProductor(Organismo organismo) {
		return (Organismo) this.organismoDao.findOrganismoNotificacionProductor(organismo);
	}

	/**
	 * Finds a single row in the Organismo table de CrearSolicitudes.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findOrganismoComunicacionExterna(Organismo organismo) {
		return (Organismo) this.organismoDao.findOrganismoComunicacionExterna(organismo);
	}

	/**
	 * Finds a single row in the Organismo table de UsuariosKbide13.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findOrganismoUsuariosKbide13(Organismo organismo) {
		return (Organismo) this.organismoDao.findOrganismoUsuariosKbide13(organismo);
	}

	/**
	 * Finds a single row in the Organismo table de TrasladoConsumo.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findOrganismoTrasladoConsumo(Organismo organismo) {
		return (Organismo) this.organismoDao.findOrganismoTrasladoConsumo(organismo);
	}

	/**
	 * Finds a single row in the Organismo table de InhibicionConsumo.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findOrganismoInhibicionConsumo(Organismo organismo) {
		return (Organismo) this.organismoDao.findOrganismoInhibicionConsumo(organismo);
	}

	/**
	 * Finds a single row in the Organismo table de OmicAsociacion.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findOrganismoOmicAsociacion(Organismo organismo) {
		return (Organismo) this.organismoDao.findOrganismoOmicAsociacion(organismo);
	}

	/**
	 * Finds a single row in the Organismo table de OOEE.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findOrganismoOOEE(Organismo organismo) {
		return (Organismo) this.organismoDao.findOrganismoOOEE(organismo);
	}

	/**
	 * Finds a single row in the Organismo table de AACC.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findOrganismoAACC(Organismo organismo) {
		return (Organismo) this.organismoDao.findOrganismoAACC(organismo);
	}

	/**
	 * Finds a single row in the Organismo table de AACC.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findOrganismoOtros(Organismo organismo) {
		return (Organismo) this.organismoDao.findOrganismoOtros(organismo);
	}

	/**
	 * Finds a single row in the Organismo table de CensoUsuarios.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findCensoUsuarios(Organismo organismo) {
		return (Organismo) this.organismoDao.findCensoUsuarios(organismo);
	}

	/**
	 * Finds a single row in the Organismo table de UsuariosDenunciasEmpresas.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findUsuariosDenunciasEmpresas(Organismo organismo) {
		return (Organismo) this.organismoDao.findUsuariosDenunciasEmpresas(organismo);
	}

	/**
	 * Finds a single row in Organismo
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findOrganismoById(Organismo organismo) {
		return (Organismo) this.organismoDao.findOrganismoById(organismo);
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismoArbitraje(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		return this.organismoDao.findAllLikeOrganismoArbitraje(organismo, pagination, startsWith);
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismoArbitrajeJjaa(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		return this.organismoDao.findAllLikeOrganismoArbitrajeJjaa(organismo, pagination, startsWith);
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismoArbitrajeCount(Organismo organismo, Boolean startsWith) {

		return this.organismoDao.findAllLikeOrganismoArbitrajeCount(organismo, startsWith);
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismoArbitrajeCountJjaa(Organismo organismo, Boolean startsWith) {

		return this.organismoDao.findAllLikeOrganismoArbitrajeCountJjaa(organismo, startsWith);
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismosUsuariosControlMercado(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		List<Organismo> listOrganismo = (List<Organismo>) this.organismoDao
				.findAllLikeOrganismosUsuariosKbide13(organismo, pagination, startsWith);
		/*
		 * Organismo organismoSSCC = new Organismo(); organismoSSCC
		 * .setCodOrg(Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO);
		 * organismoSSCC = this.organismoDao.find(organismoSSCC);
		 * listOrganismo.add(organismoSSCC);
		 */
		return listOrganismo;
	}

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismoAaccEuskadi(Organismo organismo, Pagination pagination,
			Boolean startsWith) {
		return this.organismoDao.findAllLikeOrganismoAaccEuskadi(organismo, pagination, startsWith);
	}

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismoAaccEuskadiCount(Organismo organismo, Boolean startsWith) {

		return this.organismoDao.findAllLikeOrganismoAaccEuskadiCount(organismo, startsWith);
	}

	/**
	 * Finds a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Contacto
	 */
	public Contacto findContacto(Organismo organismo) {

		return this.organismoDao.findContacto(organismo);
	}

}
