package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Grupo;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Contacto;

/**
 * * OrganismoService  
 * 
 *  
 */

public interface OrganismoService {

	/**
	 * Inserts a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	Organismo add(Organismo organismo);

	/**
	 * Updates a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	Organismo update(Organismo organismo);

	/**
	 * Finds a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	Organismo find(Organismo organismo);

	/**
	 * Finds a single row in the Organismo table de KontsumoNet.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	Organismo findOrganismoKnet(Organismo organismo);

	/**
	 * Finds a single row in the Organismo table de KontsumoBide.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	Organismo findOrganismoKbide(Organismo organismo);

	/**
	 * Finds a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	Organismo findOrganismo(Organismo organismo);

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Organismo> findAll(Organismo organismo, Pagination pagination);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Long
	 */
	Long findAllCount(Organismo organismo);

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Organismo> findAllLike(Organismo organismo, Pagination pagination, Boolean startsWith);

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Organismo> findAllLikeOrganismoKnet(Organismo organismo, Pagination pagination, Boolean startsWith);

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Organismo> findAllLikeOrganismoKbide(Organismo organismo, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeOrganismoKnetCount(Organismo organismo, Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeOrganismoKbideCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismoKbideKnet(Organismo organismo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismoKbideKnetCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param codOrgConectado
	 *            String
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Organismo> findAllLikeOrganismo(Organismo organismo, String codOrgConectado, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param codOrgConectado
	 *            String
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeOrganismoCount(Organismo organismo, String codOrgConectado, Boolean startsWith);

	/**
	 * Deletes a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return
	 */
	void remove(Organismo organismo);

	/**
	 * Deletes multiple rows in the Organismo table.
	 * 
	 * @param organismoList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Organismo> organismoList);

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return List
	 */
	List<Grupo> obtenerGruposOrganismo(Organismo organismo);

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Organismo> findAllLikeOrganismoKTodos(Organismo organismo, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeOrganismoKTodosCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismoCambioInstructor(Organismo organismo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismoCambioInstructorCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismosCrearSolicitudes(Organismo organismo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismosCrearSolicitudesCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismosNotificacionProductor(Organismo organismo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismosNotificacionProductorCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismosComunicacionExterna(Organismo organismo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismosComunicacionExternaCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismosUsuariosKbide13(Organismo organismo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismosUsuariosKbide13Count(Organismo organismo, Boolean startsWith);

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismosTrasladoConsumo(Organismo organismo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismosTrasladoConsumoCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismosInhibicionConsumo(Organismo organismo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismosInhibicionConsumoCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismosOmicAsociacion(Organismo organismo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismosOmicAsociacionCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds a single row in the Organismo table de CrearSolicitudes.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findOrganismoCrearSolicitudes(Organismo organismo);

	/**
	 * Finds a single row in the Organismo table de CrearSolicitudes.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findOrganismoNotificacionProductor(Organismo organismo);

	/**
	 * Finds a single row in the Organismo table de CrearSolicitudes.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findOrganismoComunicacionExterna(Organismo organismo);

	/**
	 * Finds a single row in the Organismo table de UsuariosKbide13.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findOrganismoUsuariosKbide13(Organismo organismo);

	/**
	 * Finds a single row in the Organismo table de TrasladoConsumo.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findOrganismoTrasladoConsumo(Organismo organismo);

	/**
	 * Finds a single row in the Organismo table de InhibicionConsumo.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findOrganismoInhibicionConsumo(Organismo organismo);

	/**
	 * Finds a single row in the Organismo table de OmicAsociacion.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findOrganismoOmicAsociacion(Organismo organismo);

	/**
	 * @param organismo
	 * @return
	 */
	public Organismo findOrganismoById(Organismo organismo);

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Organismo> findAllLikeOrganismoArbitraje(Organismo organismo, Pagination pagination, Boolean startsWith);

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Organismo> findAllLikeOrganismoArbitrajeJjaa(Organismo organismo, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeOrganismoArbitrajeCount(Organismo organismo, Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeOrganismoArbitrajeCountJjaa(Organismo organismo, Boolean startsWith);

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismosUsuariosControlMercado(Organismo organismo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismosOOEE(Organismo organismo, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismosOOEECount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismosAACC(Organismo organismo, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismosAACCCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeOrganismosOtros(Organismo organismo, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeOrganismosOtrosCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeUsuariosDenunciasEmpresas(Organismo organismo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeUsuariosDenunciasEmpresasCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Organismo> findAllLikeCensoUsuarios(Organismo organismo, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCensoUsuariosCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds a single row in the Organismo table de OOEE.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findOrganismoOOEE(Organismo organismo);

	/**
	 * Finds a single row in the Organismo table de AACC.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findOrganismoAACC(Organismo organismo);

	/**
	 * Finds a single row in the Organismo table de AACC.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findOrganismoOtros(Organismo organismo);

	/**
	 * Finds a single row in the Organismo table de UsuariosDenunciasEmpresas.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findUsuariosDenunciasEmpresas(Organismo organismo);

	/**
	 * Finds a single row in the Organismo table de CensoUsuarios.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	public Organismo findCensoUsuarios(Organismo organismo);

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Organismo> findAllLikeOrganismoAaccEuskadi(Organismo organismo, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeOrganismoAaccEuskadiCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Contacto
	 */
	Contacto findContacto(Organismo organismo);
}
