package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.DocCensoDao;
import com.ejie.y41b.dao.DocCensoTempDao;
import com.ejie.y41b.dao.OearDao;
import com.ejie.y41b.dao.OeseDao;
import com.ejie.y41b.dao.Oeta1Dao;
import com.ejie.y41b.dao.OoeeDao;
import com.ejie.y41b.dao.OrganismoDao;
import com.ejie.y41b.dao.SolarbDao;
import com.ejie.y41b.model.DocCenso;
import com.ejie.y41b.model.DocCensoTemp;
import com.ejie.y41b.model.Oear;
import com.ejie.y41b.model.Oese;
import com.ejie.y41b.model.Oeta1;
import com.ejie.y41b.model.Ooee;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * OoeeServiceImpl  
 * 
 *  
 */

@Service(value = "ooeeService")
public class OoeeServiceImpl implements OoeeService {

	@Autowired()
	private OoeeDao ooeeDao;
	@Autowired()
	private OrganismoDao organismoDao;
	@Autowired()
	private OeseDao oeseDao;
	@Autowired()
	private OearDao oearDao;
	@Autowired()
	private Oeta1Dao oeta1Dao;
	@Autowired()
	private DocCensoTempDao docCensoTempDao;
	@Autowired()
	private DocCensoDao docCensoDao;
	@Autowired()
	private SolarbDao solArbDao;

	/**
	 * Inserts a single row in the Ooee table.
	 * 
	 * @param ooee
	 *            Ooee
	 * @return Ooee
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Ooee add(Ooee ooee) {
		this.ooeeDao.add(ooee);
		this.tratarMn(ooee);
		return ooee;
	}

	/**
	 * Updates a single row in the Ooee table.
	 * 
	 * @param ooee
	 *            Ooee
	 * @return Ooee
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Ooee update(Ooee ooee) {
		this.ooeeDao.update(ooee);
		this.tratarMn(ooee);
		return ooee;
	}

	/**
	 * 
	 * @param ooee
	 *            Ooee
	 */
	private void tratarMn(Ooee ooee) {
		// Territorios de actuacin: borramos por ooee y aadimos la lista
		Oeta1 oeta1 = new Oeta1();
		oeta1.setOoee(ooee);
		this.oeta1Dao.remove(oeta1);
		if (!Y41bUtils.esNullOCadenaVacia(ooee.getOeThActAraba())) {
			oeta1.setM5cota1(ooee.getOeThActAraba());
			oeta1.setOoee(ooee);
			// Aadimos los territorios de la ooee
			this.oeta1Dao.add(oeta1);
		}
		if (!Y41bUtils.esNullOCadenaVacia(ooee.getOeThActBizkaia())) {
			oeta1.setM5cota1(ooee.getOeThActBizkaia());
			oeta1.setOoee(ooee);
			// Aadimos los territorios de la ooee
			this.oeta1Dao.add(oeta1);
		}
		if (!Y41bUtils.esNullOCadenaVacia(ooee.getOeThActGipuzkoa())) {
			oeta1.setM5cota1(ooee.getOeThActGipuzkoa());
			oeta1.setOoee(ooee);
			// Aadimos los territorios de la ooee
			this.oeta1Dao.add(oeta1);
		}
		// Sectores
		Oese oese = new Oese();
		oese.setOoee(ooee);
		// Borramos de oese por ooee
		this.oeseDao.removeOese(oese);
		// Lista de la temporal
		List<Oese> oeses = this.oeseDao.findAll(oese, null);
		for (int i = 0; i < oeses.size(); i++) {
			oese = oeses.get(i);
			// Aadimos los sectores a oese
			this.oeseDao.addOese(oese);
			// Eliminamos de la temporal
			this.oeseDao.remove(oese);
		}

		// Arbitros
		Oear oear = new Oear();
		oear.setOoee(ooee);
		// Borramos de oear por ooee
		this.oearDao.removeOearOoee(oear);
		// Lista de la temporal
		List<Oear> oears = this.oearDao.findAll(oear, null);
		for (int i = 0; i < oears.size(); i++) {
			oear = oears.get(i);
			// Aadimos los arbitros a oese
			this.oearDao.addOear(oear);
			// Eliminamos de la temporal
			this.oearDao.remove(oear);
		}
		// Documentos
		DocCenso docCenso = new DocCenso();
		docCenso.setEacoentidad(ooee.getOecodigo());
		docCenso.setEatipoentidad(Y41bConstantes.CENSO_ARB_OOEE);
		// Borramos de doc_censo por ooee
		this.docCensoDao.remove(docCenso);
		// Insertamos de la temporal a doc_censo
		DocCensoTemp docCensoTemp = new DocCensoTemp();
		docCensoTemp.setEacoentidad(ooee.getOecodigo());
		docCensoTemp.setEatipoentidad(Y41bConstantes.CENSO_ARB_OOEE);
		this.docCensoTempDao.addDocCensoFromTemporal(docCensoTemp);
		// Borramos de la temporal por ooee
		this.docCensoTempDao.removeByEntidad(docCensoTemp);
	}

	/**
	 * Finds a single row in the Ooee table.
	 * 
	 * @param ooee
	 *            Ooee
	 * @return Ooee
	 */
	public Ooee find(Ooee ooee) {
		Ooee ooeeDetalle = new Ooee();
		try {
			ooeeDetalle = this.ooeeDao.find(ooee);
		} catch (Exception e) {
			// Si no encuentra el detalle se "ahoga" la excepcion
		}
		Organismo organismo = new Organismo();
		organismo.setCodOrg(ooee.getOecodigo());
		try {
			organismo = this.organismoDao.find(organismo);
		} catch (Exception e) {
			// Si no encuentra el organismo, o no puede volcar los datos, se
			// "ahoga" la excepcion
		}
		if (ooeeDetalle != null) {
			ooeeDetalle.setOrganismo(organismo);
		}
		// Volcar en tablas temporales: sectores, arbitros y documentos
		this.oeseDao.volcarOoeeSectores(ooee);

		this.oearDao.volcarOoeeArbitros(ooee);

		this.docCensoTempDao.addTemporalFromCensoDoc(ooee.getOecodigo(),
				Y41bConstantes.CENSO_ARB_OOEE);

		return ooeeDetalle;

	}

	/**
	 * Finds a List of rows in the Ooee table.
	 * 
	 * @param ooee
	 *            Ooee
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Ooee> findAll(Ooee ooee, Pagination pagination) {
		return (List<Ooee>) this.ooeeDao.findAll(ooee, pagination);
	}

	/**
	 * Counts rows in the Ooee table.
	 * 
	 * @param ooee
	 *            Ooee
	 * @return Long
	 */
	public Long findAllCount(Ooee ooee) {
		return this.ooeeDao.findAllCount(ooee);
	}

	/**
	 * Finds rows in the Ooee table using like.
	 * 
	 * @param ooee
	 *            Ooee
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Ooee> findAllLike(Ooee ooee, Pagination pagination,
			Boolean startsWith) {
		return (List<Ooee>) this.ooeeDao.findAllLike(ooee, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Ooee table using like.
	 * 
	 * @param ooee
	 *            Ooee
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Ooee ooee, Boolean startsWith) {
		return this.ooeeDao.findAllLikeCount(ooee, startsWith);
	}

	/**
	 * Deletes a single row in the Ooee table.
	 * 
	 * @param ooee
	 *            Ooee
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Ooee ooee) {
		Solarb solarb = new Solarb();
		solarb.setOoee(ooee);
		long numExpedientesAbiertos = solArbDao.findAllCount(solarb);
		if (numExpedientesAbiertos > 0) {
			throw new Y41bUDAException(
					"error.ooee.ExpedientesAbiertosException", true,
					new Y41bUDAException());
		}

		// Borramos de oeta1 por ooee
		Oeta1 oeta1 = new Oeta1();
		oeta1.setOoee(ooee);
		this.oeta1Dao.remove(oeta1);

		// Borramos de oese por ooee
		Oese oese = new Oese();
		oese.setOoee(ooee);
		this.oeseDao.removeOese(oese);

		// Borramos de oear por ooee
		Oear oear = new Oear();
		oear.setOoee(ooee);
		this.oearDao.removeOearOoee(oear);

		// Borramos de doc_censo por ooee
		DocCenso docCenso = new DocCenso();
		docCenso.setEacoentidad(ooee.getOecodigo());
		docCenso.setEatipoentidad(Y41bConstantes.CENSO_ARB_OOEE);
		this.docCensoDao.remove(docCenso);

		this.borrarTemporales(ooee);

		this.ooeeDao.remove(ooee);
	}

	/**
	 * Deletes multiple rows in the Ooee table.
	 * 
	 * @param ooeeList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Ooee> ooeeList) {
		for (Ooee ooeeAux : ooeeList) {
			this.ooeeDao.remove(ooeeAux);
		}
	}

	/**
	 * Finds a List of rows in the Ooee table.
	 * 
	 * @param ooee
	 *            Ooee
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Ooee> findAllBusqueda(Ooee ooee, Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() != null
					&& pagination.getSort().equals("organismo.nombreEs")) {
				pagination.setSort("OrganismoNOMBREES");
			}
			if (pagination.getSort() != null
					&& pagination.getSort().equals("organismo.nombreEu")) {
				pagination.setSort("OrganismoNOMBREEU");
			}
			if (pagination.getSort() != null
					&& pagination.getSort().equals("organismo.nombreMunicipio")) {
				pagination.setSort("OrganismoNOMBREMUNICIPIO");
			}
		}
		return (List<Ooee>) this.ooeeDao.findAllBusqueda(ooee, pagination);
	}

	/**
	 * Counts rows in the Ooee table.
	 * 
	 * @param ooee
	 *            Ooee
	 * @return Long
	 */
	public Long findAllBusquedaCount(Ooee ooee) {
		return this.ooeeDao.findAllBusquedaCount(ooee);
	}

	/**
	 * Borra los registros temporales
	 * 
	 * @param ooee
	 *            Ooee
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void borrarTemporales(Ooee ooee) {
		// Sectores
		Oese oese = new Oese();
		oese.setOoee(ooee);
		// Lista de la temporal
		List<Oese> oeses = this.oeseDao.findAll(oese, null);
		for (int i = 0; i < oeses.size(); i++) {
			oese = oeses.get(i);
			// Eliminamos de la temporal
			this.oeseDao.remove(oese);
		}

		// Arbitros
		Oear oear = new Oear();
		oear.setOoee(ooee);
		// Lista de la temporal
		List<Oear> oears = this.oearDao.findAll(oear, null);
		for (int i = 0; i < oears.size(); i++) {
			oear = oears.get(i);
			// Eliminamos de la temporal
			this.oearDao.remove(oear);
		}
		// Documentos
		DocCensoTemp docCensoTemp = new DocCensoTemp();
		docCensoTemp.setEacoentidad(ooee.getOecodigo());
		docCensoTemp.setEatipoentidad(Y41bConstantes.CENSO_ARB_OOEE);
		// Borramos de la temporal por ooee
		this.docCensoTempDao.removeByEntidad(docCensoTemp);

	}
}
