package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.Oeta1Dao;
import com.ejie.y41b.model.Oeta1;

/**
 * Oeta1ServiceImpl  
 * 
 *  
 */

@Service(value = "oeta1Service")
public class Oeta1ServiceImpl implements Oeta1Service {

	@Autowired()
	private Oeta1Dao oeta1Dao;

	/**
	 * Inserts a single row in the Oeta1 table.
	 * 
	 * @param oeta1
	 *            Oeta1
	 * @return Oeta1
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Oeta1 add(Oeta1 oeta1) {
		return this.oeta1Dao.add(oeta1);
	}

	/**
	 * Updates a single row in the Oeta1 table.
	 * 
	 * @param oeta1
	 *            Oeta1
	 * @return Oeta1
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Oeta1 update(Oeta1 oeta1) {
		return this.oeta1Dao.update(oeta1);
	}

	/**
	 * Finds a single row in the Oeta1 table.
	 * 
	 * @param oeta1
	 *            Oeta1
	 * @return Oeta1
	 */
	public Oeta1 find(Oeta1 oeta1) {
		return (Oeta1) this.oeta1Dao.find(oeta1);
	}

	/**
	 * Finds a List of rows in the Oeta1 table.
	 * 
	 * @param oeta1
	 *            Oeta1
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Oeta1> findAll(Oeta1 oeta1, Pagination pagination) {
		return (List<Oeta1>) this.oeta1Dao.findAll(oeta1, pagination);
	}

	/**
	 * Counts rows in the Oeta1 table.
	 * 
	 * @param oeta1
	 *            Oeta1
	 * @return Long
	 */
	public Long findAllCount(Oeta1 oeta1) {
		return this.oeta1Dao.findAllCount(oeta1);
	}

	/**
	 * Finds rows in the Oeta1 table using like.
	 * 
	 * @param oeta1
	 *            Oeta1
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Oeta1> findAllLike(Oeta1 oeta1, Pagination pagination,
			Boolean startsWith) {
		return (List<Oeta1>) this.oeta1Dao.findAllLike(oeta1, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Oeta1 table using like.
	 * 
	 * @param oeta1
	 *            Oeta1
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Oeta1 oeta1, Boolean startsWith) {
		return this.oeta1Dao.findAllLikeCount(oeta1, startsWith);
	}

	/**
	 * Deletes a single row in the Oeta1 table.
	 * 
	 * @param oeta1
	 *            Oeta1
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Oeta1 oeta1) {
		this.oeta1Dao.remove(oeta1);
	}

	/**
	 * Deletes multiple rows in the Oeta1 table.
	 * 
	 * @param oeta1List
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Oeta1> oeta1List) {
		for (Oeta1 oeta1Aux : oeta1List) {
			this.oeta1Dao.remove(oeta1Aux);
		}
	}

}
