package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.OeseDao;
import com.ejie.y41b.model.Oese;

/**
 * OeseServiceImpl  
 * 
 *  
 */

@Service(value = "oeseService")
public class OeseServiceImpl implements OeseService {

	@Autowired()
	private OeseDao oeseDao;

	/**
	 * Inserts a single row in the Oese table.
	 * 
	 * @param oese
	 *            Oese
	 * @return Oese
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Oese add(Oese oese) {
		return this.oeseDao.add(oese);
	}

	/**
	 * Updates a single row in the Oese table.
	 * 
	 * @param oese
	 *            Oese
	 * @return Oese
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Oese update(Oese oese) {
		return this.oeseDao.update(oese);
	}

	/**
	 * Finds a single row in the Oese table.
	 * 
	 * @param oese
	 *            Oese
	 * @return Oese
	 */
	public Oese find(Oese oese) {
		return (Oese) this.oeseDao.find(oese);
	}

	/**
	 * Finds a List of rows in the Oese table.
	 * 
	 * @param oese
	 *            Oese
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Oese> findAll(Oese oese, Pagination pagination) {
		if (pagination.getSort() != null
				&& pagination.getSort().equals("sector.senombre")) {
			pagination.setSort("SectorSENOMBRE");
		}
		if (pagination.getSort() != null
				&& pagination.getSort().equals("sector.senombre")) {
			pagination.setSort("SectorSENOMBREE");
		}
		return (List<Oese>) this.oeseDao.findAll(oese, pagination);
	}

	/**
	 * Counts rows in the Oese table.
	 * 
	 * @param oese
	 *            Oese
	 * @return Long
	 */
	public Long findAllCount(Oese oese) {
		return this.oeseDao.findAllCount(oese);
	}

	/**
	 * Finds rows in the Oese table using like.
	 * 
	 * @param oese
	 *            Oese
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Oese> findAllLike(Oese oese, Pagination pagination,
			Boolean startsWith) {
		return (List<Oese>) this.oeseDao.findAllLike(oese, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Oese table using like.
	 * 
	 * @param oese
	 *            Oese
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Oese oese, Boolean startsWith) {
		return this.oeseDao.findAllLikeCount(oese, startsWith);
	}

	/**
	 * Deletes a single row in the Oese table.
	 * 
	 * @param oese
	 *            Oese
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Oese oese) {
		this.oeseDao.remove(oese);
	}

	/**
	 * Deletes multiple rows in the Oese table.
	 * 
	 * @param oeseList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Oese> oeseList) {
		for (Oese oeseAux : oeseList) {
			this.oeseDao.remove(oeseAux);
		}
	}

}
