package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Oese;

/**
 * OeseService  
 * 
 *  
 */

public interface OeseService {

	/**
	 * Inserts a single row in the Oese table.
	 * 
	 * @param oese
	 *            Oese
	 * @return Oese
	 */
	Oese add(Oese oese);

	/**
	 * Updates a single row in the Oese table.
	 * 
	 * @param oese
	 *            Oese
	 * @return Oese
	 */
	Oese update(Oese oese);

	/**
	 * Finds a single row in the Oese table.
	 * 
	 * @param oese
	 *            Oese
	 * @return Oese
	 */
	Oese find(Oese oese);

	/**
	 * Finds a List of rows in the Oese table.
	 * 
	 * @param oese
	 *            Oese
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Oese> findAll(Oese oese, Pagination pagination);

	/**
	 * Counts rows in the Oese table.
	 * 
	 * @param oese
	 *            Oese
	 * @return Long
	 */
	Long findAllCount(Oese oese);

	/**
	 * Finds rows in the Oese table using like.
	 * 
	 * @param oese
	 *            Oese
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Oese> findAllLike(Oese oese, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Oese table using like.
	 * 
	 * @param oese
	 *            Oese
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Oese oese, Boolean startsWith);

	/**
	 * Deletes a single row in the Oese table.
	 * 
	 * @param oese
	 *            Oese
	 * @return
	 */
	void remove(Oese oese);

	/**
	 * Deletes multiple rows in the Oese table.
	 * 
	 * @param oeseList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Oese> oeseList);

}
