package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.OearDao;
import com.ejie.y41b.model.Oear;

/**
 * OearServiceImpl  
 * 
 *  
 */

@Service(value = "oearService")
public class OearServiceImpl implements OearService {

	@Autowired()
	private OearDao oearDao;

	/**
	 * Inserts a single row in the Oear table.
	 * 
	 * @param oear
	 *            Oear
	 * @return Oear
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Oear add(Oear oear) {
		return this.oearDao.add(oear);
	}

	/**
	 * Updates a single row in the Oear table.
	 * 
	 * @param oear
	 *            Oear
	 * @return Oear
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Oear update(Oear oear) {
		return this.oearDao.update(oear);
	}

	/**
	 * Finds a single row in the Oear table.
	 * 
	 * @param oear
	 *            Oear
	 * @return Oear
	 */
	public Oear find(Oear oear) {
		return (Oear) this.oearDao.find(oear);
	}

	/**
	 * Finds a List of rows in the Oear table.
	 * 
	 * @param oear
	 *            Oear
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Oear> findAll(Oear oear, Pagination pagination) {
		if (pagination != null) {
			if (pagination.getSort() != null
					&& pagination.getSort().equals("arbitro.arnif")) {
				pagination.setSort("ArbitroARNIF");
			}
			if (pagination.getSort() != null
					&& pagination.getSort().equals("arbitro.arnombre")) {
				pagination.setSort("ArbitroARNOMBRE");
			}
			if (pagination.getSort() != null
					&& pagination.getSort().equals("ooee.oecodigo")) {
				pagination.setSort("M1COOE");
			}
			if (pagination.getSort() != null
					&& pagination.getSort().equals("ooee.organismo.nombreEs")) {
				pagination.setSort("OrganismoNOMBREES");
			}
			if (pagination.getSort() != null
					&& pagination.getSort().equals("ooee.organismo.nombreEu")) {
				pagination.setSort("OrganismoNOMBREEU");
			}
		}
		return (List<Oear>) this.oearDao.findAll(oear, pagination);
	}

	/**
	 * Counts rows in the Oear table.
	 * 
	 * @param oear
	 *            Oear
	 * @return Long
	 */
	public Long findAllCount(Oear oear) {
		return this.oearDao.findAllCount(oear);
	}

	/**
	 * Finds rows in the Oear table using like.
	 * 
	 * @param oear
	 *            Oear
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Oear> findAllLike(Oear oear, Pagination pagination,
			Boolean startsWith) {
		return (List<Oear>) this.oearDao.findAllLike(oear, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Oear table using like.
	 * 
	 * @param oear
	 *            Oear
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Oear oear, Boolean startsWith) {
		return this.oearDao.findAllLikeCount(oear, startsWith);
	}

	/**
	 * Deletes a single row in the Oear table.
	 * 
	 * @param oear
	 *            Oear
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Oear oear) {
		this.oearDao.remove(oear);
	}

	/**
	 * Deletes multiple rows in the Oear table.
	 * 
	 * @param oearList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Oear> oearList) {
		for (Oear oearAux : oearList) {
			this.oearDao.remove(oearAux);
		}
	}

}
