package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Oear;

/**
 * OearService  
 * 
 *  
 */

public interface OearService {

	/**
	 * Inserts a single row in the Oear table.
	 * 
	 * @param oear
	 *            Oear
	 * @return Oear
	 */
	Oear add(Oear oear);

	/**
	 * Updates a single row in the Oear table.
	 * 
	 * @param oear
	 *            Oear
	 * @return Oear
	 */
	Oear update(Oear oear);

	/**
	 * Finds a single row in the Oear table.
	 * 
	 * @param oear
	 *            Oear
	 * @return Oear
	 */
	Oear find(Oear oear);

	/**
	 * Finds a List of rows in the Oear table.
	 * 
	 * @param oear
	 *            Oear
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Oear> findAll(Oear oear, Pagination pagination);

	/**
	 * Counts rows in the Oear table.
	 * 
	 * @param oear
	 *            Oear
	 * @return Long
	 */
	Long findAllCount(Oear oear);

	/**
	 * Finds rows in the Oear table using like.
	 * 
	 * @param oear
	 *            Oear
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Oear> findAllLike(Oear oear, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Oear table using like.
	 * 
	 * @param oear
	 *            Oear
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Oear oear, Boolean startsWith);

	/**
	 * Deletes a single row in the Oear table.
	 * 
	 * @param oear
	 *            Oear
	 * @return
	 */
	void remove(Oear oear);

	/**
	 * Deletes multiple rows in the Oear table.
	 * 
	 * @param oearList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Oear> oearList);

}
