package com.ejie.y41b.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.dao.NumSolicitudDao;
import com.ejie.y41b.model.Denuncia;

/**
 * * NumSolicitudServiceImpl  
 * 
 *  
 */

@Service(value = "numSolicitudService")
public class NumSolicitudServiceImpl implements NumSolicitudService {

	private static final Logger logger = LoggerFactory
			.getLogger(NumSolicitudServiceImpl.class);
	@Autowired
	private NumSolicitudDao numSolicitudDao;

	/**
	 * Calcula el siguiente numero de solicitud.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Denuncia findNumSolicitud(Denuncia denuncia) {

		Denuncia denunciaResultado = this.numSolicitudDao
				.findNumSolicitud(denuncia);

		denunciaResultado.setDecoor(denunciaResultado.getDecoor());
		denunciaResultado.setDenran(denunciaResultado.getDenran());

		this.numSolicitudDao.add(denunciaResultado);

		return denunciaResultado;
	}

	/**
	 * Getter method for NumSolicitudDao
	 * 
	 * @return NumSolicitudDao
	 */
	public NumSolicitudDao getNumSolicitudDao() {
		return this.numSolicitudDao;
	}

	/**
	 * Setter method for NumSolicitudDao.
	 * 
	 * @param numSolicitudDao
	 *            NumSolicitudDao
	 * @return
	 */
	public void setNumSolicitudDao(NumSolicitudDao numSolicitudDao) {
		logger.info("Setting Dependency " + numSolicitudDao);
		this.numSolicitudDao = numSolicitudDao;
	}
}
