package com.ejie.y41b.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.dao.NumConsultaDao;
import com.ejie.y41b.model.ConsultaDetalle;

/**
 * * NumConsultaServiceImpl  
 * 
 *  
 */

@Service(value = "numConsultaService")
public class NumConsultaServiceImpl implements NumConsultaService {

	private static final Logger logger = LoggerFactory
			.getLogger(NumConsultaServiceImpl.class);
	@Autowired
	private NumConsultaDao numConsultaDao;

	/**
	 * Calcula el siguiente numero de consulta.
	 * 
	 * @param consultaDetalle
	 *            ConsultaDetalle
	 * @return ConsultaDetalle
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ConsultaDetalle findNumConsulta(ConsultaDetalle consultaDetalle) {

		ConsultaDetalle consultaResultado = this.numConsultaDao
				.findNumConsulta(consultaDetalle);

		consultaResultado.setCodOrg(consultaDetalle.getCodOrg());
		consultaResultado.setConranrg(consultaDetalle.getConranrg());

		this.numConsultaDao.add(consultaResultado);

		return consultaResultado;
	}

	/**
	 * Getter method for NumConsultaDao
	 * 
	 * @return NumConsultaDao
	 */
	public NumConsultaDao getNumConsultaDao() {
		return this.numConsultaDao;
	}

	/**
	 * Setter method for NumConsultaDao.
	 * 
	 * @param numConsultaDao
	 *            NumConsultaDao
	 * @return
	 */
	public void setNumConsultaDao(NumConsultaDao numConsultaDao) {
		logger.info("Setting Dependency " + numConsultaDao);
		this.numConsultaDao = numConsultaDao;
	}
}
