package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.NaturalezaPeligroDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.NaturalezaPeligro;

/**
 * NaturalezaPeligroServiceImpl  
 *  
 */

@Service(value = "naturalezaPeligroService")
public class NaturalezaPeligroServiceImpl implements NaturalezaPeligroService {

	@Autowired
	private NaturalezaPeligroDao naturalezaPeligroDao;

	/**
	 * Inserts a single row in the NaturalezaPeligro table.
	 *
	 * @param naturalezaPeligro NaturalezaPeligro
	 * @return NaturalezaPeligro
	 */
	@Transactional(rollbackFor = Throwable.class)
	public NaturalezaPeligro add(NaturalezaPeligro naturalezaPeligro) {
		return this.naturalezaPeligroDao.add(naturalezaPeligro);
	}

	/**
	 * Updates a single row in the NaturalezaPeligro table.
	 *
	 * @param naturalezaPeligro NaturalezaPeligro
	 * @return NaturalezaPeligro
	 */
	@Transactional(rollbackFor = Throwable.class)
	public NaturalezaPeligro update(NaturalezaPeligro naturalezaPeligro) {
		return this.naturalezaPeligroDao.update(naturalezaPeligro);
	 }

	/**
	 * Finds a single row in the NaturalezaPeligro table.
	 *
	 * @param naturalezaPeligro NaturalezaPeligro
	 * @return NaturalezaPeligro
	 */
	public NaturalezaPeligro find(NaturalezaPeligro naturalezaPeligro) {
		return (NaturalezaPeligro) this.naturalezaPeligroDao.find(naturalezaPeligro);
	}

	/**
	 * Finds a List of rows in the NaturalezaPeligro table.
	 *
	 * @param naturalezaPeligro NaturalezaPeligro
	 * @param pagination Pagination
	 * @return List
	 */
	public List<NaturalezaPeligro> findAll(NaturalezaPeligro naturalezaPeligro, Pagination pagination) {
		return (List<NaturalezaPeligro>) this.naturalezaPeligroDao.findAll(naturalezaPeligro, pagination);
	}
    
	/**
	 * Counts rows in the NaturalezaPeligro table.
	 *
	 * @param naturalezaPeligro NaturalezaPeligro
	 * @return Long
	 */
	public Long findAllCount(NaturalezaPeligro naturalezaPeligro) {        
		return  this.naturalezaPeligroDao.findAllCount(naturalezaPeligro);
	}

	/**
	 * Finds rows in the NaturalezaPeligro table using like.
	 *
	 * @param naturalezaPeligro NaturalezaPeligro
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<NaturalezaPeligro> findAllLike(NaturalezaPeligro naturalezaPeligro, Pagination pagination, Boolean startsWith) {
		return (List<NaturalezaPeligro>) this.naturalezaPeligroDao.findAllLike(naturalezaPeligro, pagination, startsWith);
	}

	/**
	 * Counts rows in the NaturalezaPeligro table using like.
	 *
	 * @param naturalezaPeligro NaturalezaPeligro
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(NaturalezaPeligro naturalezaPeligro, Boolean startsWith) {
		return this.naturalezaPeligroDao.findAllLikeCount(naturalezaPeligro, startsWith);
	}
	    
	/**
	 * Deletes a single row in the NaturalezaPeligro table.
	 *
	 * @param naturalezaPeligro NaturalezaPeligro
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(NaturalezaPeligro naturalezaPeligro) {
		this.naturalezaPeligroDao.remove(naturalezaPeligro);
	}
	
	/**
	 * Deletes multiple rows in the NaturalezaPeligro table.
	 *
	 * @param naturalezaPeligroList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<NaturalezaPeligro> naturalezaPeligroList) {
		for (NaturalezaPeligro  naturalezaPeligroAux:naturalezaPeligroList) {
			this.naturalezaPeligroDao.remove(naturalezaPeligroAux);
		}
	}
	
}

