package com.ejie.y41b.service;


import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.NaturalezaPeligro;

/**
 * NaturalezaPeligroService  
 *  
 */

public interface NaturalezaPeligroService {

	/**
	 * Inserts a single row in the NaturalezaPeligro table.
	 *
	 * @param naturalezaPeligro NaturalezaPeligro
	 * @return NaturalezaPeligro
	 */
    NaturalezaPeligro add(NaturalezaPeligro naturalezaPeligro);

	/**
	 * Updates a single row in the NaturalezaPeligro table.
	 *
	 * @param naturalezaPeligro NaturalezaPeligro
	 * @return NaturalezaPeligro
	 */
	NaturalezaPeligro update(NaturalezaPeligro naturalezaPeligro);

	/**
	 * Finds a single row in the NaturalezaPeligro table.
	 *
	 * @param naturalezaPeligro NaturalezaPeligro
	 * @return NaturalezaPeligro
	 */
	NaturalezaPeligro find(NaturalezaPeligro naturalezaPeligro);

	/**
	 * Finds a List of rows in the NaturalezaPeligro table.
	 *
	 * @param naturalezaPeligro NaturalezaPeligro
	 * @param pagination Pagination
	 * @return List
	 */
	List<NaturalezaPeligro> findAll(NaturalezaPeligro naturalezaPeligro, Pagination pagination);

	/**
	 * Counts rows in the NaturalezaPeligro table.
	 *
	 * @param naturalezaPeligro NaturalezaPeligro
	 * @return Long
	 */
	Long findAllCount(NaturalezaPeligro naturalezaPeligro);
	
	/**
	 * Finds rows in the NaturalezaPeligro table using like.
	 *
	 * @param naturalezaPeligro NaturalezaPeligro
	 * @param pagination Pagination
     * @param startsWith Boolean	 
	 * @return List
	 */
	List<NaturalezaPeligro> findAllLike(NaturalezaPeligro naturalezaPeligro, Pagination pagination, Boolean startsWith) ;

	/**
	 * Counts rows in the NaturalezaPeligro table using like.
	 *
	 * @param naturalezaPeligro NaturalezaPeligro
     * @param startsWith Boolean	 
	 * @return Long
	 */
	Long findAllLikeCount(NaturalezaPeligro naturalezaPeligro, Boolean startsWith) ;
  
	/**
	 * Deletes a single row in the NaturalezaPeligro table.
	 *
	 * @param naturalezaPeligro NaturalezaPeligro
	 * @return 
	 */
	void remove(NaturalezaPeligro naturalezaPeligro);
	
	/**
	 * Deletes multiple rows in the NaturalezaPeligro table.
	 *
	 * @param naturalezaPeligroList List
	 * @return 
	 */	
	void removeMultiple(List<NaturalezaPeligro> naturalezaPeligroList);
    
}


