package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.MunicipiDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Municipi;

/**
 * MunicipiServiceImpl  
 *  
 */

@Service(value = "municipiService")
public class MunicipiServiceImpl implements MunicipiService {

	@Autowired
	private MunicipiDao municipiDao;

	/**
	 * Inserts a single row in the Municipi table.
	 *
	 * @param municipi Municipi
	 * @return Municipi
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Municipi add(Municipi municipi) {
		return this.municipiDao.add(municipi);
	}

	/**
	 * Updates a single row in the Municipi table.
	 *
	 * @param municipi Municipi
	 * @return Municipi
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Municipi update(Municipi municipi) {
		return this.municipiDao.update(municipi);
	 }

	/**
	 * Finds a single row in the Municipi table.
	 *
	 * @param municipi Municipi
	 * @return Municipi
	 */
	public Municipi find(Municipi municipi) {
		return (Municipi) this.municipiDao.find(municipi);
	}

	/**
	 * Finds a List of rows in the Municipi table.
	 *
	 * @param municipi Municipi
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Municipi> findAll(Municipi municipi, Pagination pagination) {
		return (List<Municipi>) this.municipiDao.findAll(municipi, pagination);
	}
    
	/**
	 * Counts rows in the Municipi table.
	 *
	 * @param municipi Municipi
	 * @return Long
	 */
	public Long findAllCount(Municipi municipi) {        
		return  this.municipiDao.findAllCount(municipi);
	}

	/**
	 * Finds rows in the Municipi table using like.
	 *
	 * @param municipi Municipi
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Municipi> findAllLike(Municipi municipi, Pagination pagination, Boolean startsWith) {
		return (List<Municipi>) this.municipiDao.findAllLike(municipi, pagination, startsWith);
	}

	/**
	 * Counts rows in the Municipi table using like.
	 *
	 * @param municipi Municipi
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Municipi municipi, Boolean startsWith) {
		return this.municipiDao.findAllLikeCount(municipi, startsWith);
	}
	    
	/**
	 * Deletes a single row in the Municipi table.
	 *
	 * @param municipi Municipi
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Municipi municipi) {
		this.municipiDao.remove(municipi);
	}
	
	/**
	 * Deletes multiple rows in the Municipi table.
	 *
	 * @param municipiList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Municipi> municipiList) {
		for (Municipi  municipiAux:municipiList) {
			this.municipiDao.remove(municipiAux);
		}
	}
	
}

