package com.ejie.y41b.service;


import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Municipi;

/**
 * MunicipiService  
 *  
 */

public interface MunicipiService {

	/**
	 * Inserts a single row in the Municipi table.
	 *
	 * @param municipi Municipi
	 * @return Municipi
	 */
    Municipi add(Municipi municipi);

	/**
	 * Updates a single row in the Municipi table.
	 *
	 * @param municipi Municipi
	 * @return Municipi
	 */
	Municipi update(Municipi municipi);

	/**
	 * Finds a single row in the Municipi table.
	 *
	 * @param municipi Municipi
	 * @return Municipi
	 */
	Municipi find(Municipi municipi);

	/**
	 * Finds a List of rows in the Municipi table.
	 *
	 * @param municipi Municipi
	 * @param pagination Pagination
	 * @return List
	 */
	List<Municipi> findAll(Municipi municipi, Pagination pagination);

	/**
	 * Counts rows in the Municipi table.
	 *
	 * @param municipi Municipi
	 * @return Long
	 */
	Long findAllCount(Municipi municipi);
	
	/**
	 * Finds rows in the Municipi table using like.
	 *
	 * @param municipi Municipi
	 * @param pagination Pagination
     * @param startsWith Boolean	 
	 * @return List
	 */
	List<Municipi> findAllLike(Municipi municipi, Pagination pagination, Boolean startsWith) ;

	/**
	 * Counts rows in the Municipi table using like.
	 *
	 * @param municipi Municipi
     * @param startsWith Boolean	 
	 * @return Long
	 */
	Long findAllLikeCount(Municipi municipi, Boolean startsWith) ;
  
	/**
	 * Deletes a single row in the Municipi table.
	 *
	 * @param municipi Municipi
	 * @return 
	 */
	void remove(Municipi municipi);
	
	/**
	 * Deletes multiple rows in the Municipi table.
	 *
	 * @param municipiList List
	 * @return 
	 */	
	void removeMultiple(List<Municipi> municipiList);
    
}


